/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.message;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.network.NetworkEvent;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.data.DataHandler;
import sirttas.dpanvil.data.network.message.DataManagerMessage;
import sirttas.dpanvil.registry.RegistryListener;

public class ReloadDataMessage {
    private final List<DataManagerMessage<?, ?>> messages;

    public ReloadDataMessage() {
        this.messages = Lists.newArrayList();
    }

    public ReloadDataMessage(Collection<ResourceKey<IDataManager<?>>> managers) {
        this.messages = managers.stream().map(DataManagerMessage::new).collect(Collectors.toList());
    }

    public static ReloadDataMessage decode(FriendlyByteBuf buf) {
        ReloadDataMessage message = new ReloadDataMessage();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            DataManagerMessage managerMessage = new DataManagerMessage(buf.m_130281_());
            managerMessage.decode(buf);
            message.messages.add(managerMessage);
        }
        return message;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.messages.size());
        for (DataManagerMessage<?, ?> message : this.messages) {
            buf.m_130085_(message.getId());
            message.encode(buf);
        }
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
        supplierArray[0] = () -> ((FriendlyByteBuf)buf).writerIndex();
        DataPackAnvilApi.LOGGER.debug("Sending DataPack Anvil packet with size: {} bytes", supplierArray);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> RegistryListener.getInstance().listen(r -> {
            this.messages.forEach(DataManagerMessage::process);
            DataHandler.onDPAnvilUpdate();
        }));
        ctx.get().setPacketHandled(true);
    }
}

