/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.transfer.path;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;
import sirttas.elementalcraft.api.element.transfer.path.InvalidElementTransferPath;

public class SimpleElementTransferPathfinder {
    private ElementType type = ElementType.NONE;
    private final Deque<AbstractNode> nodes;
    private final List<ProcessedNode> path;
    private final List<IElementTransferer> visited;
    private final Level level;
    private IElementStorage target;

    public SimpleElementTransferPathfinder(Level level) {
        this.level = level;
        this.nodes = new ArrayDeque<AbstractNode>();
        this.path = new ArrayList<ProcessedNode>();
        this.visited = new ArrayList<IElementTransferer>();
    }

    public IElementTransferPath findPath(ElementType type, IElementTransferPathNode source, IElementTransferPathNode first) {
        if (type != ElementType.NONE) {
            ProfilerFiller profiler = this.level.m_46473_();
            profiler.m_6180_("elementalcraft:simple_element_transfer_pathfinding");
            this.type = type;
            this.target = null;
            this.nodes.clear();
            this.path.clear();
            this.visited.clear();
            this.nodes.push(new ConnectNode(null, first.getPos(), first.getTransferer()));
            while (!this.nodes.isEmpty() && this.target == null) {
                this.nodes.pop().run();
            }
            profiler.m_7238_();
            if (this.target != null) {
                this.path.add(0, ProcessedNode.wrap(source));
                return new Path(source.getStorage(), this.target, type, this.path);
            }
        }
        return InvalidElementTransferPath.INSTANCE;
    }

    private class ConnectNode
    extends AbstractNode {
        private final IElementTransferer transferer;

        private ConnectNode(ConnectNode parent, BlockPos pos, IElementTransferer transferer) {
            super(parent, pos);
            this.transferer = transferer;
        }

        @Override
        public void run() {
            this.transferer.getConnectedNodes(SimpleElementTransferPathfinder.this.type).forEach(node -> {
                IElementTransferer nodeTransferer;
                BlockPos nodePos = node.getPos();
                IElementStorage nodeStorage = node.getStorage();
                if (nodeStorage != null && nodeStorage.insertElement(1, SimpleElementTransferPathfinder.this.type, true) == 0) {
                    SimpleElementTransferPathfinder.this.nodes.push(new InsertNode(this, nodePos, nodeStorage));
                }
                if ((nodeTransferer = node.getTransferer()) != null && !SimpleElementTransferPathfinder.this.visited.contains(nodeTransferer) && nodeTransferer.isValid()) {
                    SimpleElementTransferPathfinder.this.visited.add(nodeTransferer);
                    SimpleElementTransferPathfinder.this.nodes.push(new ConnectNode(this, nodePos, nodeTransferer));
                }
            });
        }
    }

    private abstract class AbstractNode
    implements Runnable {
        protected final ConnectNode parent;
        protected final BlockPos pos;

        private AbstractNode(ConnectNode parent, BlockPos pos) {
            this.parent = parent;
            this.pos = pos;
        }
    }

    private record ProcessedNode(IElementTransferer transferer, IElementStorage storage, BlockPos pos) implements IElementTransferPathNode
    {
        public static ProcessedNode wrap(IElementTransferPathNode node) {
            return new ProcessedNode(node.getTransferer(), node.getStorage(), node.getPos());
        }

        public boolean isValid() {
            return this.transferer == null || this.transferer.isValid();
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public IElementTransferer getTransferer() {
            return this.transferer;
        }

        @Override
        public IElementStorage getStorage() {
            return this.storage;
        }
    }

    private record Path(IElementStorage source, IElementStorage target, ElementType type, List<ProcessedNode> nodes) implements IElementTransferPath
    {
        public Path {
            nodes = List.copyOf(nodes);
        }

        @Override
        public boolean isValid() {
            return !this.nodes.isEmpty() && this.target != null && this.nodes.stream().allMatch(ProcessedNode::isValid);
        }

        private int getRemainingTransferAmount() {
            return this.nodes.stream().map(IElementTransferPathNode::getTransferer).filter(Objects::nonNull).mapToInt(IElementTransferer::getRemainingTransferAmount).min().orElse(0);
        }

        @Override
        public void transfer() {
            if (!this.isValid()) {
                return;
            }
            IElementTransferPath.transfer(this.type, this.source.transferTo(this.target, this.type, this.getRemainingTransferAmount()), this.getNodes());
        }

        @Override
        public List<IElementTransferPathNode> getNodes() {
            return List.copyOf(this.nodes);
        }

        @Override
        public ElementType getElementType() {
            return this.type;
        }
    }

    private class InsertNode
    extends AbstractNode {
        private final IElementStorage storage;

        private InsertNode(ConnectNode parent, BlockPos pos, IElementStorage storage) {
            super(parent, pos);
            this.storage = storage;
        }

        @Override
        public void run() {
            SimpleElementTransferPathfinder.this.target = this.storage;
            ConnectNode p = this.parent;
            while (p != null) {
                SimpleElementTransferPathfinder.this.path.add(new ProcessedNode(p.transferer, null, p.pos));
                p = p.parent;
            }
            SimpleElementTransferPathfinder.this.path.add(new ProcessedNode(null, this.storage, this.pos));
        }
    }
}

