/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;

public class SourceTraitHolderHelper {
    private SourceTraitHolderHelper() {
    }

    @Nonnull
    public static LazyOptional<ISourceTraitHolder> get(ICapabilityProvider provider) {
        return SourceTraitHolderHelper.get(provider, null);
    }

    @Nonnull
    public static LazyOptional<ISourceTraitHolder> get(ICapabilityProvider provider, Direction side) {
        return ElementalCraftCapabilities.SOURCE_TRAIT_HOLDER != null && provider != null ? provider.getCapability(ElementalCraftCapabilities.SOURCE_TRAIT_HOLDER, side) : LazyOptional.empty();
    }

    @Nullable
    public static <T extends Tag, S extends ISourceTraitHolder & INBTSerializable<T>> ICapabilityProvider createProvider(S holder) {
        return ElementalCraftCapabilities.SOURCE_TRAIT_HOLDER != null ? new CapabilityProvider(holder) : null;
    }

    private record CapabilityProvider<T extends Tag, S extends ISourceTraitHolder & INBTSerializable<T>>(S holder) implements ICapabilitySerializable<T>
    {
        @NotNull
        public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
            return ElementalCraftCapabilities.SOURCE_TRAIT_HOLDER.orEmpty(cap, LazyOptional.of(() -> this.holder));
        }

        public T serializeNBT() {
            return (T)((INBTSerializable)this.holder).serializeNBT();
        }

        public void deserializeNBT(T nbt) {
            ((INBTSerializable)this.holder).deserializeNBT(nbt);
        }
    }
}

