/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.container.ECContainerHelper;

public abstract class AbstractECContainerBlock
extends AbstractECEntityBlock {
    protected AbstractECContainerBlock() {
    }

    protected AbstractECContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private boolean canInsertStack(IItemHandler inventory, ItemStack stack, ItemStack heldItem, int slot) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)heldItem) && stack.m_41613_() < stack.m_41741_() && stack.m_41613_() < inventory.getSlotLimit(slot);
    }

    public InteractionResult onSlotActivated(IItemHandler inventory, Player player, ItemStack heldItem, int slot) {
        ItemStack stack = inventory.getStackInSlot(slot);
        Level world = player.m_9236_();
        if (heldItem.m_41619_() || player.m_6144_() || !stack.m_41619_() && !this.canInsertStack(inventory, stack, heldItem, slot)) {
            if (!stack.m_41619_()) {
                if (!world.m_5776_()) {
                    ItemStack extracted = inventory.extractItem(slot, stack.m_41613_(), false);
                    world.m_7967_((Entity)new ItemEntity(world, player.m_20185_(), player.m_20186_() + 0.25, player.m_20189_(), extracted));
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (stack.m_41619_() && inventory.isItemValid(slot, heldItem)) {
            int size = Math.min(heldItem.m_41613_(), inventory.getSlotLimit(slot));
            stack = heldItem.m_41777_();
            stack.m_41764_(size);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(size);
            }
            inventory.insertItem(slot, stack, false);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.canInsertStack(inventory, stack, heldItem, slot)) {
            int size = Math.min(heldItem.m_41613_(), inventory.getSlotLimit(slot) - stack.m_41613_());
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(size);
            }
            stack.m_41769_(size);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onSingleSlotActivated(Level world, BlockPos pos, Player player, InteractionHand hand) {
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)world, pos, null);
        ItemStack heldItem = player.m_21120_(hand);
        if (inv != null && hand == InteractionHand.MAIN_HAND) {
            return this.onSlotActivated(inv, player, heldItem, 0);
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos pos) {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos));
    }
}

