/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.AbstractShrineUpgradeBlock;

public abstract class AbstractShrineBlock<T extends AbstractShrineBlockEntity>
extends AbstractECEntityBlock
implements SimpleWaterloggedBlock,
IElementTypeProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final ElementType elementType;
    private BlockEntityType<T> entityType;

    protected AbstractShrineBlock(ElementType elementType) {
        this.elementType = elementType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, AbstractShrineBlockEntity.class).ifPresent(shrine -> shrine.getUpgradeDirections().forEach(direction -> {
                AbstractShrineUpgradeBlock upgrade;
                BlockPos newPos = pos.m_121945_(direction);
                BlockState upgradeState = level.m_8055_(newPos);
                Block block = upgradeState.m_60734_();
                if (block instanceof AbstractShrineUpgradeBlock && (upgrade = (AbstractShrineUpgradeBlock)block).getFacing(upgradeState) == direction.m_122424_()) {
                    level.m_46961_(newPos, true);
                }
            }));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        AbstractShrineBlockEntity shrine = (AbstractShrineBlockEntity)level.m_7702_(pos);
        if (shrine != null && player.m_21120_(hand).m_41619_() && player.m_6144_()) {
            if (level.f_46443_) {
                shrine.startShowingRange();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{this.elementType.getDisplayName()}).m_130940_(ChatFormatting.YELLOW));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, AbstractShrineBlockEntity.class).filter(AbstractShrineBlockEntity::isRunning).ifPresent(s -> this.doAnimateTick((AbstractShrineBlockEntity)s, state, level, pos, rand));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void doAnimateTick(AbstractShrineBlockEntity shrine, BlockState state, Level world, BlockPos pos, RandomSource rand) {
    }

    public T newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return (T)((AbstractShrineBlockEntity)this.getEntityType().m_155264_(pos, state));
    }

    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<U> type) {
        return AbstractShrineBlock.createECTicker(level, type, this.getEntityType(), level.f_46443_ ? AbstractShrineBlockEntity::clientTick : AbstractShrineBlockEntity::serverTick);
    }

    private BlockEntityType<T> getEntityType() {
        if (this.entityType == null) {
            this.entityType = (BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(ForgeRegistries.BLOCKS.getKey((Object)this));
        }
        return this.entityType;
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }
}

