/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorList;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.shrine.ShrineElementStorage;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.properties.ShrineRange;
import sirttas.elementalcraft.block.shrine.upgrade.AbstractShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlockEntity;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.air.TranslocationSpell;

public abstract class AbstractShrineBlockEntity
extends AbstractECBlockEntity
implements IElementTypeProvider {
    protected static final List<Direction> DEFAULT_UPGRADE_DIRECTIONS = List.of(Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    protected final Holder<ShrineProperties> properties;
    private final Map<Direction, ShrineUpgrade> upgrades = new EnumMap<Direction, ShrineUpgrade>(Direction.class);
    private final Map<ShrineUpgrade.BonusType, Float> upgradeMultipliers = new EnumMap<ShrineUpgrade.BonusType, Float>(ShrineUpgrade.BonusType.class);
    protected final ShrineElementStorage elementStorage = new ShrineElementStorage(this);
    private boolean running = false;
    private double tick = 0.0;
    private int rangeRenderTimer = 0;
    private BlockPos targetPos;

    protected AbstractShrineBlockEntity(RegistryObject<? extends BlockEntityType<?>> blockEntityType, BlockPos pos, BlockState state, ResourceKey<ShrineProperties> upgradeKey) {
        super((Supplier<? extends BlockEntityType<?>>)blockEntityType, pos, state);
        this.properties = ElementalCraft.SHRINE_PROPERTIES_MANAGER.getOrCreateHolder(upgradeKey);
        this.targetPos = pos;
    }

    @Nonnull
    protected static ResourceKey<ShrineProperties> createKey(@Nonnull String name) {
        return IDataManager.createKey(ElementalCraft.SHRINE_PROPERTIES_MANAGER_KEY, (ResourceLocation)ElementalCraft.createRL(name));
    }

    protected int consumeElement(int i) {
        this.running = true;
        return this.elementStorage.extractElement(i, false);
    }

    protected abstract boolean doPeriod();

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractShrineBlockEntity shrine) {
        if (!shrine.isTargetPosValid(shrine.targetPos)) {
            shrine.targetPos = shrine.m_58899_();
            shrine.m_6596_();
        }
        if (shrine.isDirty()) {
            shrine.refresh();
        }
        double period = shrine.getPeriod();
        int consumeAmount = shrine.getConsumeAmount();
        boolean running = shrine.running;
        if (!shrine.isPowered()) {
            shrine.tick += 1.0;
            if (period <= 0.0) {
                ElementalCraftApi.LOGGER.warn("Shrine period should not be 0");
                period = 1.0;
            }
            while (shrine.tick >= period) {
                shrine.running = false;
                if (shrine.elementStorage.getElementAmount() >= consumeAmount && shrine.doPeriod()) {
                    shrine.consumeElement(consumeAmount);
                }
                shrine.tick -= period;
            }
        } else {
            shrine.running = false;
        }
        if (running != shrine.running) {
            shrine.m_6596_();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AbstractShrineBlockEntity shrine) {
        if (shrine.rangeRenderTimer > 0) {
            --shrine.rangeRenderTimer;
        }
    }

    public void refresh() {
        BlockPos blockPos = this.m_58899_();
        if (!this.m_58898_()) {
            this.targetPos = blockPos;
            return;
        }
        this.elementStorage.refresh();
        this.upgrades.clear();
        this.upgradeMultipliers.clear();
        this.getUpgradeDirections().forEach(direction -> {
            ShrineUpgrade upgrade;
            AbstractShrineUpgradeBlock upgradeBlock;
            BlockPos pos = blockPos.m_121945_(direction);
            BlockState state = this.f_58857_.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof AbstractShrineUpgradeBlock && (upgradeBlock = (AbstractShrineUpgradeBlock)block).getFacing(state) == direction.m_122424_() && (upgrade = upgradeBlock.getUpgrade()) != null) {
                this.setUpgrade((Direction)direction, upgrade);
            }
        });
        this.getUpgradeDirections().forEach(direction -> {
            BlockPos pos = blockPos.m_121945_(direction);
            BlockState state = this.f_58857_.m_8055_(pos);
            if (!state.m_60710_((LevelReader)this.f_58857_, pos)) {
                this.f_58857_.m_46961_(pos, true);
            }
        });
        this.targetPos = this.upgrades.entrySet().stream().filter(e -> ((ShrineUpgrade)e.getValue()).is(ShrineUpgrades.TRANSLOCATION)).findFirst().flatMap(e -> BlockEntityHelper.getBlockEntityAs((BlockGetter)this.f_58857_, blockPos.m_121945_((Direction)e.getKey()), TranslocationShrineUpgradeBlockEntity.class)).map(TranslocationShrineUpgradeBlockEntity::getTarget).filter(this::isTargetPosValid).orElse(blockPos);
    }

    private boolean isTargetPosValid(BlockPos p) {
        BlockPos blockPos = this.m_58899_();
        if (blockPos.equals((Object)p)) {
            return true;
        }
        if (p == null || this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            return true;
        }
        float maxRange = ((TranslocationSpell)Spells.TRANSLOCATION.get()).getRange(null);
        if (maxRange <= 0.0f) {
            throw new IllegalStateException("Translocation spell range should not be 0");
        }
        float maxRangeSq = maxRange * maxRange;
        double rangeSq = p.m_123331_((Vec3i)blockPos);
        if (rangeSq > (double)maxRangeSq) {
            return false;
        }
        TranslocationAnchorList list = TranslocationAnchorList.get(this.f_58857_);
        return list != null && list.getAnchors().contains(p);
    }

    protected float getMultiplier(ShrineUpgrade.BonusType type) {
        return this.upgradeMultipliers.getOrDefault((Object)type, Float.valueOf(1.0f)).floatValue();
    }

    public int getUpgradeCount(ShrineUpgrade upgrade) {
        return upgrade == null ? 0 : (int)this.upgrades.values().stream().filter(upgrade::equals).count();
    }

    public int getUpgradeCount(ResourceKey<ShrineUpgrade> key) {
        return key == null ? 0 : (int)this.upgrades.values().stream().filter(u -> u.is(key)).count();
    }

    public boolean hasUpgrade(ShrineUpgrade upgrade) {
        return this.getUpgradeCount(upgrade) > 0;
    }

    public boolean hasUpgrade(ResourceKey<ShrineUpgrade> key) {
        return this.getUpgradeCount(key) > 0;
    }

    private void setUpgrade(Direction direction, ShrineUpgrade upgrade) {
        ShrineUpgrade old = this.upgrades.get(direction);
        if (old != null) {
            old.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) / bonus.floatValue())));
        }
        this.upgrades.put(direction, upgrade);
        upgrade.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) * bonus.floatValue())));
    }

    public Collection<ShrineUpgrade> getAllUpgrades() {
        return this.upgrades.values();
    }

    public List<Direction> getUpgradeDirections() {
        return DEFAULT_UPGRADE_DIRECTIONS;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean showsRange() {
        return this.rangeRenderTimer > 0;
    }

    public void startShowingRange() {
        this.rangeRenderTimer = 600;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public Stream<BlockPos> getBlocksInRange() {
        AABB box = this.getRange();
        return this.getRange(box.f_82288_, box.f_82291_).mapToObj(x -> this.getRange(box.f_82290_, box.f_82293_).mapToObj(z -> this.getRange(box.f_82289_, box.f_82292_).mapToObj(y -> new BlockPos(x, y, z)))).mapMulti((s, downstream) -> s.forEach(s2 -> s2.forEach(downstream)));
    }

    @Nonnull
    private IntStream getRange(double min, double max) {
        return IntStream.range((int)Math.floor(min + 1.0E-5), (int)Math.ceil(max - 1.0E-5));
    }

    @Override
    public ElementType getElementType() {
        return this.getProperties().getElementType();
    }

    public AABB getRange() {
        ShrineRange range = this.getProperties().range();
        return this.getRange(range.box(), range.stitch(), range.fixedHeight());
    }

    protected AABB getRange(AABB box, boolean stitch, boolean fixedHeight) {
        float multiplier = this.getMultiplier(ShrineUpgrade.BonusType.RANGE);
        box = fixedHeight ? new AABB(box.f_82288_ * (double)multiplier, box.f_82289_, box.f_82290_ * (double)multiplier, box.f_82291_ * (double)multiplier, box.f_82292_, box.f_82293_ * (double)multiplier) : new AABB(box.f_82288_ * (double)multiplier, box.f_82289_ * (double)multiplier, box.f_82290_ * (double)multiplier, box.f_82291_ * (double)multiplier, box.f_82292_ * (double)multiplier, box.f_82293_ * (double)multiplier);
        if (stitch) {
            box = ElementalCraftUtils.stitchAABB(box);
        }
        return box.m_82338_(this.getTargetPos());
    }

    public int getConsumeAmount() {
        return Math.round((float)this.getProperties().consumption() * this.getMultiplier(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION));
    }

    public double getPeriod() {
        return this.getProperties().period() * (double)this.getMultiplier(ShrineUpgrade.BonusType.SPEED);
    }

    @Nonnull
    public ShrineProperties getProperties() {
        if (this.properties.m_203633_()) {
            return (ShrineProperties)this.properties.m_203334_();
        }
        return ShrineProperties.DEFAULT;
    }

    public int getCapacity() {
        return Math.round((float)this.getProperties().capacity() * this.getMultiplier(ShrineUpgrade.BonusType.CAPACITY));
    }

    public double getStrength() {
        return this.getStrength(0);
    }

    public double getStrength(int index) {
        List<Double> strength = this.getProperties().strength();
        if (strength.size() <= index) {
            ElementalCraftApi.LOGGER.warn("Shrine strength index out of bounds: {} for shrine {}", new org.apache.logging.log4j.util.Supplier[]{() -> index, () -> ForgeRegistries.BLOCKS.getKey((Object)this.m_58900_().m_60734_())});
            return 1.0;
        }
        Double value = this.getProperties().strength().get(index);
        return (value != null ? value : 1.0) * (double)this.getMultiplier(ShrineUpgrade.BonusType.STRENGTH);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("element_storage")) {
            this.elementStorage.deserializeNBT(compound.m_128469_("element_storage"));
        }
        this.running = compound.m_128471_("running");
        this.refresh();
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("element_storage", (Tag)this.elementStorage.serializeNBT());
        compound.m_128379_("running", this.running);
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ElementalCraftCapabilities.ELEMENT_STORAGE) {
            return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
        }
        return super.getCapability(cap, side);
    }

    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }
}

