/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.budding;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.ore.OreShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;

public class BuddingShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = BuddingShrineBlockEntity.createKey("buddingshrine");
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    private static final Lazy<List<Block>> AMETHYSTS = Lazy.of(() -> List.of(Blocks.f_152495_, Blocks.f_152494_, Blocks.f_152493_, Blocks.f_152492_));
    private static final Lazy<List<Block>> SPRINGALINES = Lazy.of(() -> List.of((Block)ECBlocks.SMALL_SPRINGALINE_BUD.get(), (Block)ECBlocks.MEDIUM_SPRINGALINE_BUD.get(), (Block)ECBlocks.LARGE_SPRINGALINE_BUD.get(), (Block)ECBlocks.SPRINGALINE_CLUSTER.get()));

    public BuddingShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.BUDDING_SHRINE, pos, state, PROPERTIES_KEY);
    }

    @Override
    public AABB getRange() {
        return new AABB(this.above());
    }

    private BlockPos above() {
        return this.getTargetPos().m_7494_();
    }

    @Override
    protected boolean doPeriod() {
        return switch ((BuddingShrineBlock.CrystalType)((Object)this.m_58900_().m_61143_(BuddingShrineBlock.CRYSTAL_TYPE))) {
            case BuddingShrineBlock.CrystalType.SPRINGALINE -> this.grow((List)SPRINGALINES.get());
            default -> this.grow((List)AMETHYSTS.get());
        };
    }

    private boolean grow(List<Block> blocks) {
        BlockState state = this.f_58857_.m_8055_(this.above());
        if (BuddingAmethystBlock.m_152734_((BlockState)state)) {
            this.setBud(blocks.get(0), state);
            return true;
        }
        Iterator<Block> it = blocks.iterator();
        while (it.hasNext()) {
            if (!state.m_60713_(it.next())) continue;
            if (it.hasNext()) {
                this.setBud(it.next(), state);
                return true;
            }
            Level level = this.f_58857_;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.hasUpgrade(ShrineUpgrades.CRYSTAL_HARVEST)) continue;
            BlockPos above = this.f_58858_.m_7494_();
            OreShrineBlockEntity.harvest(serverLevel, above, this, Blocks.f_50016_.m_49966_());
            return true;
        }
        return false;
    }

    private void setBud(Block block, BlockState state) {
        this.f_58857_.m_46597_(this.above(), (BlockState)((BlockState)block.m_49966_().m_61124_((Property)AmethystClusterBlock.f_152006_, (Comparable)Direction.UP)).m_61124_((Property)AmethystClusterBlock.f_152005_, (Comparable)Boolean.valueOf(state.m_60819_().m_76152_() == Fluids.f_76193_)));
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

