/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.lumber;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.vertical.PlantingShrineUpgradeBlock;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.tag.ECTags;

public class LumberShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = LumberShrineBlockEntity.createKey("lumbershrine");

    public LumberShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.LUMBER_SHRINE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findTreeBlock() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.getBlocksInRange().filter(p -> this.f_58857_.m_8055_(p).m_204336_(ECTags.Blocks.TREE_PARTS)).findAny();
    }

    private void handlePlanting(BlockPos pos, List<ItemStack> loots) {
        if (this.hasUpgrade(ShrineUpgrades.PLANTING)) {
            int y = this.f_58858_.m_123342_();
            loots.stream().filter(stack -> {
                BlockItem blockItem;
                Item patt1743$temp = stack.m_41720_();
                return patt1743$temp instanceof BlockItem && (blockItem = (BlockItem)patt1743$temp).m_40614_() instanceof IPlantable;
            }).findFirst().ifPresent(seeds -> {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                boolean hasPlanted = false;
                do {
                    hasPlanted = PlantingShrineUpgradeBlock.plant(seeds, this.f_58857_, (BlockPos)mutablePos);
                    mutablePos.m_122173_(Direction.DOWN);
                } while (!hasPlanted && mutablePos.m_123342_() >= y);
                if (hasPlanted) {
                    seeds.m_41774_(1);
                    if (seeds.m_41619_()) {
                        loots.remove(seeds);
                    }
                }
            });
        }
    }

    @Override
    protected boolean doPeriod() {
        if (this.f_58857_ instanceof ServerLevel && !this.f_58857_.f_46443_) {
            return this.findTreeBlock().map(p -> {
                List<ItemStack> loots = LootHelper.getDrops((ServerLevel)this.f_58857_, p, this.hasUpgrade(ShrineUpgrades.SILK_TOUCH) ? new ItemStack((ItemLike)Items.f_42574_) : ItemStack.f_41583_);
                this.f_58857_.m_46961_(p, false);
                this.handlePlanting((BlockPos)p, loots);
                loots.forEach(stack -> Block.m_49840_((Level)this.f_58857_, (BlockPos)p, (ItemStack)stack));
                return true;
            }).orElse(false);
        }
        return false;
    }
}

