/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import sirttas.dpanvil.api.codec.Codecs;

public record ShrineRange(AABB box, boolean stitch, boolean fixedHeight) {
    public static final AABB DEFAULT_BOX = new AABB(BlockPos.f_121853_);
    public static final ShrineRange DEFAULT = new ShrineRange(DEFAULT_BOX, false, false);
    public static final Codec<ShrineRange> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codecs.AABB.fieldOf("box").forGetter(ShrineRange::box), (App)Codec.BOOL.optionalFieldOf("stitch", (Object)false).forGetter(ShrineRange::stitch), (App)Codec.BOOL.optionalFieldOf("fixed_height", (Object)false).forGetter(ShrineRange::fixedHeight)).apply((Applicative)builder, ShrineRange::new));

    public static Builder box(double range) {
        return ShrineRange.box(range, range);
    }

    public static Builder box(double horizontal, double vertical) {
        return ShrineRange.box(horizontal, vertical, horizontal);
    }

    public static Builder expendingUp(double horizontal, double vertical) {
        return ShrineRange.box(-horizontal, 0.0, -horizontal, horizontal + 1.0, vertical, horizontal + 1.0);
    }

    public static Builder expendingDown(double horizontal, double vertical) {
        return ShrineRange.box(-horizontal, -vertical, -horizontal, horizontal + 1.0, 0.0, horizontal + 1.0);
    }

    public static Builder box(double x, double y, double z) {
        return ShrineRange.box(-x, -y, -z, x + 1.0, y + 1.0, z + 1.0);
    }

    public static Builder box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return ShrineRange.box(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
    }

    public static Builder box(AABB aabb) {
        return new Builder(aabb);
    }

    public static class Builder {
        private final AABB box;
        private boolean stitch;
        private boolean fixedHeight;

        private Builder(AABB aabb) {
            this.box = aabb;
            this.stitch = false;
            this.fixedHeight = false;
        }

        public Builder stitch() {
            this.stitch = true;
            return this;
        }

        public Builder fixedHeight() {
            this.fixedHeight = true;
            return this;
        }

        public ShrineRange build() {
            return new ShrineRange(this.box, this.stitch, this.fixedHeight);
        }
    }
}

