/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import sirttas.elementalcraft.block.entity.renderer.IRuneRenderer;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.block.sorter.SorterBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SorterRenderer
implements IRuneRenderer<SorterBlockEntity> {
    public void render(@Nonnull SorterBlockEntity sorter, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        boolean shiftKeyDown = Minecraft.m_91087_().f_91074_.m_6144_();
        List<ItemStack> stacks = sorter.getStacks();
        if (mouseOver != null && mouseOver.m_6662_() == HitResult.Type.BLOCK && !stacks.isEmpty()) {
            poseStack.m_85836_();
            BlockHitResult result = (BlockHitResult)mouseOver;
            if (sorter.m_58899_().equals((Object)result.m_82425_())) {
                int i;
                int index = sorter.getIndex();
                Quaternionf rotation = result.m_82434_().m_253075_();
                Vector3f newPos = new Vector3f(0.0f, 0.125f, 0.0625f);
                poseStack.m_85837_(0.5, 0.5, 0.5);
                rotation.transform(newPos);
                poseStack.m_252880_(newPos.x(), newPos.y(), newPos.z());
                poseStack.m_252781_(rotation);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                ECRendererHelper.renderItem(stacks.get(index), poseStack, buffer, light, overlay);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_85836_();
                this.translate(poseStack, 0.5, shiftKeyDown);
                for (i = index - 1; i >= 0; --i) {
                    this.translate(poseStack, 0.5, shiftKeyDown);
                    ECRendererHelper.renderItem(stacks.get(i), poseStack, buffer, light, overlay);
                }
                poseStack.m_85849_();
                poseStack.m_85836_();
                this.translate(poseStack, -0.5, shiftKeyDown);
                for (i = index + 1; i < stacks.size(); ++i) {
                    this.translate(poseStack, -0.5, shiftKeyDown);
                    ECRendererHelper.renderItem(stacks.get(i), poseStack, buffer, light, overlay);
                }
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        this.renderRunes(sorter, partialTicks, poseStack, buffer, light, overlay);
    }

    private void renderRunes(SorterBlockEntity sorter, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        BlockState state = sorter.m_58900_();
        Quaternionf rotation1 = ((Direction)state.m_61143_((Property)ISorterBlock.SOURCE)).m_122424_().m_253075_();
        Quaternionf rotation2 = ((Direction)state.m_61143_((Property)ISorterBlock.TARGET)).m_253075_();
        Quaternionf rotation = new Quaternionf(rotation1.x() + rotation2.x(), rotation1.y() + rotation2.y(), rotation1.z() + rotation2.z(), rotation1.w() + rotation2.w());
        rotation.normalize();
        poseStack.m_252781_(rotation);
        poseStack.m_252880_(-0.5f, -0.75f, -0.5f);
        ECRendererHelper.renderRunes(poseStack, buffer, sorter.getRuneHandler(), ECRendererHelper.getClientTicks(partialTicks), light, overlay);
    }

    private void translate(PoseStack matrixStack, double value, boolean sneeking) {
        if (sneeking) {
            matrixStack.m_85837_(-value, 0.0, 0.0);
        } else {
            matrixStack.m_85837_(0.0, value, 0.0);
        }
    }
}

