/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.block.source.trait.value.SourceTraitValueProviderTypes;

public class ChanceSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "chance";
    public static final Codec<ChanceSourceTraitValueProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ISourceTraitValueProvider.CODEC.fieldOf("provider").forGetter(p -> p.provider), (App)Codec.FLOAT.fieldOf(NAME).forGetter(p -> Float.valueOf(p.chance)), (App)Codec.FLOAT.optionalFieldOf("chance_on_bred", (Object)Float.valueOf(-1.0f)).forGetter(p -> Float.valueOf(p.chanceOnBred))).apply((Applicative)builder, ChanceSourceTraitValueProvider::new));
    private final ISourceTraitValueProvider provider;
    private final float chance;
    private final float chanceOnBred;

    public ChanceSourceTraitValueProvider(ISourceTraitValueProvider provider, float chance, float chanceOnBred) {
        this.provider = provider;
        this.chance = chance;
        this.chanceOnBred = chanceOnBred;
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        RandomSource random = context.random();
        if (random.m_188501_() < this.chance + this.getLuckRoll(random, context.luck())) {
            return this.provider.roll(context, level, pos);
        }
        return null;
    }

    @Override
    @Nullable
    public ISourceTraitValue breed(SourceTraitRollContext context, @Nullable ISourceTraitValue value1, @Nullable ISourceTraitValue value2) {
        RandomSource random = context.random();
        int count = (value1 != null ? 1 : 0) + (value2 != null ? 1 : 0);
        if (count >= 2 || random.m_188501_() < this.getBreedChance(count) + this.getLuckRoll(random, context.luck())) {
            return this.provider.breed(context, value1, value2);
        }
        return null;
    }

    private float getLuckRoll(RandomSource random, float luck) {
        return luck > 0.0f ? random.m_188501_() * luck / 4.0f : 0.0f;
    }

    private float getBreedChance(int count) {
        return (this.chanceOnBred >= 0.0f ? this.chanceOnBred : this.chance) + (float)count * 0.5f;
    }

    @NotNull
    public SourceTraitValueProviderType<ChanceSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.CHANCE.get();
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        return this.provider.load(tag);
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        return this.provider.save(value);
    }
}

