/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.rune;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandlerHelper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.pipe.IPipeInteractingItem;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.property.ECProperties;

public class RuneItem
extends ECItem
implements IPipeInteractingItem {
    public static final String NAME = "rune";

    public RuneItem() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        return this.doUse(BlockEntityHelper.getRuneHandlerAt((LevelReader)context.m_43725_(), context.m_8083_()), context);
    }

    @Override
    @Nonnull
    public InteractionResult useOnPipe(@Nonnull ElementPipeBlockEntity pipe, @Nonnull UseOnContext context) {
        return this.doUse(RuneHandlerHelper.get((ICapabilityProvider)pipe, context.m_43719_()), context);
    }

    @Nonnull
    public InteractionResult doUse(IRuneHandler handler, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        Rune rune = RuneItem.getRune(stack);
        if (rune != null && rune.canUpgrade((LevelReader)level, pos, context.m_43719_(), handler)) {
            handler.addRune(rune);
            if (player != null && !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Rune getRune(ItemStack stack) {
        CompoundTag tag = NBTHelper.getECTag(stack);
        if (tag != null) {
            return (Rune)ElementalCraftApi.RUNE_MANAGER.get(new ResourceLocation(tag.m_128461_(NAME)));
        }
        return null;
    }

    public ItemStack getRuneStack(Rune rune) {
        ItemStack stack = new ItemStack((ItemLike)this);
        NBTHelper.getOrCreateECTag(stack).m_128359_(NAME, rune.getId().toString());
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        Rune rune = RuneItem.getRune(stack);
        if (rune != null) {
            rune.addInformation(tooltip);
        }
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Rune rune = RuneItem.getRune(stack);
        if (rune != null) {
            return rune.getDisplayName();
        }
        return super.m_7626_(stack);
    }
}

