/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.jewel.Jewels;

public class Jewel
implements IElementTypeProvider {
    private final ElementType elementType;
    private final int consumption;
    protected boolean ticking = true;
    private ResourceLocation key;

    protected Jewel(ElementType elementType, int consumption) {
        this.elementType = elementType;
        this.consumption = consumption;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public int getConsumption() {
        return this.consumption;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public ResourceLocation getKey() {
        if (this.key == null) {
            this.key = Jewels.REGISTRY.get().getKey((Object)this);
        }
        return this.key;
    }

    public ResourceLocation getModelName() {
        ResourceLocation id = this.getKey();
        return new ResourceLocation(id.m_135827_(), "elementalcraft/jewels/" + id.m_135815_());
    }

    public Component getDisplayName() {
        ResourceLocation id = this.getKey();
        return Component.m_237115_((String)("elementalcraft_jewel." + id.m_135827_() + "." + id.m_135815_()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) return true;
        }
        if (elementStorage == null) return false;
        if (elementStorage.extractElement(this.consumption, this.elementType, true) != this.consumption) return false;
        return true;
    }

    public final void consume(@Nonnull Entity entity) {
        this.consume(entity, (IElementStorage)ElementStorageHelper.get((ICapabilityProvider)entity).orElse(null));
    }

    public void consume(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (elementStorage != null) {
            elementStorage.extractElement(this.consumption, this.elementType, false);
        }
    }

    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237110_((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{this.elementType.getDisplayName()}).m_130940_(ChatFormatting.YELLOW));
    }
}

