/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.item.source.receptacle.NaturalSourceIngredient;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;
import sirttas.elementalcraft.recipe.SpellCraftRecipe;
import sirttas.elementalcraft.recipe.StaffRecipe;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;
import sirttas.elementalcraft.recipe.instrument.InscriptionRecipe;
import sirttas.elementalcraft.recipe.instrument.binding.BindingRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.InfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.io.grinding.GrindingRecipe;
import sirttas.elementalcraft.recipe.instrument.io.sawing.SawingRecipe;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECRecipeSerializers {
    private static final DeferredRegister<RecipeSerializer<?>> DEFERRED_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"elementalcraft");
    public static final RegistryObject<InfusionRecipe.Serializer> INFUSION = ECRecipeSerializers.register(InfusionRecipe.Serializer::new, "infusion");
    public static final RegistryObject<ToolInfusionRecipe.Serializer> TOOL_INFUSION = ECRecipeSerializers.register(ToolInfusionRecipe.Serializer::new, "tool_infusion");
    public static final RegistryObject<BindingRecipe.Serializer> BINDING = ECRecipeSerializers.register(BindingRecipe.Serializer::new, "binding");
    public static final RegistryObject<CrystallizationRecipe.Serializer> CRYSTALLIZATION = ECRecipeSerializers.register(CrystallizationRecipe.Serializer::new, "crystallization");
    public static final RegistryObject<InscriptionRecipe.Serializer> INSCRIPTION = ECRecipeSerializers.register(InscriptionRecipe.Serializer::new, "inscription");
    public static final RegistryObject<GrindingRecipe.Serializer> GRINDING = ECRecipeSerializers.register(GrindingRecipe.Serializer::new, "grinding");
    public static final RegistryObject<SawingRecipe.Serializer> SAWING = ECRecipeSerializers.register(SawingRecipe.Serializer::new, "sawing");
    public static final RegistryObject<PureInfusionRecipe.Serializer> PURE_INFUSION = ECRecipeSerializers.register(PureInfusionRecipe.Serializer::new, "pureinfusion");
    public static final RegistryObject<SpellCraftRecipe.Serializer> SPELL_CRAFT = ECRecipeSerializers.register(SpellCraftRecipe.Serializer::new, "spell_craft");
    public static final RegistryObject<ShapedRecipe.Serializer> STAFF = ECRecipeSerializers.register(StaffRecipe.Serializer::new, "staff");

    private ECRecipeSerializers() {
    }

    private static <R extends Recipe<?>, T extends RecipeSerializer<R>> RegistryObject<T> register(Supplier<T> serializer, String name) {
        return DEFERRED_REGISTER.register(name, serializer);
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals(ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((ResourceLocation)new ResourceLocation("elementalcraft", "natural_source"), (IIngredientSerializer)NaturalSourceIngredient.Serializer.INSTANCE);
        }
    }
}

