/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.infuser.IInfuser;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;

public class InfusionRecipe
extends AbstractInstrumentRecipe<IInfuser>
implements IInfusionRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final int elementAmount;

    public InfusionRecipe(ResourceLocation id, ElementType type, int elementAmount, ItemStack output, Ingredient input) {
        super(id, type);
        this.input = input;
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registry) {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializers.INFUSION.get();
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        @Nonnull
        public InfusionRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ElementType type = ElementType.byName(GsonHelper.m_13906_((JsonObject)json, (String)"element_type"));
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            Ingredient input = RecipeHelper.deserializeIngredient(json, "input");
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new InfusionRecipe(recipeId, type, elementAmount, output, input);
        }

        public InfusionRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.m_130277_());
            int elementAmount = buffer.readInt();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            return new InfusionRecipe(recipeId, type, elementAmount, output, input);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfusionRecipe recipe) {
            buffer.m_130070_(recipe.getElementType().m_7912_());
            buffer.writeInt(recipe.getElementAmount());
            recipe.getInput().m_43923_(buffer);
            buffer.m_130055_(recipe.output);
        }
    }
}

