/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorList;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

public class TranslocationSpell
extends Spell {
    public static final String NAME = "translocation";

    public TranslocationSpell(ResourceKey<Spell> key) {
        super(key);
    }

    public static boolean isTranslocation(ItemStack stack) {
        return SpellHelper.getSpell(stack) == Spells.TRANSLOCATION.get();
    }

    public static boolean holdsTranslocation(Player player) {
        return TranslocationSpell.isTranslocation(player.m_21205_()) || TranslocationSpell.isTranslocation(player.m_21206_());
    }

    public static BlockPos getTargetAnchor(Entity caster, List<BlockPos> anchors) {
        Vec3 playerPos = caster.m_146892_();
        Vec3 playerLook = caster.m_20154_().m_82541_();
        BlockPos target = null;
        double angle = 0.0;
        for (BlockPos pos : anchors) {
            double a = TranslocationSpell.getAngle(pos, playerPos, playerLook);
            if (!(a > 0.0) || !(a < 0.1308996938995747) || !(a < angle) && target != null) continue;
            angle = a;
            target = pos;
        }
        return target;
    }

    private static double getAngle(BlockPos pos, Vec3 playerPos, Vec3 playerLook) {
        return Math.acos(playerPos.m_82505_(Vec3.m_82539_((Vec3i)pos)).m_82541_().m_82526_(playerLook));
    }

    private void teleport(Entity caster, Vec3 newPos) {
        caster.m_6021_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Vec3 look;
        Level level = caster.m_9236_();
        Vec3 newPos = this.getNewPos(caster, level, look = caster.m_20154_());
        if (newPos == null) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            level.m_6325_((int)Math.round(newPos.f_82479_ / 16.0), (int)Math.round(newPos.f_82481_ / 16.0));
            if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new Event(caster, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_))) {
                return InteractionResult.SUCCESS;
            }
            ParticleHelper.createEnderParticle(level, caster.m_20182_(), 3, level.f_46441_);
            ParticleHelper.createEnderParticle(level, newPos, 3, level.f_46441_);
            this.delay(caster, 10, () -> {
                if (caster instanceof LivingEntity) {
                    LivingEntity livingSender = (LivingEntity)caster;
                    Vec3 oldPos = caster.m_20182_();
                    this.teleport(caster, newPos);
                    level.m_6263_(null, oldPos.f_82479_, oldPos.f_82480_, oldPos.f_82481_, SoundEvents.f_11852_, livingSender.m_5720_(), 1.0f, 1.0f);
                    livingSender.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                } else {
                    this.teleport(caster, newPos);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    private Vec3 getNewPos(@Nonnull Entity caster, Level level, Vec3 look) {
        BlockPos target;
        TranslocationAnchorList list = TranslocationAnchorList.get(level);
        if (list != null && (target = TranslocationSpell.getTargetAnchor(caster, list.getAnchors())) != null) {
            return Vec3.m_82512_((Vec3i)target);
        }
        Vec3 targetPos = caster.m_20182_().m_82549_(new Vec3(look.m_7096_(), 0.0, look.m_7094_()).m_82541_().m_82490_((double)this.getRange(caster)));
        Vec3 newPos = new Vec3(targetPos.m_7096_(), this.getHeight(level, caster, targetPos), targetPos.m_7094_());
        if (newPos.f_82480_ >= (double)level.m_6042_().f_63865_() || newPos.f_82480_ < (double)level.m_5736_()) {
            return null;
        }
        return newPos;
    }

    private double getHeight(Level world, Entity sender, Vec3 targetPos) {
        double height = (double)world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlockPos.m_274446_((Position)targetPos)).m_123342_() + 1.0;
        if (!sender.m_20096_()) {
            return Math.max(height, sender.m_20186_());
        }
        return height;
    }

    public static class Event
    extends EntityTeleportEvent {
        public Event(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }
}

