/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.ArrayDeque;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.spell.Spell;

public class SilkVeinSpell
extends Spell {
    public static final String NAME = "silk_vein";

    public SilkVeinSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private boolean isValidBlock(BlockState state) {
        return state.m_204336_(Tags.Blocks.ORES);
    }

    private void mineVein(Entity sender, Level level, BlockPos target) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        float rangeSq = this.getRange(sender);
        rangeSq *= rangeSq;
        queue.offer(target);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            BlockState state = level.m_8055_(pos);
            if (!this.isValidBlock(state) || !(pos.m_123331_((Vec3i)target) <= (double)rangeSq)) continue;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LootHelper.getDrops(serverLevel, pos, true).forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
            }
            level.m_46961_(pos, false);
            Stream.of(Direction.values()).forEach(d -> queue.offer(pos.m_121945_(d)));
        }
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        Level world = sender.m_9236_();
        if (!world.f_46443_ && this.isValidBlock(world.m_8055_(target))) {
            this.mineVein(sender, world, target);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

