/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import sirttas.elementalcraft.spell.Spell;

public class StoneWallSpell
extends Spell {
    public static final String NAME = "stonewall";

    public StoneWallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private void checkAndPlace(Level level, BlockPos pos) {
        if (level.m_8055_(pos).m_247087_()) {
            level.m_46597_(pos, Blocks.f_50069_.m_49966_());
        }
    }

    public InteractionResult cast(Entity sender, BlockPos pos, Direction direction) {
        Level world = sender.m_9236_();
        this.checkAndPlace(world, pos);
        this.checkAndPlace(world, pos.m_121945_(direction.m_122427_()));
        this.checkAndPlace(world, pos.m_121945_(direction.m_122428_()));
        this.checkAndPlace(world, pos.m_6630_(1));
        this.checkAndPlace(world, pos.m_6630_(2));
        this.checkAndPlace(world, pos.m_121945_(direction.m_122427_()).m_6630_(1));
        this.checkAndPlace(world, pos.m_121945_(direction.m_122427_()).m_6630_(2));
        this.checkAndPlace(world, pos.m_121945_(direction.m_122428_()).m_6630_(1));
        this.checkAndPlace(world, pos.m_121945_(direction.m_122428_()).m_6630_(2));
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Optional<Direction> opt = Stream.of(Direction.m_122382_((Entity)caster)).filter(d -> d.m_122434_() != Direction.Axis.Y).findFirst();
        if (!opt.isPresent()) {
            return InteractionResult.PASS;
        }
        return this.cast(caster, BlockPos.m_274446_((Position)caster.m_20182_()).m_5484_(opt.get(), 3), opt.get());
    }

    @Override
    public boolean consume(Entity sender, boolean simulate) {
        boolean value = this.consume(sender, (ItemLike)Blocks.f_50069_, 9, simulate);
        return super.consume(sender, simulate) && value;
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{Component.m_237110_((String)"tooltip.elementalcraft.count", (Object[])new Object[]{9, Blocks.f_50069_.m_49954_()})}).m_130940_(ChatFormatting.YELLOW));
    }
}

