/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.inline.utils.Spritelike;
import net.minecraft.resources.ResourceLocation;

public class TextureSprite
extends Spritelike {
    private ResourceLocation id;
    private float minU;
    private float minV;
    private float maxU;
    private float maxV;
    private int textWidth;
    private int textHeight;

    public TextureSprite(ResourceLocation id, float minU, float minV, float maxU, float maxV, int textWidth, int textHeight) {
        this.id = id;
        this.minU = minU;
        this.minV = minV;
        this.maxU = maxU;
        this.maxV = maxV;
        this.textWidth = textWidth;
        this.textHeight = textHeight;
    }

    public static TextureSprite fromPixels(ResourceLocation id, int left, int top, int width, int height, int textWidth, int textHeight) {
        return new TextureSprite(id, (float)left / (float)textWidth, (float)top / (float)textHeight, (float)(left + width) / (float)textWidth, (float)(top + height) / (float)textHeight, textWidth, textHeight);
    }

    public TextureSprite(ResourceLocation id) {
        this(id, 0.0f, 0.0f, 1.0f, 1.0f, 16, 16);
    }

    @Override
    public Spritelike.SpritelikeType getType() {
        return TextureSpriteType.INSTANCE;
    }

    @Override
    public ResourceLocation getTextureId() {
        return this.id;
    }

    @Override
    public float getMinU() {
        return this.minU;
    }

    @Override
    public float getMinV() {
        return this.minV;
    }

    @Override
    public float getMaxU() {
        return this.maxU;
    }

    @Override
    public float getMaxV() {
        return this.maxV;
    }

    @Override
    public int getTextureWidth() {
        return this.textWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textHeight;
    }

    public static class TextureSpriteType
    implements Spritelike.SpritelikeType {
        public static final TextureSpriteType INSTANCE = new TextureSpriteType();
        private static final Codec<TextureSprite> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(TextureSprite::getTextureId), (App)Codec.FLOAT.optionalFieldOf("minU", (Object)Float.valueOf(0.0f)).forGetter(TextureSprite::getMinU), (App)Codec.FLOAT.optionalFieldOf("minV", (Object)Float.valueOf(0.0f)).forGetter(TextureSprite::getMinV), (App)Codec.FLOAT.optionalFieldOf("maxU", (Object)Float.valueOf(1.0f)).forGetter(TextureSprite::getMaxU), (App)Codec.FLOAT.optionalFieldOf("maxV", (Object)Float.valueOf(1.0f)).forGetter(TextureSprite::getMaxV), (App)Codec.INT.optionalFieldOf("textWidth", (Object)16).forGetter(TextureSprite::getTextureWidth), (App)Codec.INT.optionalFieldOf("textHeight", (Object)16).forGetter(TextureSprite::getTextureHeight)).apply((Applicative)instance, TextureSprite::new));

        public Codec<TextureSprite> getCodec() {
            return CODEC;
        }

        @Override
        public String getId() {
            return "texture";
        }
    }
}

