/*
 * Decompiled with CFR 0.152.
 */
package nomowanderer.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nomowanderer.Config;
import nomowanderer.Registry;
import nomowanderer.compat.ExternalMods;
import nomowanderer.util.HoverTextUtil;
import org.jetbrains.annotations.NotNull;

public class AntiSolicitorTalismanItem
extends Item {
    public static final String ID = "no_mo_wanderer_totem";

    public AntiSolicitorTalismanItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack defaultInstance = super.m_7968_();
        CompoundTag tag = defaultInstance.m_41784_();
        tag.m_128379_("Enabled", true);
        return defaultInstance;
    }

    @NotNull
    public ItemStack getDefaultInstance(boolean enabled) {
        ItemStack defaultInstance = super.m_7968_();
        CompoundTag tag = defaultInstance.m_41784_();
        tag.m_128379_("Enabled", enabled);
        return defaultInstance;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        if (player.m_6144_() && !level.m_5776_()) {
            CompoundTag tag;
            ItemStack item = player.m_21120_(hand);
            tag.m_128379_("Enabled", !(tag = item.m_41784_()).m_128471_("Enabled"));
            return InteractionResultHolder.m_19098_((Object)item);
        }
        return super.m_7203_(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> toolTips, @NotNull TooltipFlag flag) {
        AntiSolicitorTalismanItem.addEnabledTooltip(stack, toolTips);
        if (Screen.m_96638_()) {
            HoverTextUtil.addCommonText(toolTips, Config.TALISMAN_WATCH_RADIUS);
            String totemMessage = String.format("Can be anywhere in your inventory%s.", ExternalMods.CURIOS.isLoaded() ? " or a Curios slot" : "");
            toolTips.add((Component)Component.m_237113_((String)totemMessage).m_130940_(ChatFormatting.YELLOW));
            toolTips.add((Component)Component.m_237113_((String)"Sneak right-click ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"to toggle on/off").m_130940_(ChatFormatting.GRAY)));
        } else {
            HoverTextUtil.addHoldShiftText(toolTips);
        }
        super.m_7373_(stack, level, toolTips, flag);
    }

    private static void addEnabledTooltip(@NotNull ItemStack stack, @NotNull List<Component> toolTips) {
        boolean enabled = AntiSolicitorTalismanItem.isEnabled(stack);
        toolTips.add((Component)Component.m_237113_((String)"Enabled: ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(enabled ? "Yes" : "No")).m_130940_(enabled ? ChatFormatting.GREEN : ChatFormatting.RED)));
    }

    public static boolean isEnabled(ItemStack stack) {
        if (!stack.m_41720_().equals(Registry.NO_SOLICITING_TALISMAN.get())) {
            return false;
        }
        if (stack.m_41783_() == null) {
            return true;
        }
        return stack.m_41783_().m_128471_("Enabled");
    }
}

