/*
 * Decompiled with CFR 0.152.
 */
package nomowanderer.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nomowanderer.Config;
import nomowanderer.compat.ExternalMods;
import nomowanderer.exception.UnloadedChunkException;
import nomowanderer.items.AntiSolicitorTalismanItem;
import nomowanderer.tileentity.NoSolicitingSignBlockEntity;
import nomowanderer.tileentity.TraderRugBlockEntity;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="nomowanderer")
public class EntitySpawnHandler {
    public static final boolean CURIOS = ExternalMods.CURIOS.isLoaded();

    @SubscribeEvent
    public static void maybeChangeEntitySpawn(EntityJoinLevelEvent event) {
        if (!event.loadedFromDisk()) {
            try {
                EntitySpawnHandler.checkSpawn(event);
            }
            catch (UnloadedChunkException unloadedChunkException) {
                // empty catch block
            }
        }
    }

    private static boolean isWatchedEntity(Entity entity) {
        List watchedEntities = (List)Config.ENTITY_WATCH_LIST.get();
        String registryName = EntitySpawnHandler.getRegistryName(entity);
        return watchedEntities.contains(registryName);
    }

    @NotNull
    private static String getRegistryName(Entity entity) {
        return Objects.requireNonNull(EntityType.m_20613_((EntityType)entity.m_6095_())).toString();
    }

    private static void checkSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (EntitySpawnHandler.isWatchedEntity(entity)) {
            if (((Boolean)Config.DISABLE_ENTITY_SPAWNS.get()).booleanValue() || EntitySpawnHandler.canFindCancelEntity(event)) {
                EntitySpawnHandler.cancelSpawn(event);
                return;
            }
            EntitySpawnHandler.checkBlockEntities(event);
        }
    }

    private static void cancelSpawn(EntityJoinLevelEvent event) {
        if (event.isCancelable()) {
            event.setCanceled(true);
        }
        event.setResult(Event.Result.DENY);
    }

    private static boolean canFindCancelEntity(EntityJoinLevelEvent event) {
        int spawnCapCheckDist = EntitySpawnHandler.getCheckDist(Config.SPAWN_CAP_WATCH_RADIUS);
        int talismanCheckDist = EntitySpawnHandler.getCheckDist(Config.TALISMAN_WATCH_RADIUS);
        AABB spawnCapAABB = EntitySpawnHandler.getAABB(event, spawnCapCheckDist);
        AABB talismanAABB = EntitySpawnHandler.getAABB(event, talismanCheckDist);
        AABB largestAABB = EntitySpawnHandler.getLargestAABB(spawnCapAABB, talismanAABB);
        List entities = event.getLevel().m_45976_(Entity.class, largestAABB);
        HashMap<String, Integer> entityCount = new HashMap<String, Integer>();
        for (Entity entity : entities) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!talismanAABB.m_82390_(player.m_20182_())) continue;
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!AntiSolicitorTalismanItem.isEnabled(stack)) continue;
                    return true;
                }
                if (!CURIOS || !CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, AntiSolicitorTalismanItem::isEnabled).isPresent()) continue;
                return true;
            }
            if (!EntitySpawnHandler.isWatchedEntity(entity) || !spawnCapAABB.m_82390_(entity.m_20182_())) continue;
            String registryName = EntitySpawnHandler.getRegistryName(entity);
            int count = entityCount.get(registryName) != null ? (Integer)entityCount.get(registryName) : 0;
            entityCount.put(registryName, count + 1);
            Integer spawnCap = (Integer)Config.ENTITY_SPAWN_CAP.get();
            if (spawnCap == 0 || !registryName.equals(EntitySpawnHandler.getRegistryName(event.getEntity())) || (Integer)entityCount.get(registryName) < spawnCap) continue;
            return true;
        }
        return false;
    }

    private static AABB getLargestAABB(AABB ... areas) {
        AABB largest = null;
        for (AABB aabb : areas) {
            largest = largest == null || aabb.m_82362_() > largest.m_82362_() ? aabb : largest;
        }
        return largest;
    }

    private static AABB getAABB(EntityJoinLevelEvent event, int spawnCheckDist) {
        ChunkAccess eventChunk = EntitySpawnHandler.getChunk(event, event.getEntity().m_20183_());
        ChunkPos pos = eventChunk.m_7697_();
        return new AABB((double)(pos.m_45608_() + spawnCheckDist), (double)event.getLevel().m_141937_(), (double)(pos.m_45605_() - spawnCheckDist), (double)(pos.m_45604_() - spawnCheckDist), (double)event.getLevel().m_151558_(), (double)(pos.m_45609_() + spawnCheckDist));
    }

    private static int getCheckDist(ForgeConfigSpec.IntValue radius) {
        return (Integer)radius.get() * 16 + 1;
    }

    private static void checkBlockEntities(EntityJoinLevelEvent event) {
        ChunkAccess eventChunk = EntitySpawnHandler.getChunk(event, event.getEntity().m_20097_());
        ArrayList<ChunkAccess> largestChunks = EntitySpawnHandler.getChunksInRadius(event, eventChunk.m_7697_(), Math.max((Integer)Config.RUG_WATCH_RADIUS.get(), (Integer)Config.SIGN_WATCH_RADIUS.get()));
        ArrayList<ChunkAccess> rugChunks = EntitySpawnHandler.getChunksInRadius(event, eventChunk.m_7697_(), (Integer)Config.RUG_WATCH_RADIUS.get());
        ArrayList<ChunkAccess> signChunks = EntitySpawnHandler.getChunksInRadius(event, eventChunk.m_7697_(), (Integer)Config.SIGN_WATCH_RADIUS.get());
        EntitySpawnHandler.lookForBEInChunks(event, largestChunks, rugChunks, signChunks);
    }

    private static void lookForBEInChunks(EntityJoinLevelEvent event, ArrayList<ChunkAccess> largestChunks, ArrayList<ChunkAccess> rugChunks, ArrayList<ChunkAccess> signChunks) {
        for (ChunkAccess chunk : largestChunks) {
            if (!(chunk instanceof LevelChunk)) continue;
            LevelChunk newChunk = (LevelChunk)chunk;
            Map blockEntities = newChunk.m_62954_();
            for (BlockPos pos : blockEntities.keySet()) {
                BlockState blockState;
                boolean validSpawn;
                BlockEntity be = (BlockEntity)blockEntities.get(pos);
                BlockPos bePos = be.m_58899_();
                if (be instanceof NoSolicitingSignBlockEntity && signChunks.contains(event.getLevel().m_46865_(bePos))) {
                    EntitySpawnHandler.cancelSpawn(event);
                    return;
                }
                if (!(be instanceof TraderRugBlockEntity) || !rugChunks.contains(event.getLevel().m_46865_(bePos)) || !(validSpawn = !(blockState = event.getLevel().m_8055_(bePos.m_7494_())).m_60828_((BlockGetter)event.getLevel(), bePos.m_7494_()))) continue;
                double x = (double)bePos.m_123341_() + 0.5;
                double z = (double)bePos.m_123343_() + 0.5;
                event.getEntity().m_6034_(x, (double)bePos.m_123342_(), z);
                return;
            }
        }
    }

    @NotNull
    private static ChunkAccess getChunk(EntityJoinLevelEvent event, BlockPos bePos) {
        int cZ;
        int cX = SectionPos.m_123171_((int)bePos.m_123341_());
        Optional<ChunkAccess> chunk = EntitySpawnHandler.getChunk(event, cX, cZ = SectionPos.m_123171_((int)bePos.m_123343_()));
        if (chunk.isEmpty()) {
            throw new UnloadedChunkException();
        }
        return chunk.get();
    }

    @NotNull
    private static Optional<ChunkAccess> getChunk(EntityJoinLevelEvent event, int cX, int cZ) {
        return Optional.ofNullable(event.getLevel().m_7726_().m_7131_(cX, cZ));
    }

    private static ArrayList<ChunkAccess> getChunksInRadius(EntityJoinLevelEvent event, ChunkPos chunkPos, int radius) {
        int curX = chunkPos.f_45578_ - radius;
        int startX = curX;
        int endX = chunkPos.f_45578_ + radius;
        int endZ = chunkPos.f_45579_ + radius;
        ArrayList<ChunkAccess> chunks = new ArrayList<ChunkAccess>();
        for (int curZ = chunkPos.f_45579_ - radius; curZ <= endZ; ++curZ) {
            while (curX <= endX) {
                Optional<ChunkAccess> chunk = EntitySpawnHandler.getChunk(event, curX, curZ);
                chunk.ifPresent(chunks::add);
                ++curX;
            }
            curX = startX;
        }
        return chunks;
    }
}

