/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleCachingUtils;

@Mixin(value={Entity.class})
public abstract class ThreadUnsafeScaledEntityMixin
implements PehkuiEntityExtensions {
    private Map<ScaleType, ScaleData> pehkui_scaleTypes = new Object2ObjectOpenHashMap();

    @Override
    public ScaleData pehkui_getScaleData(ScaleType type) {
        ScaleData cached;
        ScaleData[] scaleCache = this.pehkui_getScaleCache();
        if (scaleCache == null) {
            scaleCache = new ScaleData[ScaleCachingUtils.CACHED.length];
            this.pehkui_setScaleCache(scaleCache);
        }
        if ((cached = ScaleCachingUtils.getCachedData(scaleCache, type)) != null) {
            return cached;
        }
        Map<ScaleType, ScaleData> scaleTypes = this.pehkui_getScales();
        ScaleData scaleData = scaleTypes.get(type);
        if (scaleData == null) {
            if (!scaleTypes.containsKey(type)) {
                scaleTypes.put(type, null);
                scaleData = this.pehkui_constructScaleData(type);
                scaleTypes.put(type, scaleData);
                ScaleCachingUtils.setCachedData(this.pehkui_getScaleCache(), type, scaleData);
            } else {
                scaleData = scaleTypes.get(type);
            }
        }
        return scaleData;
    }

    @Override
    public Map<ScaleType, ScaleData> pehkui_getScales() {
        Object2ObjectOpenHashMap scaleTypes = this.pehkui_scaleTypes;
        if (scaleTypes == null) {
            this.pehkui_scaleTypes = scaleTypes = new Object2ObjectOpenHashMap();
            ScaleRegistries.SCALE_TYPES.values().forEach(this::pehkui_getScaleData);
        }
        return scaleTypes;
    }
}

