/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes;

import alexthw.ars_scalaes.ArsNouveauRegistry;
import alexthw.ars_scalaes.ConfigHandler;
import alexthw.ars_scalaes.hexcast.HexCompat;
import alexthw.ars_scalaes.hexerei.HexereiCompat;
import alexthw.ars_scalaes.identity.MorphingAbstraction;
import alexthw.ars_scalaes.immersive_portals.IPCompat;
import alexthw.ars_scalaes.malum.MalumCompat;
import alexthw.ars_scalaes.origins.OriginCompat;
import alexthw.ars_scalaes.pehkui.PkCompatHandler;
import alexthw.ars_scalaes.pmmo.PmmoCompatEventHandler;
import alexthw.ars_scalaes.registry.ModRegistry;
import alexthw.ars_scalaes.sh.ScalingHealthCompatEventHandler;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="ars_scalaes")
public class ArsScalaes {
    public static final String MODID = "ars_scalaes";

    public ArsScalaes() {
        ArsNouveauAPI.ENABLE_DEBUG_NUMBERS = !FMLEnvironment.production;
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_SPEC);
        ModRegistry.registerRegistries(modbus);
        if (ModList.get().isLoaded("pmmo")) {
            MinecraftForge.EVENT_BUS.register(PmmoCompatEventHandler.class);
        }
        if (ModList.get().isLoaded("scalinghealth")) {
            MinecraftForge.EVENT_BUS.register(ScalingHealthCompatEventHandler.class);
        }
        if (ModList.get().isLoaded("pehkui")) {
            PkCompatHandler.init();
        }
        if (ModList.get().isLoaded("identity") || ModList.get().isLoaded("walkers")) {
            MorphingAbstraction.preInit();
        }
        if (ModList.get().isLoaded("hexcasting")) {
            HexCompat.init();
        }
        if (ModList.get().isLoaded("malum")) {
            MalumCompat.init();
        }
        if (ModList.get().isLoaded("hexerei")) {
            HexereiCompat.init();
        }
        if (ModList.get().isLoaded("origins")) {
            OriginCompat.init();
        }
        if (ModList.get().isLoaded("immersive_portals")) {
            IPCompat.init();
        }
        ArsNouveauRegistry.registerCompatGlyphs();
        modbus.addListener(this::setup);
        modbus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("identity") || ModList.get().isLoaded("walkers")) {
            event.enqueueWork(MorphingAbstraction::postInit);
        }
        if (ModList.get().isLoaded("pmmo")) {
            event.enqueueWork(PmmoCompatEventHandler::setupPerks);
        }
        if (ModList.get().isLoaded("hexerei")) {
            event.enqueueWork(HexereiCompat::postInit);
        }
        if (ModList.get().isLoaded("malum")) {
            event.enqueueWork(MalumCompat::postInit);
        }
    }

    private void doClientStuff(EntityRenderersEvent.RegisterLayerDefinitions event) {
        if (ModList.get().isLoaded("hexerei")) {
            HexereiCompat.layerDefinitions(event);
        }
    }
}

