/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.datagen;

import alexthw.ars_scalaes.glyph.EffectExpand;
import alexthw.ars_scalaes.glyph.EffectMorph;
import alexthw.ars_scalaes.glyph.EffectResize;
import alexthw.ars_scalaes.glyph.EffectShrink;
import alexthw.ars_scalaes.glyph.EffectSoulShatter;
import alexthw.ars_scalaes.malum.MalumCompat;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EnchantingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class ArsProviders {
    static final String root = "ars_scalaes";

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(root, path);
    }

    public static class ScalaesPatchouliProvider
    extends PatchouliProvider {
        public ScalaesPatchouliProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput pOutput) {
            this.addGlyphPage((AbstractSpellPart)EffectResize.INSTANCE, "pehkui");
            this.addGlyphPage((AbstractSpellPart)EffectExpand.INSTANCE, "pehkui");
            this.addGlyphPage((AbstractSpellPart)EffectShrink.INSTANCE, "pehkui");
            this.addGlyphPage((AbstractSpellPart)EffectMorph.INSTANCE, "identity");
            this.addGlyphPage((AbstractSpellPart)EffectMorph.INSTANCE, "walkers");
            this.addGlyphPage((AbstractSpellPart)EffectSoulShatter.INSTANCE, "malum");
            for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
                this.saveStable(pOutput, (JsonElement)patchouliPage.build(), patchouliPage.path());
            }
        }

        public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
            PatchouliBuilder builder = new PatchouliBuilder(category, item.m_5456_().m_5524_()).withIcon((ItemLike)item.m_5456_()).withPage((IPatchouliPage)new TextPage("ars_scalaes.page." + RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_())).withPage(recipePage);
            PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_()));
            this.pages.add(page);
            return page;
        }

        public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
            PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity.ars_scalaes." + familiarHolder.getRegistryName().m_135815_()).withIcon("ars_scalaes:" + familiarHolder.getRegistryName().m_135815_()).withTextPage("ars_scalaes.familiar_desc." + familiarHolder.getRegistryName().m_135815_()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().m_135815_())));
        }

        public void addRitualPage(AbstractRitual ritual) {
            PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item.ars_scalaes." + ritual.getRegistryName().m_135815_()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage("ars_scalaes:tablet_" + ritual.getRegistryName().m_135815_()));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(RITUALS, ritual.getRegistryName().m_135815_())));
        }

        public void addEnchantmentPage(Enchantment enchantment) {
            PatchouliBuilder builder = new PatchouliBuilder(ENCHANTMENTS, enchantment.m_44704_()).withIcon(RegistryHelper.getRegistryName((Item)Items.f_42690_).toString()).withTextPage("ars_scalaes.enchantment_desc." + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_());
            for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
                builder.withPage((IPatchouliPage)new EnchantingPage("ars_nouveau:" + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_() + "_" + i));
            }
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ENCHANTMENTS, RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_())));
        }

        public void addGlyphPage(AbstractSpellPart spellPart, String modid) {
            ResourceLocation category = switch (spellPart.defaultTier().value) {
                case 1 -> GLYPHS_1;
                case 2 -> GLYPHS_2;
                default -> GLYPHS_3;
            };
            PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName("ars_scalaes.glyph_name." + spellPart.getRegistryName().m_135815_()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage("ars_scalaes.glyph_desc." + spellPart.getRegistryName().m_135815_())).withPage((IPatchouliPage)new GlyphScribePage(spellPart)).withProperty("flag", "mod:" + modid);
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().m_135815_())));
        }

        public String m_6055_() {
            return "ArsScalaes Patchouli Datagen";
        }
    }

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput pOutput) {
            for (ImbuementRecipe g : this.recipes) {
                Path path = this.getRecipePath(this.output, g.m_6423_().m_135815_());
                this.saveStable(pOutput, g.asRecipe(), path);
            }
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/ars_scalaes/recipes/" + str + ".json");
        }

        public String m_6055_() {
            return "ArsScalaes Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput pOutput) {
            this.recipes.add(this.builder().withResult(((Item)MalumCompat.ENCHANTER_SCYTHE.get()).m_7968_()).keepNbtOfReagent(true).withPedestalItem(Ingredient.m_204132_((TagKey)ItemTagProvider.SOURCE_GEM_BLOCK_TAG)).withPedestalItem(Ingredient.m_204132_((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(3, Ingredient.m_204132_((TagKey)ItemTagProvider.ARCHWOOD_LOG_TAG)).withReagent((ItemLike)ItemRegistry.SOUL_STAINED_STEEL_SCYTHE.get()).build());
            for (EnchantingApparatusRecipe g : this.recipes) {
                if (g == null) continue;
                Path path = EnchantingAppProvider.getRecipePath(this.output, g.m_6423_().m_135815_());
                this.saveStable(pOutput, g.asRecipe(), path);
            }
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/ars_scalaes/recipes/" + str + ".json");
        }

        public String m_6055_() {
            return "ArsScalaes Apparatus";
        }
    }

    public static class GlyphProvider
    extends GlyphRecipeProvider {
        public GlyphProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput pOutput) {
            for (GlyphRecipe recipe : this.recipes) {
                Path path = GlyphProvider.getScribeGlyphPath(this.output, recipe.output.m_41720_());
                this.saveStable(pOutput, recipe.asRecipe(), path);
            }
        }

        protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
            return pathIn.resolve("data/ars_scalaes/recipes/" + RegistryHelper.getRegistryName((Item)glyph).m_135815_() + ".json");
        }

        public String m_6055_() {
            return "ArsScalaes Glyph Recipes";
        }
    }
}

