/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.datagen;

import alexthw.ars_scalaes.block.DecoBlock;
import alexthw.ars_scalaes.datagen.ArsProviders;
import alexthw.ars_scalaes.datagen.Setup;
import alexthw.ars_scalaes.registry.ModRegistry;
import java.util.HashSet;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "ars_scalaes", exFileHelper);
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(ModRegistry.BLOCKS.getEntries());
        Setup.takeAll(blocks, b -> b.get() instanceof DecoBlock).forEach(this::basicBlock);
        Setup.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(this::slabBlock);
        Setup.takeAll(blocks, b -> b.get() instanceof StairBlock).forEach(this::stairsBlock);
        Setup.takeAll(blocks, b -> b.get() instanceof WallBlock).forEach(this::wallBlock);
        Setup.takeAll(blocks, b -> b.get() instanceof FenceBlock).forEach(this::fenceBlock);
        Setup.takeAll(blocks, b -> b.get() instanceof FenceGateBlock).forEach(this::fenceGateBlock);
    }

    public void wallBlock(RegistryObject<Block> blockRegistryObject) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 5);
        this.wallBlock((WallBlock)blockRegistryObject.get(), ArsProviders.prefix("block/" + baseName));
    }

    public void slabBlock(RegistryObject<Block> blockRegistryObject) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), ArsProviders.prefix(baseName), ArsProviders.prefix("block/" + baseName));
    }

    public void fenceGateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 11);
        this.fenceGateBlock((FenceGateBlock)blockRegistryObject.get(), ArsProviders.prefix("block/" + baseName));
    }

    public void fenceBlock(RegistryObject<Block> blockRegistryObject) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceBlock((FenceBlock)blockRegistryObject.get(), ArsProviders.prefix("block/" + baseName));
    }

    private void basicBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    public void stairsBlock(RegistryObject<Block> blockRegistryObject) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock(blockRegistryObject, ArsProviders.prefix("block/" + baseName));
    }

    public void stairsBlock(RegistryObject<Block> block, ResourceLocation side) {
        ResourceLocation top;
        ResourceLocation baseName = block.getId();
        ResourceLocation bottom = side;
        ResourceLocation top_in = top = side;
        ResourceLocation top_out = top;
        if (side.m_135815_().contains("gilded_sourcestone_large")) {
            bottom = ArsProviders.prefix(bottom.m_135815_() + "_bot");
            top = ArsProviders.prefix(top.m_135815_() + "_top");
            top_in = ArsProviders.prefix(top.m_135815_() + "_in");
            top_out = ArsProviders.prefix(top.m_135815_() + "_out");
        }
        ModelBuilder stairs = this.models().stairs(baseName.toString(), side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top_in);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top_out);
        this.stairsBlock((StairBlock)block.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    public void stairsBlock(StairBlock block, ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            boolean name = stairs.getLocation().m_135815_().contains("gilded_sourcestone_large");
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(!name && uvlock).build();
        }, new Property[]{StairBlock.f_56844_});
    }
}

