/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.datagen;

import alexthw.ars_scalaes.datagen.ArsProviders;
import alexthw.ars_scalaes.datagen.ModBlockStateProvider;
import alexthw.ars_scalaes.datagen.ModBlockTagsProvider;
import alexthw.ars_scalaes.datagen.ModItemModelProvider;
import alexthw.ars_scalaes.datagen.ModItemTagProvider;
import alexthw.ars_scalaes.datagen.ModLootTables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_scalaes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Setup {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(gen, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(gen, existingFileHelper));
        ModBlockTagsProvider blocktag = new ModBlockTagsProvider(gen, event.getLookupProvider(), existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blocktag);
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(gen, event.getLookupProvider(), blocktag, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ArsProviders.GlyphProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new ArsProviders.EnchantingAppProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new ArsProviders.ScalaesPatchouliProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLootTables(gen));
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }
}

