/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.glyph;

import alexthw.ars_scalaes.glyph.PehkuiEffect;
import alexthw.ars_scalaes.pehkui.PkCompatHandler;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import virtuoel.pehkui.api.ScaleData;

public class EffectShrink
extends PehkuiEffect {
    public static final EffectShrink INSTANCE = new EffectShrink();

    public EffectShrink() {
        super("shrink", "Shrink");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ScaleData data = PkCompatHandler.magicScale.getScaleData(rayTraceResult.m_82443_());
        float cScale = data.getScale();
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        data.setTargetScale((float)Math.max((Double)this.minScaling.get(), (double)cScale / (1.2 + spellStats.getAmpMultiplier())));
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.minScaling = builder.comment("Define the minimum size that can be reached.").defineInRange("min_scaling", 0.2, 0.01, 1.0);
    }
}

