/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.glyph;

import alexthw.ars_scalaes.datagen.ArsProviders;
import alexthw.ars_scalaes.pehkui.PkCompatHandler;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class PehkuiEffect
extends AbstractEffect
implements IPotionEffect {
    public ForgeConfigSpec.BooleanValue isTimeLimited;
    public ForgeConfigSpec.DoubleValue minScaling;
    public ForgeConfigSpec.DoubleValue maxScaling;
    public ForgeConfigSpec.DoubleValue scalingFactor;

    public PehkuiEffect(String tag, String description) {
        super(ArsProviders.prefix("glyph_" + tag), description);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity living;
        Entity entity;
        if (((Boolean)this.isTimeLimited.get()).booleanValue() && (entity = rayTraceResult.m_82443_()) instanceof LivingEntity && ((living = (LivingEntity)entity) != shooter || spellStats.getDurationMultiplier() < 1.0)) {
            this.applyConfigPotion(living, (MobEffect)PkCompatHandler.RESIZE.get(), spellStats, false);
        }
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.isTimeLimited = builder.comment("Enable a timer on the resize effects. Target will return to original size when potion effect is removed.").define("limitedSizeTime", true);
        this.addPotionConfig(builder, 120);
        this.addExtendTimeConfig(builder, 1200);
    }

    public int getDefaultManaCost() {
        return 100;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.getPotionAugments();
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

