/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.identity;

import alexthw.ars_scalaes.identity.ElementalModule;
import alexthw.ars_scalaes.identity.ability.StarbuncleAbility;
import alexthw.ars_scalaes.identity.ability.WealdWalkerAbility;
import alexthw.ars_scalaes.identity.ability.WhirlisprigAbility;
import alexthw.ars_scalaes.identity.ability.WildenHunterAbility;
import alexthw.ars_scalaes.identity.ability.WildenStalkerAbility;
import alexthw.ars_scalaes.identity.ability.WixieAbility;
import alexthw.ars_scalaes.identity.rendering.ColorVariantProvider;
import alexthw.ars_scalaes.identity.rendering.StarbuncleTypeProvider;
import alexthw.ars_scalaes.identity.tick_handlers.StalkerTickHandler;
import alexthw.ars_scalaes.identity.tick_handlers.WhirlSprigTickHandler;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import draylar.identity.ability.AbilityRegistry;
import draylar.identity.ability.IdentityAbility;
import draylar.identity.api.IdentityTickHandler;
import draylar.identity.api.IdentityTickHandlers;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.api.variant.TypeProvider;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class IdentityReg {
    public static void postInit() {
        MinecraftForge.EVENT_BUS.register(IdentityReg.class);
        Map variants = (Map)ObfuscationReflectionHelper.getPrivateValue(IdentityType.class, (Object)new IdentityType(null, 0), (String)"VARIANT_BY_TYPE");
        IdentityReg.initAbilities();
        if (variants != null) {
            IdentityReg.initVariants(variants);
        }
    }

    private static void initVariants(Map<EntityType<? extends LivingEntity>, TypeProvider<?>> variants) {
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.STARBUNCLE_TYPE.get()), new StarbuncleTypeProvider());
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), new ColorVariantProvider<Whirlisprig>(){

            @Override
            public int getRange() {
                return 3;
            }
        });
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_DRYGMY.get()), new ColorVariantProvider<EntityDrygmy>(){

            @Override
            public int getRange() {
                return EntityDrygmy.COLORS.length - 1;
            }
        });
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get()), new ColorVariantProvider<EntityBookwyrm>(){

            @Override
            public int getRange() {
                return EntityBookwyrm.COLORS.length - 1;
            }
        });
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get()), new ColorVariantProvider<EntityWixie>(){

            @Override
            public int getRange() {
                return EntityWixie.COLORS.length - 1;
            }
        });
        if (ModList.get().isLoaded("ars_elemental")) {
            ElementalModule.variants(variants);
        }
    }

    public static void initAbilities() {
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_BLAZING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_CASCADING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_FLOURISHING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_VEXING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.WILDEN_HUNTER.get()), (IdentityAbility)new WildenHunterAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.WILDEN_STALKER.get()), (IdentityAbility)new WildenStalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.STARBUNCLE_TYPE.get()), new StarbuncleAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), new WhirlisprigAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get()), (IdentityAbility)new WixieAbility());
        IdentityTickHandlers.register((EntityType)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), (IdentityTickHandler)new WhirlSprigTickHandler());
        IdentityTickHandlers.register((EntityType)((EntityType)ModEntities.WILDEN_STALKER.get()), (IdentityTickHandler)new StalkerTickHandler());
        if (ModList.get().isLoaded("ars_elemental")) {
            ElementalModule.initAbilities();
        }
    }

    @SubscribeEvent
    public static void damageImmunity(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            if (event.getSource().m_276093_(DamageTypes.f_268469_) && PlayerIdentity.getIdentity((Player)p) instanceof Starbuncle) {
                event.setCanceled(true);
            }
        }
    }

    public static void morphInto(Level world, ServerPlayer player, LivingEntity living) {
        if (living == null) {
            PlayerIdentity.updateIdentity((ServerPlayer)player, null, null);
            return;
        }
        IdentityType type = IdentityType.from((LivingEntity)living);
        if (type != null) {
            LivingEntity morph = type.create(world);
            if (morph instanceof IDecoratable) {
                IDecoratable toDeco = (IDecoratable)morph;
                if (living instanceof IDecoratable) {
                    IDecoratable fromDeco = (IDecoratable)living;
                    toDeco.setCosmeticItem(fromDeco.getCosmeticItem());
                }
            }
            PlayerIdentity.updateIdentity((ServerPlayer)player, (IdentityType)type, (LivingEntity)morph);
        }
    }
}

