/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.pmmo;

import alexthw.ars_scalaes.ConfigHandler;
import alexthw.ars_scalaes.datagen.ArsProviders;
import alexthw.ars_scalaes.pmmo.SpellSuccessEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.PerkSide;
import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PmmoCompatEventHandler {
    private static final CompoundTag NONE = new CompoundTag();
    private static final UUID manaRegenModifierID = UUID.fromString("57552ec6-c5d4-4df1-987e-bd99acb41fa9");
    private static final UUID manaMaxModifierID = UUID.fromString("654dec09-e05e-4eb1-a255-7a76447322be");
    private static final UUID damageModifierID = UUID.fromString("3c9f428c-d3dd-11ed-afa1-0242ac120002");
    public static final BiFunction<Player, CompoundTag, CompoundTag> MANA_REGEN = (player, nbt) -> {
        AttributeModifier modifier;
        AttributeModifier.Operation operation;
        double maxRegenBoost = nbt.m_128441_("max_boost") ? nbt.m_128459_("max_boost") : 100.0;
        double boostPerLevel = nbt.m_128441_("per_level") ? nbt.m_128459_("per_level") : 0.5;
        AttributeInstance manaAttribute = player.m_21051_((Attribute)PerkAttributes.MANA_REGEN_BONUS.get());
        int level = nbt.m_128451_("level");
        double regenBoost = Math.min(maxRegenBoost, (double)level * boostPerLevel);
        AttributeModifier.Operation operation2 = operation = nbt.m_128471_("multiplicative") ? AttributeModifier.Operation.MULTIPLY_BASE : AttributeModifier.Operation.ADDITION;
        if (manaAttribute != null && ((modifier = manaAttribute.m_22111_(manaRegenModifierID)) == null || modifier.m_22218_() != regenBoost)) {
            AttributeModifier regenModifier = new AttributeModifier(manaRegenModifierID, "Mana Regen bonus thanks to Magic Level", regenBoost, operation);
            manaAttribute.m_22120_(manaRegenModifierID);
            manaAttribute.m_22125_(regenModifier);
        }
        return NONE;
    };
    public static final BiFunction<Player, CompoundTag, CompoundTag> MANA_BOOST = (player, nbt) -> {
        AttributeModifier.Operation operation;
        double maxManaBoost = nbt.m_128441_("max_boost") ? nbt.m_128459_("max_boost") : 3000.0;
        double boostPerLevel = nbt.m_128441_("per_level") ? nbt.m_128459_("per_level") : 3.0;
        int level = nbt.m_128451_("level");
        int manaBoost = (int)Math.min(maxManaBoost, (double)level * boostPerLevel);
        AttributeInstance manaAttribute = player.m_21051_((Attribute)PerkAttributes.MAX_MANA.get());
        AttributeModifier.Operation operation2 = operation = nbt.m_128471_("multiplicative") ? AttributeModifier.Operation.MULTIPLY_BASE : AttributeModifier.Operation.ADDITION;
        if (manaAttribute != null) {
            AttributeModifier manaModifier = new AttributeModifier(manaMaxModifierID, "Max Mana bonus thanks to Magic Level", (double)manaBoost, operation);
            manaAttribute.m_22120_(manaMaxModifierID);
            manaAttribute.m_22125_(manaModifier);
        }
        return NONE;
    };
    public static final BiFunction<Player, CompoundTag, CompoundTag> DAMAGE_BOOST = (player, nbt) -> {
        AttributeModifier.Operation operation;
        double maxDamageBoost = nbt.m_128441_("max_boost") ? nbt.m_128459_("max_boost") : 0.0;
        double boostPerLevel = nbt.m_128441_("per_level") ? nbt.m_128459_("per_level") : 0.2;
        int level = nbt.m_128451_("level");
        int damageBoost = (int)Math.min(maxDamageBoost, (double)level * boostPerLevel);
        AttributeInstance manaAttribute = player.m_21051_((Attribute)PerkAttributes.SPELL_DAMAGE_BONUS.get());
        AttributeModifier.Operation operation2 = operation = nbt.m_128471_("multiplicative") ? AttributeModifier.Operation.MULTIPLY_BASE : AttributeModifier.Operation.ADDITION;
        if (manaAttribute != null) {
            AttributeModifier manaModifier = new AttributeModifier(damageModifierID, "Spell Damage bonus thanks to Pmmo Magic Level", (double)damageBoost, operation);
            manaAttribute.m_22120_(damageModifierID);
            manaAttribute.m_22125_(manaModifier);
        }
        return NONE;
    };

    public static void setupPerks() {
        CompoundTag regenDefaults = new CompoundTag();
        regenDefaults.m_128347_("max_boost", 100.0);
        regenDefaults.m_128347_("per_level", 0.5);
        regenDefaults.m_128379_("multiplicative", false);
        regenDefaults.m_128359_("skill", "magic");
        Perk RegenPerk = Perk.begin().addDefaults(regenDefaults).setDescription(LangProvider.PERK_ATTRIBUTE_DESC.asComponent()).setStatus((player, settings) -> {
            double perLevel = settings.m_128459_("per_level");
            String skillname = settings.m_128461_("skill");
            int skillLevel = settings.m_128451_("level");
            return List.of(LangProvider.PERK_ATTRIBUTE_STATUS_1.asComponent(new Object[]{Component.m_237115_((String)((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()).m_22087_())}), LangProvider.PERK_ATTRIBUTE_STATUS_2.asComponent(new Object[]{perLevel, Component.m_237115_((String)("pmmo." + skillname))}), LangProvider.PERK_ATTRIBUTE_STATUS_3.asComponent(new Object[]{perLevel * (double)skillLevel}));
        }).setStart(MANA_REGEN).build();
        APIUtils.registerPerk((ResourceLocation)ArsProviders.prefix("mana_regen"), (Perk)RegenPerk, (PerkSide)PerkSide.BOTH);
        CompoundTag manaDefaults = new CompoundTag();
        manaDefaults.m_128347_("max_boost", 3000.0);
        manaDefaults.m_128347_("per_level", 5.0);
        manaDefaults.m_128379_("multiplicative", false);
        manaDefaults.m_128359_("skill", "magic");
        Perk ManaPerk = Perk.begin().addDefaults(manaDefaults).setDescription(LangProvider.PERK_ATTRIBUTE_DESC.asComponent()).setStatus((player, settings) -> {
            double perLevel = settings.m_128459_("per_level");
            String skillname = settings.m_128461_("skill");
            int skillLevel = settings.m_128451_("level");
            return List.of(LangProvider.PERK_ATTRIBUTE_STATUS_1.asComponent(new Object[]{Component.m_237115_((String)((Attribute)PerkAttributes.MAX_MANA.get()).m_22087_())}), LangProvider.PERK_ATTRIBUTE_STATUS_2.asComponent(new Object[]{perLevel, Component.m_237115_((String)("pmmo." + skillname))}), LangProvider.PERK_ATTRIBUTE_STATUS_3.asComponent(new Object[]{perLevel * (double)skillLevel}));
        }).setStart(MANA_BOOST).build();
        APIUtils.registerPerk((ResourceLocation)ArsProviders.prefix("mana_boost"), (Perk)ManaPerk, (PerkSide)PerkSide.BOTH);
        CompoundTag damageDefaults = new CompoundTag();
        damageDefaults.m_128347_("max_boost", 0.0);
        damageDefaults.m_128347_("per_level", 0.2);
        damageDefaults.m_128379_("multiplicative", false);
        damageDefaults.m_128359_("skill", "magic");
        Perk DamagePerk = Perk.begin().addDefaults(damageDefaults).setDescription(LangProvider.PERK_ATTRIBUTE_DESC.asComponent()).setStatus((player, settings) -> {
            double perLevel = settings.m_128459_("per_level");
            String skillname = settings.m_128461_("skill");
            int skillLevel = settings.m_128451_("level");
            return List.of(LangProvider.PERK_ATTRIBUTE_STATUS_1.asComponent(new Object[]{Component.m_237115_((String)((Attribute)PerkAttributes.SPELL_DAMAGE_BONUS.get()).m_22087_())}), LangProvider.PERK_ATTRIBUTE_STATUS_2.asComponent(new Object[]{perLevel, Component.m_237115_((String)("pmmo." + skillname))}), LangProvider.PERK_ATTRIBUTE_STATUS_3.asComponent(new Object[]{perLevel * (double)skillLevel}));
        }).setStart(DAMAGE_BOOST).build();
        APIUtils.registerPerk((ResourceLocation)ArsProviders.prefix("spell_damage_boost"), (Perk)DamagePerk, (PerkSide)PerkSide.BOTH);
    }

    @SubscribeEvent
    public static void awardSpellCastXp(SpellSuccessEvent event) {
        LivingEntity livingEntity = event.context.getUnwrappedCaster();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!event.isCanceled()) {
                Spell spell = event.spell;
                int manaCost = 0;
                boolean hasEffect = false;
                for (AbstractSpellPart spellPart : spell.recipe) {
                    if (spellPart instanceof AbstractAugment) continue;
                    if (spellPart instanceof AbstractEffect) {
                        hasEffect = true;
                    }
                    manaCost += spellPart.getCastingCost();
                }
                if (hasEffect) {
                    long xpAward = (long)((Double)ConfigHandler.Common.MANA_XP.get() * (double)manaCost);
                    APIUtils.addXp((String)"magic", (Player)player, (long)xpAward);
                }
            }
        }
    }

    @SubscribeEvent
    public static void dmgAdjustByLevel(SpellDamageEvent.Pre event) {
        Entity magicLevel2;
        Player player;
        LivingEntity livingEntity = event.caster;
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            int magicLevel2 = APIUtils.getLevel((String)"magic", (Player)player);
            float magicProficiency = (float)((double)magicLevel2 * (Double)ConfigHandler.Common.LEVEL_TO_SPELL_DMG.get());
            event.damage *= 1.0f + magicProficiency;
        }
        if ((magicLevel2 = event.target) instanceof Player) {
            player = (Player)magicLevel2;
            int magicLevel3 = APIUtils.getLevel((String)"magic", (Player)player);
            int enduranceLevel = APIUtils.getLevel((String)"endurance", (Player)player);
            double mitigation = 1.0 - (double)(magicLevel3 + enduranceLevel) * (Double)ConfigHandler.Common.LEVEL_TO_SPELL_RES.get();
            event.damage = (float)Math.max(0.0, (double)event.damage * mitigation);
        }
    }
}

