/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.ITargetsDroppedItems;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.owl.QuirkController;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.owl.quirks.FavoriteBlockQuirk;
import net.joefoxe.hexerei.client.renderer.entity.render.OwlVariant;
import net.joefoxe.hexerei.container.OwlContainer;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotSavedData;
import net.joefoxe.hexerei.data.owl.OwlLoadedChunksSavedData;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CourierLetterItem;
import net.joefoxe.hexerei.item.custom.CourierPackageItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.AskForSyncPacket;
import net.joefoxe.hexerei.util.message.BrowAnimPacket;
import net.joefoxe.hexerei.util.message.BrowPositioningPacket;
import net.joefoxe.hexerei.util.message.ClientboundOpenOwlCourierSendScreenPacket;
import net.joefoxe.hexerei.util.message.CrowStartRidingPacket;
import net.joefoxe.hexerei.util.message.EatParticlesPacket;
import net.joefoxe.hexerei.util.message.EmotionPacket;
import net.joefoxe.hexerei.util.message.EntitySyncAdditionalDataPacket;
import net.joefoxe.hexerei.util.message.EntitySyncPacket;
import net.joefoxe.hexerei.util.message.HeadShakePacket;
import net.joefoxe.hexerei.util.message.HeadTiltPacket;
import net.joefoxe.hexerei.util.message.OwlHootPacket;
import net.joefoxe.hexerei.util.message.OwlSyncInvPacket;
import net.joefoxe.hexerei.util.message.OwlTeleportParticlePacket;
import net.joefoxe.hexerei.util.message.PeckPacket;
import net.joefoxe.hexerei.util.message.TailFanPacket;
import net.joefoxe.hexerei.util.message.TailWagPacket;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class OwlEntity
extends TamableAnimal
implements ContainerListener,
FlyingAnimal,
ITargetsDroppedItems,
Container,
MenuProvider,
PowerableMob {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42527_, Items.f_42526_});
    public BrowPositioning browPositioning = BrowPositioning.NORMAL;
    public BrowAnimation browAnimation;
    public BrowHappyAnimation browHappyAnimation;
    public TailWagAnimation tailWagAnimation;
    public TailFanAnimation tailFanAnimation;
    public HootAnimation hootAnimation;
    public PeckAnimation peckAnimation;
    public HeadTiltAnimation headTiltAnimation;
    public HeadShakeAnimation headShakeAnimation;
    public AnimationController animationController;
    public MessagingController messagingController;
    public float bodyXRot;
    public float bodyXRotLast;
    public float bodyYOffset;
    public float bodyYOffsetLast;
    public float rightWingAngle;
    public float rightWingAngleLast;
    public float rightWingFoldAngle;
    public float rightWingMiddleAngle;
    public float rightWingMiddleAngleLast;
    public float rightWingMiddleFoldAngle;
    public float rightWingTipAngle;
    public float leftWingAngle;
    public float leftWingAngleLast;
    public float leftWingFoldAngle;
    public float leftWingMiddleAngle;
    public float leftWingMiddleAngleLast;
    public float leftWingMiddleFoldAngle;
    public float leftWingTipAngle;
    public boolean dance;
    public int animationCounter;
    public float itemHeldSwing = 0.0f;
    public float itemHeldSwingLast = 0.0f;
    private BlockPos jukebox;
    private int rideCooldownCounter;
    private UUID fishThrowerID;
    private int heldItemTime = 0;
    public OwlTask currentTask;
    public ItemEntity targetingItem;
    public boolean sync;
    public final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private static final EntityDataAccessor<Optional<BlockPos>> PERCH_POS = SynchedEntityData.m_135353_(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> OWL_DYE_COLOR = SynchedEntityData.m_135353_(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_FLYING = SynchedEntityData.m_135353_(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int interactionRange;
    public boolean canAttack;
    private final Map<String, Vector3f> modelRotationValues = Maps.newHashMap();
    protected FlyingPathNavigation flyingNav;
    protected GroundPathNavigation groundNav;
    private int lastSwappedNavigator = -40;
    public Emotions emotions;
    public EmotionState emotionState;
    private int emotionTicks = 0;
    public QuirkController quirkController;
    public int lowHealthDistressIncreaseTickLast = 0;
    public boolean breedGiftGivenByPlayer = false;
    public int breedGiftGivenByPartnerTimer = 0;
    public UUID breedGiftGivenByPlayerUUID;
    public int waitToGiveTime = 0;

    public OwlEntity(EntityType<OwlEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_8099_();
        this.flyingNav = (FlyingPathNavigation)this.createFlyingNavigation(worldIn);
        this.groundNav = (GroundPathNavigation)this.createGroundNavigation(worldIn);
        this.f_21342_ = new OwlMoveController(this, 10);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.animationCounter = 0;
        this.currentTask = OwlTask.NONE;
        this.targetingItem = null;
        this.sync = false;
        this.animationController = new AnimationController();
        this.browAnimation = new BrowAnimation(this);
        this.animationController.addAnimation(this.browAnimation);
        this.browHappyAnimation = new BrowHappyAnimation(this);
        this.animationController.addAnimation(this.browHappyAnimation);
        this.tailWagAnimation = new TailWagAnimation(this);
        this.animationController.addAnimation(this.tailWagAnimation);
        this.tailFanAnimation = new TailFanAnimation(this);
        this.animationController.addAnimation(this.tailFanAnimation);
        this.hootAnimation = new HootAnimation(this);
        this.animationController.addAnimation(this.hootAnimation);
        this.peckAnimation = new PeckAnimation(this);
        this.animationController.addAnimation(this.peckAnimation);
        this.headTiltAnimation = new HeadTiltAnimation(this);
        this.animationController.addAnimation(this.headTiltAnimation);
        this.headShakeAnimation = new HeadShakeAnimation(this);
        this.animationController.addAnimation(this.headShakeAnimation);
        this.messagingController = new MessagingController(this);
        this.bodyXRot = 0.0f;
        this.bodyYOffset = 0.0f;
        this.rightWingAngle = -((float)Math.toRadians(85.0));
        this.leftWingAngle = (float)Math.toRadians(85.0);
        this.rightWingMiddleAngle = -((float)Math.toRadians(10.0));
        this.leftWingMiddleAngle = (float)Math.toRadians(10.0);
        this.rightWingMiddleFoldAngle = (float)Math.toRadians(30.0);
        this.leftWingMiddleFoldAngle = -((float)Math.toRadians(30.0));
        this.rightWingFoldAngle = (float)Math.toRadians(0.0);
        this.leftWingFoldAngle = -((float)Math.toRadians(0.0));
        this.rightWingTipAngle = (float)Math.toRadians(60.0);
        this.leftWingTipAngle = -((float)Math.toRadians(60.0));
        this.interactionRange = 24;
        this.canAttack = true;
        this.emotions = new Emotions(0, 0, 0);
        this.determineEmotionState();
        this.quirkController = new QuirkController();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4){

            public boolean m_8036_() {
                OwlEntity owl;
                PathfinderMob pathfinderMob = this.f_25684_;
                if (pathfinderMob instanceof OwlEntity && (owl = (OwlEntity)pathfinderMob).m_21825_()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new FlyBackToPerchGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DeliverMessageGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new OwlFavoriteBlockGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal(this, 1.25, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal(this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new OwlLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, new OwlGatherItems((PathfinderMob)this, false, false, 40, this.interactionRange));
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.25f;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11754_, 0.03f, 0.75f);
    }

    public BlockPos m_20099_() {
        return this.m_216986_(0.500001f);
    }

    protected float m_6118_() {
        return super.m_6118_() * 1.1f;
    }

    public int m_8085_() {
        if ((this.m_20096_() || !this.m_29443_()) && this.f_21344_.m_26571_()) {
            return 180;
        }
        return 90;
    }

    public void switchNavigator(boolean shouldFly, boolean force) {
        if (Math.abs(this.f_19797_ - this.lastSwappedNavigator) > 40 || force) {
            if (this.lastSwappedNavigator == -40) {
                this.f_19804_.m_135381_(DATA_FLYING, (Object)shouldFly);
            }
            this.lastSwappedNavigator = this.f_19797_;
            this.f_21344_ = shouldFly ? this.flyingNav : this.groundNav;
        }
    }

    public void switchNavigator(boolean shouldFly) {
        this.switchNavigator(shouldFly, false);
    }

    public boolean isFlyingNav() {
        return this.f_21344_ == this.flyingNav;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PERCH_POS, Optional.empty());
        this.f_19804_.m_135372_(OWL_DYE_COLOR, (Object)-1);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_FLYING, (Object)true);
    }

    public void syncInv() {
        if (!this.m_9236_().f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new OwlSyncInvPacket((Entity)this, this.itemHandler.serializeNBT()));
        }
    }

    public void sync() {
        this.m_6596_();
        if (!this.m_9236_().f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new EntitySyncPacket((Entity)this, this.m_20240_(new CompoundTag())));
            this.syncAdditionalData();
        }
    }

    public void syncAdditionalData() {
        this.m_6596_();
        if (!this.m_9236_().f_46443_) {
            CompoundTag tag = new CompoundTag();
            this.addAdditionalSaveDataNoSuper(tag);
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new EntitySyncAdditionalDataPacket((Entity)this, tag));
        }
    }

    public boolean isMaxHealth() {
        return this.m_21223_() >= this.m_21233_();
    }

    public void m_6667_(DamageSource pCause) {
        if (!this.m_21262_(pCause)) {
            this.messagingController.stopForceloadingChunks();
            super.m_6667_(pCause);
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (pReason.m_146965_()) {
            this.messagingController.stopForceloadingChunks();
        }
        super.m_142687_(pReason);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        float f = this.m_21223_();
        if (pSource.m_276093_(DamageTypes.f_268469_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.emotions.setAnger(this.emotions.getAnger() + (int)Mth.m_14036_((float)(pAmount * 20.0f), (float)10.0f, (float)30.0f));
            this.emotionChanged();
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_5830_() {
        if (this.m_20159_()) {
            return false;
        }
        return super.m_5830_();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                OwlEntity.this.syncAdditionalData();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ArmorItem armorItem;
                Item item;
                return slot != 0 || (item = stack.m_41720_()) instanceof ArmorItem && (armorItem = (ArmorItem)item).m_266204_() == ArmorItem.Type.HELMET;
            }

            public int getSlotLimit(int slot) {
                if (slot == 0 || slot == 1 || slot == 2) {
                    return 1;
                }
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    public void peck() {
        this.peckAnimation.start();
        this.hootAnimation.start();
    }

    public void m_6083_() {
        Entity entity = this.m_20202_();
        if (this.m_20159_() && !entity.m_6084_()) {
            this.m_8127_();
        } else if (this.m_21824_() && entity instanceof LivingEntity && this.m_21830_((LivingEntity)entity)) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_8119_();
            Entity player = this.m_20202_();
            if (this.m_20159_()) {
                int i = player.m_20197_().indexOf(this);
                float radius = 0.38f;
                float angle = (float)Math.PI / 180 * (((Player)player).f_20883_ + (float)(i == 0 ? -90 : 90));
                this.f_20885_ = ((Player)player).f_20885_;
                this.f_19859_ = ((Player)player).f_20885_;
                this.m_6034_(player.m_20185_() + (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))), player.m_20186_() + (!player.m_6144_() ? 1.4 : 1.2), player.m_20189_() + (double)(radius * Mth.m_14089_((float)angle)));
                if (!player.m_6084_() || player.m_6144_() || ((Player)player).m_21255_() || this.m_5448_() != null && this.m_5448_().m_6084_()) {
                    this.m_6038_();
                }
            }
        } else {
            super.m_6083_();
        }
    }

    private void setTypeVariant(int pTypeVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pTypeVariant);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public OwlVariant getVariant() {
        return OwlVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void m_6818_(BlockPos p_21082_, boolean p_21083_) {
        this.jukebox = p_21082_;
        this.dance = p_21083_;
    }

    protected AABB getTargetableArea(double targetDistance) {
        Vec3 renderCenter = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
        return aabb.m_82383_(renderCenter);
    }

    private void removeFramedMap(ItemStack pStack) {
        this.getFramedMapId().ifPresent(p_218864_ -> {
            MapItemSavedData mapitemsaveddata = MapItem.m_151128_((Integer)p_218864_, (Level)this.m_9236_());
            if (mapitemsaveddata != null) {
                mapitemsaveddata.m_77947_(this.m_20183_(), this.m_19879_());
                mapitemsaveddata.m_77760_(true);
            }
        });
        pStack.m_41636_(null);
    }

    public void setBrowPos(BrowPositioning browPositioning) {
        this.browPositioning = browPositioning;
        if (!this.m_9236_().f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new BrowPositioningPacket((Entity)this, this.browPositioning));
        }
    }

    public void determineEmotionState() {
        EmotionState closestState = null;
        double closestDistance = Double.MAX_VALUE;
        for (EmotionState state : EmotionState.values()) {
            double distance = this.calculateStateDistance(this.emotions, state.getScales());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestState = state;
        }
        this.emotionState = closestState;
    }

    private double calculateStateDistance(Emotions scales1, Emotions scales2) {
        int anger = scales1.getAnger() - scales2.getAnger();
        int plead = scales1.getDistress() - scales2.getDistress();
        int happiness = scales1.getHappiness() - scales2.getHappiness();
        return Math.sqrt(anger * anger + plead * plead + happiness * happiness);
    }

    private void adjustEmotion() {
        int adjustment;
        if (this.f_19796_.m_188503_(1) == 0) {
            adjustment = (int)Math.round((this.easeInOutCubic((float)this.emotions.getAnger() / 100.0f) * 0.5 + 0.25) * 20.0 + 1.0);
            this.emotions.setAnger(this.emotions.getAnger() - adjustment);
        }
        if (this.f_19796_.m_188503_(1) == 0) {
            adjustment = (int)Math.round((this.easeInOutCubic((float)this.emotions.getDistress() / 100.0f) * 0.5 + 0.25) * 20.0 + 1.0);
            this.emotions.setDistress(this.emotions.getDistress() - adjustment);
        }
        if (this.f_19796_.m_188503_(1) == 0) {
            adjustment = (int)Math.round((this.easeInOutCubic((float)this.emotions.getDistress() / 100.0f) * 0.5 + 0.25) * 20.0 + 1.0);
            this.emotions.setHappiness(this.emotions.getHappiness() - adjustment);
        }
        this.emotionChanged();
    }

    public double easeInOutCubic(float x) {
        return (double)x < 0.5 ? (double)(4.0f * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0;
    }

    public void m_21828_(Player pPlayer) {
        this.emotions.setDistress(this.emotions.getDistress() - 70);
        this.emotions.setHappiness(this.emotions.getHappiness() + 60);
        super.m_21828_(pPlayer);
    }

    public void emotionChanged() {
        if (!this.m_9236_().f_46443_) {
            int packedEmotion = this.emotions.getHappiness() << 16 | this.emotions.getDistress() << 8 | this.emotions.getAnger();
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new EmotionPacket((Entity)this, packedEmotion));
        }
    }

    private int adjustTowardsRestingPoint(int currentValue, int adjustmentFactor) {
        int restingPoint = 0;
        int difference = currentValue - restingPoint;
        int adjustment = Math.round((float)difference / (float)adjustmentFactor);
        int newValue = Math.max(0, Math.min(100, currentValue - (adjustment += this.f_19796_.m_188503_(5) - 2)));
        return newValue;
    }

    public boolean m_21262_(DamageSource pDamageSource) {
        if (pDamageSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        ItemStack itemstack = null;
        boolean triggered = false;
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack1 = this.m_21120_(interactionhand);
            if (!itemstack1.m_150930_((Item)ModItems.CROW_ANKH_AMULET.get())) continue;
            itemstack = itemstack1.m_41777_();
            itemstack1.m_41774_(1);
            triggered = true;
            break;
        }
        if (triggered) {
            this.m_21153_(1.0f);
            this.m_21219_();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            this.m_9236_().m_7605_((Entity)this, (byte)35);
            this.sync();
        }
        return triggered;
    }

    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        if (!this.sync && this.m_9236_() instanceof ServerLevel) {
            this.sync();
            this.sync = true;
        }
        if (!this.sync && this.m_9236_() instanceof ClientLevel) {
            if (this.m_9236_().f_46443_) {
                HexereiPacketHandler.sendToServer(new AskForSyncPacket((Entity)this));
            }
            this.sync = true;
        }
        if (this.breedGiftGivenByPartnerTimer > 0 && !this.m_9236_().f_46443_) {
            --this.breedGiftGivenByPartnerTimer;
            if (this.breedGiftGivenByPartnerTimer == 16) {
                this.peck();
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new PeckPacket((Entity)this));
            }
            if (this.breedGiftGivenByPartnerTimer == 0 && this.m_9236_().m_46003_(this.breedGiftGivenByPlayerUUID) != null) {
                this.m_27595_(this.m_9236_().m_46003_(this.breedGiftGivenByPlayerUUID));
                this.m_5634_(4.0f);
                if (!this.m_9236_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new EatParticlesPacket((Entity)this, this.itemHandler.getStackInSlot(1)));
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.f_19796_.m_188503_(5));
                    this.emotionChanged();
                }
                if (this.itemHandler.getStackInSlot(1).hasCraftingRemainingItem()) {
                    this.m_19983_(this.itemHandler.getStackInSlot(1).getCraftingRemainingItem());
                }
                this.itemHandler.getStackInSlot(1).m_41774_(1);
                this.m_5496_(SoundEvents.f_12190_, this.m_6121_(), this.m_6100_());
                this.syncInv();
            }
        }
        this.quirkController.tick(this);
        if (!this.m_9236_().f_46443_) {
            float threshold;
            float health = this.m_21223_();
            if (health < (threshold = this.m_21233_() / 3.0f) && this.f_19797_ - this.lowHealthDistressIncreaseTickLast > 20 && this.f_19796_.m_188503_(10) == 0) {
                this.lowHealthDistressIncreaseTickLast = this.f_19797_;
                this.emotions.setDistress(this.emotions.getDistress() + 5 + this.f_19796_.m_188503_(15));
                this.emotions.setHappiness(this.emotions.getHappiness() - (this.f_19796_.m_188503_(5) + 1));
                this.emotionChanged();
            }
            if (this.f_19797_ % 100 == 0) {
                Player owner;
                if (this.m_21824_() && (livingEntity = this.m_269323_()) instanceof Player && (owner = (Player)livingEntity).m_20270_((Entity)this) < 5.0f) {
                    this.emotions.setHappiness(this.emotions.getHappiness() + (this.f_19796_.m_188503_(5) + 1));
                }
                if (this.emotions.isHappy() && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(1.0f);
                }
            }
        }
        float deltaDist = (float)Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
        float deltaYDist = (float)Math.sqrt(this.m_20184_().f_82480_ * this.m_20184_().f_82480_);
        this.itemHeldSwingLast = this.itemHeldSwing;
        this.itemHeldSwing = this.moveTo(this.itemHeldSwing, Mth.m_14036_((float)(deltaDist * 455.0f - deltaYDist * 300.0f), (float)0.0f, (float)65.0f), 3.0f + 20.0f * Mth.m_14154_((float)(Mth.m_14036_((float)(deltaDist * 455.0f - deltaYDist * -300.0f), (float)0.0f, (float)65.0f) - this.itemHeldSwing)) / 65.0f);
        ++this.animationCounter;
        ++this.rideCooldownCounter;
        if (!this.m_9236_().f_46443_) {
            if (this.m_20096_() && this.m_29443_()) {
                this.f_19804_.m_135381_(DATA_FLYING, (Object)false);
            }
            if (this.isFlyingNav() && !this.m_29443_()) {
                this.f_19804_.m_135381_(DATA_FLYING, (Object)true);
            }
            ++this.emotionTicks;
            if (this.emotionTicks >= 600) {
                this.emotionTicks = 0;
                this.adjustEmotion();
            }
        }
        if ((livingEntity = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            if (this.targetingItem == null && this.currentTask == OwlTask.PICKUP_ITEM) {
                this.currentTask = OwlTask.NONE;
            }
        }
        this.bodyYOffsetLast = this.bodyYOffset;
        this.rightWingAngleLast = this.rightWingAngle;
        this.leftWingAngleLast = this.leftWingAngle;
        this.rightWingMiddleAngleLast = this.rightWingMiddleAngle;
        this.leftWingMiddleAngleLast = this.leftWingMiddleAngle;
        this.bodyXRotLast = this.bodyXRot;
        if (this.m_29443_() && !this.m_20096_()) {
            if (this.m_20184_().f_82480_ < -0.0075) {
                this.bodyXRot = (float)Mth.m_14139_((double)0.15, (double)this.bodyXRot, (double)1.0471975803375244);
                this.rightWingMiddleFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingMiddleFoldAngle, (double)(-((float)Math.toRadians(-15.0))));
                this.leftWingMiddleFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingMiddleFoldAngle, (double)((float)Math.toRadians(-15.0)));
                this.rightWingFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingFoldAngle, (double)((float)Math.toRadians(25.0)));
                this.leftWingFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingFoldAngle, (double)(-((float)Math.toRadians(25.0))));
                this.bodyYOffset = (float)Mth.m_14139_((double)0.45, (double)this.bodyYOffset, (double)Math.sin((Hexerei.getClientTicksWithoutPartial() + 2.0f) / 8.0f));
                this.rightWingAngle = (float)Mth.m_14139_((double)0.75, (double)this.rightWingAngle, (double)(Math.sin(Hexerei.getClientTicksWithoutPartial() / 8.0f) * (double)0.1f));
                this.leftWingAngle = (float)Mth.m_14139_((double)0.75, (double)this.leftWingAngle, (double)(-Math.sin(Hexerei.getClientTicksWithoutPartial() / 8.0f) * (double)0.1f));
                this.rightWingMiddleAngle = (float)Mth.m_14139_((double)0.75, (double)this.rightWingMiddleAngle, (double)((double)(Mth.m_14031_((float)((Hexerei.getClientTicksWithoutPartial() - 8.0f) / 8.0f)) * 0.25f) - 0.125));
                this.leftWingMiddleAngle = (float)Mth.m_14139_((double)0.75, (double)this.leftWingMiddleAngle, (double)((double)(-Mth.m_14031_((float)((Hexerei.getClientTicksWithoutPartial() - 8.0f) / 8.0f)) * 0.25f) + 0.125));
            } else {
                this.bodyXRot = (float)Mth.m_14139_((double)0.15, (double)this.bodyXRot, (double)0.7853981852531433);
                this.rightWingMiddleFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingMiddleFoldAngle, (double)(-((float)Math.toRadians(5.0))));
                this.leftWingMiddleFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingMiddleFoldAngle, (double)((float)Math.toRadians(5.0)));
                this.rightWingFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingFoldAngle, (double)((float)Math.toRadians(0.0)));
                this.leftWingFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingFoldAngle, (double)(-((float)Math.toRadians(0.0))));
                this.bodyYOffset = (float)Mth.m_14139_((double)0.45, (double)this.bodyYOffset, (double)Math.sin((Hexerei.getClientTicksWithoutPartial() + 1.0f) / 4.0f));
                this.rightWingAngle = (float)Mth.m_14139_((double)0.75, (double)this.rightWingAngle, (double)(Math.sin(Hexerei.getClientTicksWithoutPartial() / 4.0f) * 1.0));
                this.leftWingAngle = (float)Mth.m_14139_((double)0.75, (double)this.leftWingAngle, (double)(-Math.sin(Hexerei.getClientTicksWithoutPartial() / 4.0f) * 1.0));
                this.rightWingMiddleAngle = (float)Mth.m_14139_((double)0.75, (double)this.rightWingMiddleAngle, (double)((double)(Mth.m_14031_((float)((Hexerei.getClientTicksWithoutPartial() - 4.0f) / 4.0f)) * 0.5f) - 0.25));
                this.leftWingMiddleAngle = (float)Mth.m_14139_((double)0.75, (double)this.leftWingMiddleAngle, (double)((double)(-Mth.m_14031_((float)((Hexerei.getClientTicksWithoutPartial() - 4.0f) / 4.0f)) * 0.5f) + 0.25));
            }
            this.rightWingTipAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingTipAngle, (double)((float)Math.toRadians(15.0)));
            this.leftWingTipAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingTipAngle, (double)(-((float)Math.toRadians(15.0))));
        } else {
            this.bodyXRot = (float)Mth.m_14139_((double)0.25, (double)this.bodyXRot, (double)0.0);
            this.bodyYOffset = (float)Mth.m_14139_((double)0.25, (double)this.bodyYOffset, (double)0.0);
            this.rightWingAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingAngle, (double)(-((float)Math.toRadians(85.0))));
            this.leftWingAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingAngle, (double)((float)Math.toRadians(85.0)));
            this.rightWingMiddleAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingMiddleAngle, (double)(-((float)Math.toRadians(10.0))));
            this.leftWingMiddleAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingMiddleAngle, (double)((float)Math.toRadians(10.0)));
            this.rightWingMiddleFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingMiddleFoldAngle, (double)((float)Math.toRadians(30.0)));
            this.leftWingMiddleFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingMiddleFoldAngle, (double)(-((float)Math.toRadians(30.0))));
            this.rightWingFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingFoldAngle, (double)((float)Math.toRadians(0.0)));
            this.leftWingFoldAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingFoldAngle, (double)(-((float)Math.toRadians(0.0))));
            this.rightWingTipAngle = (float)Mth.m_14139_((double)0.45, (double)this.rightWingTipAngle, (double)((float)Math.toRadians(60.0)));
            this.leftWingTipAngle = (float)Mth.m_14139_((double)0.45, (double)this.leftWingTipAngle, (double)(-((float)Math.toRadians(60.0))));
        }
        this.animationController.tick();
        this.messagingController.tick();
        if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 60 && this.isOwlEdible(this.itemHandler.getStackInSlot(1)) && (!this.m_21824_() || this.m_21223_() < this.m_21233_() || this.emotions.getDistress() > 50 || this.emotionState == EmotionState.DISTRESSED)) {
                this.heldItemTime = 0;
                this.m_5634_(4.0f);
                if (!this.m_9236_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new EatParticlesPacket((Entity)this, this.itemHandler.getStackInSlot(1)));
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.f_19796_.m_188503_(5));
                    this.emotionChanged();
                }
                this.m_5496_(SoundEvents.f_12190_, this.m_6121_(), this.m_6100_());
                if (TEMPTATION_ITEMS.test(this.itemHandler.getStackInSlot(1)) && this.fishThrowerID != null && !this.m_21824_()) {
                    if (this.m_217043_().m_188501_() < 0.5f && this.m_9236_().m_46003_(this.fishThrowerID) != null && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)this.m_9236_().m_46003_(this.fishThrowerID))) {
                        this.m_7105_(true);
                        this.m_21816_(this.fishThrowerID);
                        Player player = this.m_9236_().m_46003_(this.fishThrowerID);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
                        }
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                if (this.itemHandler.getStackInSlot(1).hasCraftingRemainingItem()) {
                    this.m_19983_(this.itemHandler.getStackInSlot(1).getCraftingRemainingItem());
                }
                this.itemHandler.getStackInSlot(1).m_41774_(1);
                this.syncInv();
            }
        } else {
            this.heldItemTime = 0;
        }
        this.determineEmotionState();
    }

    public void eatParticles(ItemStack stack) {
        float scale = 3.0f;
        if (this.m_6162_()) {
            scale = 4.0f;
        }
        Vec3 vec3 = this.m_20171_(0.0f, this.f_20885_);
        for (int i = 0; i < 6; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20208_(0.125) + vec3.f_82479_ / (double)scale, this.f_19796_.m_188500_() / 4.0 - 0.125 + this.m_20188_(), this.m_20262_(0.125) + vec3.f_82481_ / (double)scale, (this.f_19796_.m_188500_() - 0.5) / 15.0, (this.f_19796_.m_188500_() + 0.5) * 0.15, (this.f_19796_.m_188500_() - 0.5) / 15.0);
        }
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public void setPerchPos(BlockPos pos) {
        this.f_19804_.m_135381_(PERCH_POS, Optional.ofNullable(pos));
    }

    public BlockPos getPerchPos() {
        return ((Optional)this.f_19804_.m_135370_(PERCH_POS)).orElse(null);
    }

    public DyeColor getDyeColor() {
        DyeColor color = HexereiUtil.getDyeColorNamed(this.m_7755_().getString(), 0);
        return color == null ? DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(OWL_DYE_COLOR))) : color;
    }

    public int getDyeColorId() {
        return (Integer)this.f_19804_.m_135370_(OWL_DYE_COLOR);
    }

    public void setDyeColor(int color) {
        this.f_19804_.m_135381_(OWL_DYE_COLOR, (Object)color);
    }

    public void setDyeColor(DyeColor color) {
        this.f_19804_.m_135381_(OWL_DYE_COLOR, (Object)color.m_41060_());
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return this.createFlyingNavigation(worldIn);
    }

    protected PathNavigation createFlyingNavigation(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    protected PathNavigation createGroundNavigation(Level worldIn) {
        GroundPathNavigation groundpathnavigator = new GroundPathNavigation((Mob)this, worldIn);
        groundpathnavigator.m_26477_(false);
        groundpathnavigator.m_7008_(true);
        groundpathnavigator.m_148214_(true);
        return groundpathnavigator;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22265_();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return switch (slot.m_20743_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.Type.HAND -> this.itemHandler.getStackInSlot(1);
            case EquipmentSlot.Type.ARMOR -> this.itemHandler.getStackInSlot(0);
        };
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readAdditionalSaveDataNoSuper(compound);
    }

    public void readAdditionalSaveDataNoSuper(CompoundTag compound) {
        this.setTypeVariant(compound.m_128451_("Variant"));
        if (compound.m_128441_("IsFlyingNav")) {
            this.switchNavigator(compound.m_128471_("IsFlyingNav"), true);
        }
        if (compound.m_128441_("IsFlying")) {
            this.f_19804_.m_135381_(DATA_FLYING, (Object)compound.m_128471_("IsFlying"));
        } else {
            this.f_19804_.m_135381_(DATA_FLYING, (Object)false);
        }
        if (compound.m_128441_("InteractionRange")) {
            this.interactionRange = compound.m_128451_("InteractionRange");
        }
        if (compound.m_128441_("CanAttack")) {
            this.canAttack = compound.m_128471_("CanAttack");
        }
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        if (compound.m_128441_("PerchX") && compound.m_128441_("PerchY") && compound.m_128441_("PerchZ")) {
            this.setPerchPos(new BlockPos(compound.m_128451_("PerchX"), compound.m_128451_("PerchY"), compound.m_128451_("PerchZ")));
        }
        if (compound.m_128441_("DyeColor")) {
            this.setDyeColor(compound.m_128451_("DyeColor"));
        }
        if (compound.m_128441_("EmotionScales")) {
            int packedEmotionScales = compound.m_128451_("EmotionScales");
            int happiness = packedEmotionScales >> 16 & 0xFF;
            int distress = packedEmotionScales >> 8 & 0xFF;
            int anger = packedEmotionScales & 0xFF;
            this.emotions = new Emotions(anger, distress, happiness);
        }
        this.quirkController.read(compound);
        this.messagingController.read(compound);
        if (compound.m_128441_("task")) {
            this.currentTask = OwlTask.byId(compound.m_128451_("task"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("InteractionRange", this.interactionRange);
        compound.m_128379_("CanAttack", this.canAttack);
        compound.m_128379_("IsFlying", this.m_29443_());
        compound.m_128379_("IsFlyingNav", this.isFlyingNav());
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        if (this.getPerchPos() != null) {
            compound.m_128405_("PerchX", this.getPerchPos().m_123341_());
            compound.m_128405_("PerchY", this.getPerchPos().m_123342_());
            compound.m_128405_("PerchZ", this.getPerchPos().m_123343_());
        }
        compound.m_128405_("DyeColor", this.getDyeColorId());
        int packedEmotionScales = this.emotions.getHappiness() << 16 | this.emotions.getDistress() << 8 | this.emotions.getAnger();
        compound.m_128405_("EmotionScales", packedEmotionScales);
        this.quirkController.write(compound);
        this.messagingController.write(compound);
        compound.m_128405_("task", this.currentTask.ordinal());
    }

    public void addAdditionalSaveDataNoSuper(CompoundTag compound) {
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("InteractionRange", this.interactionRange);
        compound.m_128379_("CanAttack", this.canAttack);
        compound.m_128379_("IsFlying", this.m_29443_());
        compound.m_128379_("IsFlyingNav", this.isFlyingNav());
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        if (this.getPerchPos() != null) {
            compound.m_128405_("PerchX", this.getPerchPos().m_123341_());
            compound.m_128405_("PerchY", this.getPerchPos().m_123342_());
            compound.m_128405_("PerchZ", this.getPerchPos().m_123343_());
        }
        compound.m_128405_("DyeColor", this.getDyeColorId());
        int packedEmotionScales = this.emotions.getDistress() << 8 | this.emotions.getAnger();
        compound.m_128405_("EmotionScales", packedEmotionScales);
        this.quirkController.write(compound);
        this.messagingController.write(compound);
        compound.m_128405_("task", this.currentTask.ordinal());
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        OwlVariant variant;
        RandomSource randomsource = pLevel.m_213780_();
        if (pSpawnData instanceof CrowGroupData) {
            variant = ((CrowGroupData)((Object)pSpawnData)).variant;
        } else {
            boolean isVariant = randomsource.m_188503_(5) == 0;
            variant = (OwlVariant)((Object)Util.m_214670_((Object[])OwlVariant.values(), (RandomSource)randomsource));
            if (!isVariant) {
                variant = OwlVariant.GREAT_HORNED;
            }
            pSpawnData = new CrowGroupData(variant);
        }
        this.setTypeVariant(variant.getId() & 0xFF);
        Collection col = ForgeRegistries.BLOCKS.getValues();
        for (int i = 0; i < 25; ++i) {
            Object object = col.toArray()[(int)((float)col.size() * new Random().nextFloat())];
            if (!(object instanceof Block)) continue;
            Block block = (Block)object;
            BlockState state = block.m_49966_();
            try {
                if (!Block.m_49918_((VoxelShape)block.m_5939_(state, (BlockGetter)pLevel, this.m_20183_(), CollisionContext.m_82749_()), (Direction)Direction.UP) || block.m_5456_() == Items.f_41852_) continue;
                this.quirkController.addQuirk(new FavoriteBlockQuirk(block, 20));
                break;
            }
            catch (Exception err) {
                LOGGER.error("Error trying to set block as favorite: {}", (Object)block, (Object)err);
            }
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 motion = this.m_20184_();
        if (this.m_29443_() && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.7, 1.0));
        }
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.getPerchPos() == null) {
            if ((this.m_21827_() || this.m_21825_()) && this.currentTask.isNone()) {
                if (this.m_21573_().m_26570_() != null) {
                    this.m_21573_().m_26573_();
                }
                vec3d = Vec3.f_82478_;
            }
        } else {
            double topOffset = this.m_9236_().m_8055_(this.getPerchPos()).m_60734_().m_7952_(this.m_9236_().m_8055_(this.getPerchPos()), (BlockGetter)this.m_9236_(), this.getPerchPos()).m_83297_(Direction.Axis.Y);
            if (this.distanceTo(this.getPerchPos().m_123341_(), this.getPerchPos().m_123343_()) < 1.0 && this.m_20182_().m_7098_() >= (double)this.getPerchPos().m_123342_() + topOffset && this.m_20182_().m_7098_() < (double)this.getPerchPos().m_7494_().m_123342_() + topOffset - 0.75 && (this.m_21827_() || this.m_21825_()) && this.currentTask.isNone()) {
                if (this.m_21573_().m_26570_() != null) {
                    this.m_21573_().m_26573_();
                }
                vec3d = Vec3.f_82478_;
            }
        }
        super.m_7023_(vec3d);
    }

    public double distanceTo(double p_20276_, double p_20278_) {
        double d0 = this.m_20185_() - p_20276_ - 0.5;
        double d1 = this.m_20189_() - p_20278_ - 0.5;
        return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public OptionalInt getFramedMapId() {
        Integer integer;
        ItemStack itemstack = this.m_8020_(2);
        if (itemstack.m_150930_(Items.f_42573_) && (integer = MapItem.m_151131_((ItemStack)itemstack)) != null) {
            return OptionalInt.of(integer);
        }
        return OptionalInt.empty();
    }

    public Map<String, Vector3f> getModelRotationValues() {
        return this.modelRotationValues;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        OwlEntity owl = (OwlEntity)((EntityType)ModEntityTypes.OWL.get()).m_20615_((Level)world);
        if (owl != null) {
            OwlVariant owlVariant = this.f_19796_.m_188499_() ? this.getVariant() : ((OwlEntity)entity).getVariant();
            owl.setTypeVariant(owlVariant.getId() & 0xFF);
            owl.m_21530_();
        }
        return owl;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.itemHandler.getStackInSlot(1).m_41619_()) {
            if (!this.m_21824_() && this.isOwlTemptItem(itemstack)) {
                ItemStack particleCopy = itemstack.m_41777_();
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.f_19796_.m_188503_(5));
                    this.emotionChanged();
                    this.m_5634_(4.0f);
                    if (!this.m_9236_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new EatParticlesPacket((Entity)this, particleCopy));
                    }
                    if (this.f_19796_.m_188503_(5) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.m_21828_(player);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_21824_() && this.isOwlTemptItem(itemstack) && (this.emotions.getDistress() > 15 || !this.isMaxHealth())) {
                ItemStack particleCopy = itemstack.m_41777_();
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.f_19796_.m_188503_(5));
                    this.emotionChanged();
                    this.m_5634_(4.0f);
                    if (!this.m_9236_().f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.m_9236_().m_46745_(this.m_20183_())), (Object)new EatParticlesPacket((Entity)this, particleCopy));
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!player.m_36341_() && this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6162_() && itemstack.m_41720_() == Items.f_42697_ && !this.m_27593_()) {
                if (this.m_146764_() == 0) {
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (!this.m_9236_().f_46443_) {
                        this.m_27595_(player);
                        this.m_19983_(this.itemHandler.getStackInSlot(1).m_41777_());
                        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)Items.f_42697_));
                        this.breedGiftGivenByPlayer = true;
                        this.breedGiftGivenByPlayerUUID = player.m_20148_();
                        this.currentTask = OwlTask.BREEDING;
                    }
                } else if (!this.headShakeAnimation.active) {
                    this.headShakeAnimation.start();
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (player.m_36341_() && this.m_21830_((LivingEntity)player)) {
                if (!this.m_9236_().m_5776_()) {
                    MenuProvider containerProvider = this.createContainerProvider(this.m_9236_(), this.m_20183_());
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, b -> b.writeInt(this.m_19879_()));
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_41720_() == ModItems.COURIER_LETTER.get()) {
                if (this.m_269323_() == player) {
                    if (this.m_9236_().f_46443_) {
                        if (!CourierLetterItem.isSealed(itemstack)) {
                            player.m_213846_((Component)Component.m_237115_((String)"hexerei.letter.empty"));
                        }
                    } else if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (CourierLetterItem.isSealed(itemstack)) {
                            HexereiPacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundOpenOwlCourierSendScreenPacket(this.m_19879_(), hand, player.m_150109_().f_35977_));
                        }
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_41720_() == ModItems.COURIER_PACKAGE.get()) {
                CourierPackageItem.PackageInvWrapper wrapper = new CourierPackageItem.PackageInvWrapper(itemstack);
                boolean empty = wrapper.isEmpty();
                if (this.m_269323_() == player) {
                    if (this.m_9236_().f_46443_) {
                        if (empty || !wrapper.getSealed()) {
                            player.m_213846_((Component)Component.m_237115_((String)"hexerei.package.empty"));
                        }
                    } else if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (!empty && wrapper.getSealed()) {
                            HexereiPacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundOpenOwlCourierSendScreenPacket(this.m_19879_(), hand, player.m_150109_().f_35977_));
                        }
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                DyeColor dyecolor;
                if (itemstack.m_41720_() instanceof DyeItem && ((dyecolor = ((DyeItem)itemstack.m_41720_()).m_41089_()) != this.getDyeColor() || this.getDyeColorId() == -1)) {
                    this.setDyeColor(dyecolor);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_6668_(DamageSource p_21192_) {
        ItemStack hat = this.itemHandler.getStackInSlot(0);
        ItemStack itemstack = this.itemHandler.getStackInSlot(1);
        ItemStack messageStack = this.messagingController.getMessageStack();
        if (!itemstack.m_41619_()) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        if (!hat.m_41619_()) {
            this.m_19983_(hat.m_41777_());
            this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        }
        if (!messageStack.m_41619_()) {
            this.m_19983_(messageStack.m_41777_());
            this.messagingController.messageStack = ItemStack.f_41583_;
        }
        super.m_6668_(p_21192_);
    }

    private boolean isOwlEdible(ItemStack stack) {
        return stack.m_41720_().m_41472_() || this.isOwlTemptItem(stack);
    }

    private boolean isOwlTemptItem(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        if (this.m_21824_()) {
            if (this.m_21223_() < this.m_21233_()) {
                return this.isOwlEdible(stack);
            }
            if (this.emotions.getDistress() > 50 || this.emotionState == EmotionState.DISTRESSED) {
                return this.isOwlTemptItem(stack);
            }
        }
        return !this.m_21824_() && this.isOwlEdible(stack) && !this.isMaxHealth() || this.isOwlTemptItem(stack);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.m_32055_().m_41777_();
        duplicate.m_41764_(1);
        if (!this.itemHandler.getStackInSlot(1).m_41619_() && !this.m_9236_().f_46443_) {
            this.m_5552_(this.itemHandler.getStackInSlot(1), 0.0f);
        }
        Entity itemThrower = e.m_19749_();
        this.itemHandler.setStackInSlot(1, duplicate);
        this.fishThrowerID = TEMPTATION_ITEMS.test(e.m_32055_()) && !this.m_21824_() ? (itemThrower == null ? null : itemThrower.m_20148_()) : null;
        if (this.currentTask == OwlTask.PICKUP_ITEM) {
            this.currentTask = OwlTask.NONE;
        }
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        if (this.currentTask.isNone()) {
            this.currentTask = OwlTask.PICKUP_ITEM;
        }
        ITargetsDroppedItems.super.onFindTarget(e);
    }

    @Override
    public double getMaxDistToItem() {
        return 1.0;
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FLYING);
    }

    public boolean canSitOnShoulder() {
        return this.rideCooldownCounter > 100;
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.m_7324_(entityIn);
        }
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return this.itemHandler.isItemValid(pIndex, pStack);
    }

    public boolean m_271862_(Container pTarget, int pIndex, ItemStack pStack) {
        return false;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(index).m_41777_();
        if (count >= stack.m_41613_()) {
            this.itemHandler.setStackInSlot(index, ItemStack.f_41583_);
        } else {
            this.itemHandler.getStackInSlot(index).m_41764_(stack.m_41613_() - count);
            stack.m_41764_(count);
        }
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index).m_41777_();
        this.itemHandler.setStackInSlot(index, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < 3) {
            this.itemHandler.setStackInSlot(index, stack);
        }
        this.syncAdditionalData();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        if (this.m_213877_()) {
            return false;
        }
        return !(player.m_20280_((Entity)this) > 144.0);
    }

    public void m_6211_() {
        for (int i = 0; i < 3; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new OwlContainer(id, this, inv, player);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    private MenuProvider createContainerProvider(Level worldIn, BlockPos pos) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new OwlContainer(i, OwlEntity.this, playerInventory, playerEntity);
            }

            public Component m_5446_() {
                return Component.m_237115_((String)"");
            }
        };
    }

    public boolean m_7090_() {
        return false;
    }

    public void m_5757_(Container p_18983_) {
        ItemStack stack = p_18983_.m_8020_(0);
        stack.m_41636_((Entity)this);
    }

    public static void teleportParticles(Level level, Vec3 pos, OwlVariant owlVariant) {
        if (level.m_5776_()) {
            for (int i = 0; i < 10; ++i) {
                RandomSource random = level.m_213780_();
                SimpleParticleType particleType = OwlEntity.getParticle(owlVariant);
                Vec3 offset = new Vec3(random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1));
                level.m_6493_((ParticleOptions)particleType, true, pos.m_7096_() + 0.5 + offset.f_82479_, pos.m_7098_() + random.m_188500_() * (double)0.15f, pos.m_7094_() + 0.5 + offset.f_82481_, offset.f_82479_ / 4.0, random.m_188500_() * -0.05 - 0.05, offset.f_82481_ / 4.0);
            }
            RandomSource random = level.m_213780_();
            SimpleParticleType particleType = (SimpleParticleType)ModParticleTypes.STAR_BRUSH.get();
            float radius = 3.0f;
            for (int i = 0; i < 10; ++i) {
                float rotation = random.m_188501_() * 18.0f + 36.0f * (float)i;
                float rad = radius * random.m_188501_() * 0.5f;
                Vec3 offset = new Vec3((double)rad * Math.cos(rotation), 0.0, (double)rad * Math.sin(rotation));
                level.m_6493_((ParticleOptions)particleType, true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.m_188500_() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 20.0, random.m_188500_() * 0.025, offset.f_82481_ / 20.0);
            }
        }
    }

    public static SimpleParticleType getParticle(OwlVariant owlVariant) {
        return switch (owlVariant) {
            default -> throw new IncompatibleClassChangeError();
            case OwlVariant.GREAT_HORNED -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT.get();
            case OwlVariant.BARN -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT_BARN.get();
            case OwlVariant.BARRED -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT_BARRED.get();
            case OwlVariant.SNOWY -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT_SNOWY.get();
        };
    }

    private void flyOrWalkTo(Vec3 pos) {
        Path path1 = this.flyingNav.m_7864_(BlockPos.m_274446_((Position)pos), 0);
        Path path2 = this.groundNav.m_7864_(BlockPos.m_274446_((Position)pos), 0);
        if (path1 != null) {
            if (path2 == null || !path2.m_77403_()) {
                this.switchNavigator(true);
            } else if (path2.m_77407_() > path1.m_77407_()) {
                this.switchNavigator(true);
            } else {
                this.switchNavigator(!this.f_19796_.m_188499_());
            }
        }
    }

    private void walkToIfNotFlyTo(Vec3 pos) {
        Path path1 = this.flyingNav.m_7864_(BlockPos.m_274446_((Position)pos), 0);
        Path path2 = this.groundNav.m_7864_(BlockPos.m_274446_((Position)pos), 0);
        if (path1 != null) {
            if (path2 == null) {
                this.switchNavigator(true);
            } else if (Math.max(0.0f, path2.m_77407_() - 2.0f) > path1.m_77407_()) {
                this.switchNavigator(true);
            } else {
                this.switchNavigator(false);
            }
        }
    }

    private void teleportToOwner() {
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof Player) {
            Player owner = (Player)livingEntity;
            BlockPos blockpos = owner.m_20183_();
            for (int i = 0; i < 30; ++i) {
                int j = this.randomIntInclusive(-5, 5);
                int k = this.randomIntInclusive(-1, 5);
                int l = this.randomIntInclusive(-5, 5);
                boolean flag = this.teleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }
    }

    private boolean teleportToDest(ResourceKey<Level> dim, BlockPos blockpos) {
        for (int i = 0; i < 30; ++i) {
            int j = this.randomInt(6, 12);
            int k = this.randomInt(6, 12);
            int l = this.randomInt(6, 12);
            boolean flag = this.teleportTo(dim, blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    private int randomInt(int min, int max) {
        return (this.m_217043_().m_188503_(max - min + 1) + min) * (this.m_217043_().m_188499_() ? -1 : 1);
    }

    private boolean teleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.switchNavigator(true, true);
        this.m_6034_(x, y, z);
        this.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.m_146908_(), this.m_146909_());
        return true;
    }

    private boolean teleportTo(ResourceKey<Level> dim, int x, int y, int z) {
        if (!this.canTeleportTo(dim, new BlockPos(x, y, z))) {
            return false;
        }
        this.switchNavigator(true, true);
        this.m_6034_(x, y, z);
        this.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.m_146908_(), this.m_146909_());
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        if (pos.m_123342_() <= -64) {
            return false;
        }
        BlockPos offset = pos.m_121996_((Vec3i)this.m_20183_());
        FluidState state = this.m_9236_().m_6425_(pos);
        return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82338_(offset)) && state.m_76178_();
    }

    private boolean canTeleportTo(ResourceKey<Level> dim, BlockPos pos) {
        if (pos.m_123342_() <= -64) {
            return false;
        }
        BlockPos offset = pos.m_121996_((Vec3i)this.m_20183_());
        if (this.m_20194_().m_129880_(dim) == null) {
            return false;
        }
        FluidState state = this.m_20194_().m_129880_(dim).m_6425_(pos);
        return this.m_20194_().m_129880_(dim).m_45756_((Entity)this, this.m_20191_().m_82338_(offset)) && state.m_76178_();
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
    }

    public static enum BrowPositioning {
        NORMAL(0.0f, 0.0f, 0.0f),
        PLEAD(0.75f, 0.05f, 40.0f),
        ANGRY(0.25f, 0.5f, -15.0f);

        final float xOffset;
        final float yOffset;
        final float zRot;

        private BrowPositioning(float xOffset, float yOffset, float zRot) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zRot = zRot;
        }

        public float getxOffset() {
            return this.xOffset;
        }

        public float getyOffset() {
            return this.yOffset;
        }

        public float getzRot() {
            return this.zRot;
        }
    }

    private static class OwlMoveController
    extends MoveControl {
        private final int maxTurn;

        public OwlMoveController(OwlEntity crow, int pMaxTurn) {
            super((Mob)crow);
            this.maxTurn = pMaxTurn;
        }

        public void m_8126_() {
            if (this.f_24974_.m_21573_() instanceof FlyingPathNavigation) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.f_24974_.m_20242_(true);
                    double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                    double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                    double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (d3 < 2.500000277905201E-7) {
                        this.f_24974_.m_21567_(0.0f);
                        this.f_24974_.m_21564_(0.0f);
                        return;
                    }
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 90.0f));
                    float f1 = this.f_24974_.m_20096_() ? (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                    this.f_24974_.m_7910_(f1);
                    double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                    if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                        float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                        this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f2, this.maxTurn));
                        this.f_24974_.m_21567_(d1 > 0.0 ? f1 : -f1);
                    }
                } else {
                    this.f_24974_.m_20242_(false);
                    this.f_24974_.m_21567_(0.0f);
                    this.f_24974_.m_21564_(0.0f);
                }
            } else if (this.f_24981_ == MoveControl.Operation.STRAFE) {
                float f8;
                float f = (float)this.f_24974_.m_21133_(Attributes.f_22279_);
                float f1 = (float)this.f_24978_ * f;
                float f2 = this.f_24979_;
                float f3 = this.f_24980_;
                float f4 = Mth.m_14116_((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = Mth.m_14031_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
                float f6 = Mth.m_14089_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                if (!this.m_24996_(f7, f8 = f3 * f6 + f2 * f5)) {
                    this.f_24979_ = 1.0f;
                    this.f_24980_ = 0.0f;
                }
                this.f_24974_.m_7910_(f1);
                this.f_24974_.m_21564_(this.f_24979_);
                this.f_24974_.m_21570_(this.f_24980_);
                this.f_24981_ = MoveControl.Operation.WAIT;
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d1 = this.f_24977_ - this.f_24974_.m_20189_();
                double d2 = this.f_24976_ - this.f_24974_.m_20186_();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float f9 = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f9, 90.0f));
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                BlockPos blockpos = this.f_24974_.m_20183_();
                BlockState blockstate = this.f_24974_.m_9236_().m_8055_(blockpos);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)this.f_24974_.m_9236_(), blockpos);
                if (d2 > (double)this.f_24974_.getStepHeight() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.f_24974_.m_20205_()) || !voxelshape.m_83281_() && this.f_24974_.m_20186_() < voxelshape.m_83297_(Direction.Axis.Y) + (double)blockpos.m_123342_() && !blockstate.m_204336_(BlockTags.f_13103_) && !blockstate.m_204336_(BlockTags.f_13039_)) {
                    this.f_24974_.m_21569_().m_24901_();
                    this.f_24981_ = MoveControl.Operation.JUMPING;
                }
            } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                if (this.f_24974_.m_20096_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            } else {
                this.f_24974_.m_21564_(0.0f);
            }
        }

        private boolean m_24996_(float pRelativeX, float pRelativeZ) {
            NodeEvaluator nodeevaluator;
            PathNavigation pathnavigation = this.f_24974_.m_21573_();
            return pathnavigation == null || (nodeevaluator = pathnavigation.m_26575_()) == null || nodeevaluator.m_8086_((BlockGetter)this.f_24974_.m_9236_(), Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)pRelativeX)), this.f_24974_.m_146904_(), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)pRelativeZ))) == BlockPathTypes.WALKABLE;
        }
    }

    public static enum OwlTask {
        NONE,
        DELIVER_MESSAGE,
        GO_TO_FAVORITE_BLOCK,
        PICKUP_ITEM,
        BREEDING;


        public boolean isNoneOr(OwlTask owlTask) {
            return this == owlTask || this == NONE;
        }

        public boolean is(OwlTask owlTask) {
            return this == owlTask;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public static OwlTask byId(int id) {
            OwlTask[] type = OwlTask.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }
    }

    public class AnimationController {
        private List<Animation> animations = new ArrayList<Animation>();

        public void addAnimation(Animation animation) {
            this.animations.add(animation);
        }

        public void tick() {
            for (Animation animation : this.animations) {
                animation.tick();
            }
        }
    }

    public class BrowAnimation
    extends AnimationBase {
        private BrowAnim browAnim;
        private float browRotTarget;
        private float browRot;
        private OwlEntity owl;

        public float getBrowRot() {
            return this.browRot;
        }

        public void setBrowAnim(BrowAnim browAnim) {
            this.browAnim = browAnim;
        }

        public BrowAnim getBrowAnim() {
            return this.browAnim;
        }

        public BrowAnimation(OwlEntity owl) {
            this.browAnim = BrowAnim.BOTH;
            this.browRot = 0.0f;
            this.browRotTarget = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.m_9236_().f_46443_) {
                this.browRotTarget = Mth.m_14031_((float)(this.owl.f_19797_ + this.owl.m_19879_() * 342)) * 16.0f;
            }
        }

        @Override
        public void postTick() {
            this.browRot = OwlEntity.this.moveTo(this.browRot, this.browRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = 5 + this.owl.m_217043_().m_188503_(10);
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.owl.m_9236_().m_46745_(this.owl.m_20183_())), (Object)new BrowAnimPacket((Entity)this.owl, BrowAnim.values()[this.owl.m_217043_().m_188503_(BrowAnim.values().length)], this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.f_19796_.m_188503_(160) + 60;
            this.browRotTarget = 0.0f;
        }
    }

    public static interface Animation {
        public void tick();

        public void start();

        public void stop();

        public boolean isActive();
    }

    public class BrowHappyAnimation
    extends AnimationBase {
        private BrowAnim browAnim;
        private float browRotTarget;
        private float browRot;
        private float browRotLast;
        private OwlEntity owl;

        public float getBrowRot() {
            return this.browRot;
        }

        public float getBrowRotLast() {
            return this.browRotLast;
        }

        public void setBrowAnim(BrowAnim browAnim) {
            this.browAnim = browAnim;
        }

        public BrowAnim getBrowAnim() {
            return this.browAnim;
        }

        public BrowHappyAnimation(OwlEntity owl) {
            this.browAnim = BrowAnim.BOTH;
            this.browRot = 0.0f;
            this.browRotTarget = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.m_9236_().f_46443_) {
                float val = this.owl.f_19797_ + this.owl.m_19879_() * 342;
                this.browRotTarget = Mth.m_14031_((float)val) * 26.0f;
            }
        }

        @Override
        public void postTick() {
            this.browRotLast = this.browRot;
            this.browRot = OwlEntity.this.moveTo(this.browRot, this.browRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = 15 + this.owl.m_217043_().m_188503_(10);
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.owl.m_9236_().m_46745_(this.owl.m_20183_())), (Object)new BrowAnimPacket((Entity)this.owl, BrowAnim.values()[this.owl.m_217043_().m_188503_(BrowAnim.values().length)], this.activeTimer, true));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.f_19796_.m_188503_(160) + 60;
            this.browRotTarget = 0.0f;
        }
    }

    public class TailWagAnimation
    extends AnimationBase {
        private float wagRotTarget;
        private float wagRot;
        private OwlEntity owl;

        public float getWagRot() {
            return this.wagRot;
        }

        public TailWagAnimation(OwlEntity owl) {
            this.wagRotTarget = 0.0f;
            this.wagRot = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.m_9236_().f_46443_) {
                this.wagRotTarget = Mth.m_14031_((float)(this.owl.f_19797_ + this.owl.m_19879_() * 342)) * 100.0f;
            }
        }

        @Override
        public void postTick() {
            this.wagRot = OwlEntity.this.moveTo(this.wagRot, this.wagRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = 5 + this.owl.m_217043_().m_188503_(10);
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.owl.m_9236_().m_46745_(this.owl.m_20183_())), (Object)new TailWagPacket((Entity)this.owl, this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.f_19796_.m_188503_(160) + 20;
            this.wagRotTarget = 0.0f;
        }
    }

    public class TailFanAnimation
    extends AnimationBase {
        private float fanRotTarget;
        private float fanRot;
        private OwlEntity owl;

        public float getFanRot() {
            return this.fanRot;
        }

        public TailFanAnimation(OwlEntity owl) {
            this.fanRotTarget = 0.0f;
            this.fanRot = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.m_9236_().f_46443_) {
                this.fanRotTarget = Mth.m_14031_((float)(this.owl.f_19797_ + this.owl.m_19879_() * 342)) * 100.0f;
            }
        }

        @Override
        public void postTick() {
            this.fanRot = OwlEntity.this.moveTo(this.fanRot, this.fanRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = 5 + this.owl.m_217043_().m_188503_(10);
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.owl.m_9236_().m_46745_(this.owl.m_20183_())), (Object)new TailFanPacket((Entity)this.owl, this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.f_19796_.m_188503_(160) + 20;
            this.fanRotTarget = 0.0f;
        }
    }

    public class HootAnimation
    extends AnimationBase {
        private float hootRotTarget;
        private float hootRot;
        private OwlEntity owl;

        public float getHootRot() {
            return this.hootRot;
        }

        public HootAnimation(OwlEntity owl) {
            this.hootRotTarget = 0.0f;
            this.hootRot = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.m_9236_().f_46443_) {
                this.hootRotTarget = 80.0f;
            }
        }

        @Override
        public void postTick() {
            this.hootRot = OwlEntity.this.moveTo(this.hootRot, this.hootRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = 15;
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> OwlEntity.this.m_9236_().m_46745_(OwlEntity.this.m_20183_())), (Object)new OwlHootPacket((Entity)this.owl, this.activeTimer));
                this.owl.m_5496_((SoundEvent)ModSounds.OWL_HOOT.get(), this.owl.m_6121_(), this.owl.m_6100_());
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.f_19796_.m_188503_(560) + 160;
            this.hootRotTarget = 0.0f;
        }
    }

    public class PeckAnimation
    extends AnimationBase {
        private float peckRotTarget;
        private float peckRot;
        private OwlEntity owl;

        public float getPeckRot() {
            return this.peckRot;
        }

        public PeckAnimation(OwlEntity owl) {
            this.peckRotTarget = 0.0f;
            this.peckRot = 0.0f;
            this.owl = owl;
            this.useCooldown = false;
        }

        @Override
        public void activeTick() {
            this.peckRotTarget = 80.0f;
        }

        @Override
        public void postTick() {
            this.peckRot = OwlEntity.this.moveTo(this.peckRot, this.peckRotTarget, 15.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = 10;
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> OwlEntity.this.m_9236_().m_46745_(OwlEntity.this.m_20183_())), (Object)new PeckPacket((Entity)this.owl, this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.peckRotTarget = 0.0f;
        }
    }

    public class HeadTiltAnimation
    extends AnimationBase {
        public float zTiltTarget;
        private float zTilt;
        public float xTiltTarget;
        private float xTilt;
        private OwlEntity owl;

        public float getzTilt() {
            return this.zTilt;
        }

        public float getxTilt() {
            return this.xTilt;
        }

        public HeadTiltAnimation(OwlEntity owl) {
            this.zTiltTarget = 0.0f;
            this.xTiltTarget = 0.0f;
            this.zTilt = 0.0f;
            this.xTilt = 0.0f;
            this.owl = owl;
            this.cooldownTimer = OwlEntity.this.f_19796_.m_188503_(100);
        }

        @Override
        public void activeTick() {
        }

        @Override
        public void postTick() {
            this.zTilt = OwlEntity.this.moveTo(this.zTilt, this.zTiltTarget, 15.0f);
            this.xTilt = OwlEntity.this.moveTo(this.xTilt, this.xTiltTarget, 15.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = OwlEntity.this.f_19796_.m_188503_(20) + 10;
                this.xTiltTarget = OwlEntity.this.f_19796_.m_188503_(100) - 50;
                this.zTiltTarget = OwlEntity.this.f_19796_.m_188503_(100) - 50;
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> OwlEntity.this.m_9236_().m_46745_(OwlEntity.this.m_20183_())), (Object)new HeadTiltPacket((Entity)this.owl, this.activeTimer, this.xTiltTarget, this.zTiltTarget));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.zTiltTarget = 0.0f;
            this.xTiltTarget = 0.0f;
            this.cooldownTimer = OwlEntity.this.f_19796_.m_188503_(80) + 20;
        }
    }

    public class HeadShakeAnimation
    extends AnimationBase {
        public float zTiltTarget;
        private float zTilt;
        private float zTiltLast;
        private OwlEntity owl;

        public float getzTilt() {
            return this.zTilt;
        }

        public float getzTiltLast() {
            return this.zTiltLast;
        }

        public HeadShakeAnimation(OwlEntity owl) {
            this.zTiltTarget = 0.0f;
            this.zTiltLast = this.zTilt = 0.0f;
            this.owl = owl;
            this.useCooldown = false;
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.m_9236_().f_46443_) {
                this.activeTimer = 15;
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> OwlEntity.this.m_9236_().m_46745_(OwlEntity.this.m_20183_())), (Object)new HeadShakePacket((Entity)this.owl, this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.zTiltTarget = 0.0f;
        }

        @Override
        public void preTick() {
            this.zTiltLast = this.zTilt;
        }

        @Override
        public void activeTick() {
            this.zTiltTarget = Mth.m_14031_((float)(this.owl.f_19797_ + this.owl.m_19879_() * 642)) * 100.0f;
        }

        @Override
        public void postTick() {
            this.zTilt = OwlEntity.this.moveTo(this.zTilt, this.zTiltTarget, 15.0f);
        }
    }

    public static class MessagingController {
        private OwlEntity owl;
        private GlobalPos startPos = null;
        private GlobalPos destinationPos = null;
        private Player destinationPlayer = null;
        private Map<ResourceKey<Level>, Set<ChunkPos>> lastCheckedChunks = new HashMap<ResourceKey<Level>, Set<ChunkPos>>();
        private Stage stage = Stage.DONE;
        private ItemStack messageStack = ItemStack.f_41583_;

        public MessagingController(OwlEntity owl) {
            this.owl = owl;
        }

        public boolean hasDelivery() {
            return !this.getMessageStack().m_41619_();
        }

        public boolean isDelivering() {
            return this.stage != Stage.DONE;
        }

        public ItemStack getMessageStack() {
            return this.messageStack;
        }

        public void setMessageStack(ItemStack messageStack) {
            this.messageStack = messageStack;
        }

        public void tick() {
            if (this.owl.currentTask == OwlTask.DELIVER_MESSAGE) {
                this.handleActiveState();
            } else {
                this.handleInactiveState();
            }
        }

        public Map<ResourceKey<Level>, Set<ChunkPos>> getLastCheckedChunks() {
            return this.lastCheckedChunks;
        }

        public void clearLastCheckedChunks() {
            this.lastCheckedChunks.clear();
        }

        private MessageText loadLines(MessageText pText) {
            for (int i = 0; i < 4; ++i) {
                Component component = pText.getMessage(i);
                pText = pText.setMessage(i, component);
            }
            return pText;
        }

        public boolean forceLoadChunks() {
            Level level;
            if (this.owl.m_21824_() && !this.owl.m_21224_() && (level = this.owl.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.hasDestination()) {
                    ServerLevel level2;
                    ServerLevel level3;
                    int dz;
                    int dx;
                    GlobalPos dest = this.getDestination();
                    GlobalPos start = this.startPos;
                    ChunkPos startChunk = new ChunkPos(start.m_122646_());
                    ChunkPos targetChunk = new ChunkPos(dest.m_122646_());
                    HashSet<ChunkPos> newChunks = new HashSet<ChunkPos>();
                    for (dx = -1; dx <= 1; ++dx) {
                        for (dz = -1; dz <= 1; ++dz) {
                            newChunks.add(new ChunkPos(startChunk.f_45578_ + dx, startChunk.f_45579_ + dz));
                        }
                    }
                    if (!newChunks.equals(this.lastCheckedChunks.get(start.m_122640_())) && (level3 = serverLevel.m_7654_().m_129880_(start.m_122640_())) != null) {
                        OwlLoadedChunksSavedData.get().addOwlLoading(level3, this.owl, newChunks);
                        if (this.lastCheckedChunks.containsKey(start.m_122640_())) {
                            this.lastCheckedChunks.get(start.m_122640_()).clear();
                        }
                        this.lastCheckedChunks.put((ResourceKey<Level>)start.m_122640_(), newChunks);
                    }
                    newChunks = new HashSet();
                    for (dx = -1; dx <= 1; ++dx) {
                        for (dz = -1; dz <= 1; ++dz) {
                            newChunks.add(new ChunkPos(targetChunk.f_45578_ + dx, targetChunk.f_45579_ + dz));
                        }
                    }
                    if (!newChunks.equals(this.lastCheckedChunks.get(dest.m_122640_())) && (level2 = serverLevel.m_7654_().m_129880_(dest.m_122640_())) != null) {
                        OwlLoadedChunksSavedData.get().addOwlLoading(level2, this.owl, newChunks);
                        if (this.lastCheckedChunks.containsKey(dest.m_122640_())) {
                            this.lastCheckedChunks.get(dest.m_122640_()).clear();
                        }
                        this.lastCheckedChunks.put((ResourceKey<Level>)dest.m_122640_(), newChunks);
                    }
                    return true;
                }
            }
            return false;
        }

        public void stopForceloadingChunks() {
            Level level = this.owl.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                OwlLoadedChunksSavedData.get(serverLevel).clearOwl(serverLevel, this.owl);
                this.owl.messagingController.clearLastCheckedChunks();
            }
        }

        private void handleActiveState() {
            if (!(this.owl.m_9236_().f_46443_ || this.hasDestination() || this.owl.currentTask != OwlTask.DELIVER_MESSAGE || this.stage != Stage.FIND_FLY_OFF_LOCATION && this.stage != Stage.FLY_OFF_AND_TELEPORT && this.stage != Stage.FLY_TO_DESTINATION)) {
                this.stage = Stage.FIND_FLY_BACK_LOCATION;
            }
        }

        private void handleInactiveState() {
            if (!this.owl.m_9236_().f_46443_) {
                if (this.hasDelivery() && !this.hasDestination()) {
                    this.owl.m_19983_(this.getMessageStack().m_41777_());
                    this.setMessageStack(ItemStack.f_41583_);
                } else if (this.hasDelivery()) {
                    this.owl.currentTask = OwlTask.DELIVER_MESSAGE;
                }
            }
        }

        public void write(CompoundTag nbt) {
            Optional tag;
            if (this.startPos != null) {
                tag = GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.startPos).result();
                tag.ifPresent(value -> nbt.m_128365_("startPos", value));
            }
            if (this.destinationPos != null) {
                tag = GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.destinationPos).result();
                tag.ifPresent(value -> nbt.m_128365_("destinationPos", value));
            }
            if (this.destinationPlayer != null) {
                nbt.m_128362_("destinationEntity", this.destinationPlayer.m_20148_());
            }
            if (this.stage != null) {
                nbt.m_128405_("stage", this.stage.ordinal());
            }
            nbt.m_128365_("messageStack", (Tag)this.messageStack.m_41739_(new CompoundTag()));
        }

        public void read(CompoundTag nbt) {
            Optional pos;
            if (nbt.m_128441_("startPos")) {
                pos = GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("startPos")).result();
                pos.ifPresent(globalPos -> {
                    this.startPos = globalPos;
                });
            }
            if (nbt.m_128441_("destinationPos")) {
                pos = GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("destinationPos")).result();
                pos.ifPresent(globalPos -> {
                    this.destinationPos = globalPos;
                });
            }
            if (nbt.m_128441_("destinationEntity")) {
                this.destinationPlayer = this.owl.m_9236_().m_46003_(nbt.m_128342_("destinationEntity"));
            }
            if (nbt.m_128441_("stage")) {
                this.stage = Stage.byId(nbt.m_128451_("stage"));
            }
            if (nbt.m_128441_("messageStack")) {
                this.messageStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("messageStack"));
            }
        }

        public void setDestination(Player entity) {
            this.destinationPlayer = entity;
        }

        public void setDestination(GlobalPos pos) {
            this.destinationPos = pos;
        }

        public void setStartPos(GlobalPos startPos) {
            this.startPos = startPos;
        }

        public boolean hasDestination() {
            return this.destinationPos != null || this.destinationPlayer != null;
        }

        public GlobalPos getDestination() {
            return this.destinationPlayer != null ? GlobalPos.m_122643_((ResourceKey)this.destinationPlayer.m_9236_().m_46472_(), (BlockPos)this.destinationPlayer.m_20183_()) : this.destinationPos;
        }

        public void start(GlobalPos startPos) {
            this.setStartPos(startPos);
            this.stage = Stage.byId(0);
        }

        public static enum Stage {
            FIND_FLY_OFF_LOCATION,
            FLY_OFF_AND_TELEPORT,
            FLY_TO_DESTINATION,
            FIND_FLY_BACK_LOCATION,
            FLY_BACK_AND_TELEPORT,
            RETURN_TO_START,
            DONE;


            public static Stage byId(int id) {
                return Stage.values()[id < 0 || id >= Stage.values().length ? 0 : id];
            }
        }
    }

    public static class Emotions {
        private int anger;
        private int distress;
        private int happiness;

        public Emotions(int anger, int distress, int happiness) {
            this.anger = anger;
            this.distress = distress;
            this.happiness = happiness;
        }

        public void setAnger(int anger) {
            this.anger = Mth.m_14045_((int)anger, (int)0, (int)100);
        }

        public void setDistress(int distress) {
            this.distress = Mth.m_14045_((int)distress, (int)0, (int)100);
        }

        public void setHappiness(int happiness) {
            this.happiness = Mth.m_14045_((int)happiness, (int)0, (int)100);
        }

        public int getAnger() {
            return this.anger;
        }

        public int getDistress() {
            return this.distress;
        }

        public int getHappiness() {
            return this.happiness;
        }

        public boolean isHappy() {
            return this.getAnger() < 30 && this.getHappiness() > 50;
        }
    }

    public class FloatGoal
    extends Goal {
        private final Mob mob;

        public FloatGoal(Mob p_25230_) {
            this.mob = p_25230_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
            p_25230_.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return this.mob.m_20069_() && this.mob.m_204036_(FluidTags.f_13131_) > this.mob.m_20204_() || this.mob.m_20077_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.mob.m_217043_().m_188501_() < 0.8f) {
                this.mob.m_21569_().m_24901_();
                Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)OwlEntity.this, (int)10, (int)7);
                if (randomPos == null) {
                    randomPos = LandRandomPos.m_148488_((PathfinderMob)OwlEntity.this, (int)10, (int)7);
                }
                BlockPos pos = randomPos != null ? new BlockPos((int)randomPos.f_82479_, (int)randomPos.f_82480_, (int)randomPos.f_82481_) : (OwlEntity.this.getPerchPos() != null ? OwlEntity.this.getPerchPos().m_7494_().m_7494_() : OwlEntity.this.m_20183_().m_7494_().m_7494_());
                if (!OwlEntity.this.m_21825_()) {
                    this.mob.m_5997_(0.0, 0.1, 0.0);
                }
                OwlEntity.this.flyOrWalkTo(pos.m_252807_());
                OwlEntity.this.f_21344_.m_26536_(OwlEntity.this.m_21573_().m_7864_(pos, 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
            }
        }
    }

    public class FlyBackToPerchGoal
    extends Goal {
        private final TamableAnimal mob;

        public FlyBackToPerchGoal(TamableAnimal p_25898_) {
            this.mob = p_25898_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            if (OwlEntity.this.getPerchPos() == null) {
                return false;
            }
            double topOffset = 0.0;
            if (OwlEntity.this.getPerchPos() != null) {
                topOffset = OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()).m_60734_().m_7952_(OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()), (BlockGetter)OwlEntity.this.m_9236_(), OwlEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
            }
            if (this.distanceTo(OwlEntity.this.getPerchPos().m_123341_(), OwlEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)OwlEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)OwlEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset) {
                return false;
            }
            if (OwlEntity.this.m_21825_()) {
                OwlEntity.this.m_21837_(false);
                OwlEntity.this.m_21839_(false);
            }
            return true;
        }

        public double distanceTo(double p_20276_, double p_20278_) {
            double d0 = OwlEntity.this.m_20185_() - p_20276_ - 0.5;
            double d1 = OwlEntity.this.m_20189_() - p_20278_ - 0.5;
            return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
        }

        public boolean m_8036_() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.m_21825_()) {
                if (OwlEntity.this.getPerchPos() != null) {
                    if (OwlEntity.this.getPerchPos().m_203198_(OwlEntity.this.m_20182_().f_82479_, OwlEntity.this.m_20182_().f_82480_, OwlEntity.this.m_20182_().f_82481_) < 1.0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!this.mob.m_21824_()) {
                return false;
            }
            if (this.mob.m_20072_()) {
                return false;
            }
            LivingEntity livingentity = this.mob.m_269323_();
            if (livingentity == null) {
                return true;
            }
            if (OwlEntity.this.getPerchPos() == null) {
                return false;
            }
            double topOffset = OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()).m_60734_().m_7952_(OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()), (BlockGetter)OwlEntity.this.m_9236_(), OwlEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
            if (this.distanceTo(OwlEntity.this.getPerchPos().m_123341_(), OwlEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)OwlEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)OwlEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset) {
                if (OwlEntity.this.m_21825_()) {
                    return false;
                }
            } else {
                if (OwlEntity.this.m_21825_()) {
                    OwlEntity.this.m_21837_(false);
                    OwlEntity.this.m_21839_(false);
                }
                return true;
            }
            return !(this.distanceTo(OwlEntity.this.getPerchPos().m_123341_(), OwlEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)OwlEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)OwlEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset);
        }

        public void m_8037_() {
            double topOffset = 0.0;
            if (OwlEntity.this.getPerchPos() != null) {
                topOffset = OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()).m_60734_().m_7952_(OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()), (BlockGetter)OwlEntity.this.m_9236_(), OwlEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
            }
            boolean isStuck = false;
            if (!(OwlEntity.this.getPerchPos() == null || this.distanceTo(OwlEntity.this.getPerchPos().m_123341_(), OwlEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)OwlEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)OwlEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset)) {
                OwlEntity.this.flyOrWalkTo(OwlEntity.this.getPerchPos().m_7494_().m_252807_());
                OwlEntity.this.f_21344_.m_26536_(this.mob.m_21573_().m_7864_(OwlEntity.this.getPerchPos().m_7494_(), -1), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
            }
            super.m_8037_();
        }

        public void m_8056_() {
            if (OwlEntity.this.getPerchPos() != null) {
                OwlEntity.this.flyOrWalkTo(OwlEntity.this.getPerchPos().m_7494_().m_252807_());
                OwlEntity.this.f_21344_.m_26536_(this.mob.m_21573_().m_7864_(OwlEntity.this.getPerchPos().m_7494_(), 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
            }
        }

        public void m_8041_() {
            OwlEntity.this.currentTask = OwlTask.NONE;
            if (OwlEntity.this.getPerchPos() != null) {
                double topOffset = OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()).m_60734_().m_7952_(OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()), (BlockGetter)OwlEntity.this.m_9236_(), OwlEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
                if (this.distanceTo(OwlEntity.this.getPerchPos().m_123341_(), OwlEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)OwlEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)OwlEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset) {
                    OwlEntity.this.m_21837_(true);
                }
            }
        }
    }

    public class SitWhenOrderedToGoal
    extends Goal {
        private final TamableAnimal mob;

        public SitWhenOrderedToGoal(TamableAnimal p_25898_) {
            this.mob = p_25898_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public double distanceTo(double p_20276_, double p_20278_) {
            double d0 = OwlEntity.this.m_20185_() - p_20276_ - 0.5;
            double d1 = OwlEntity.this.m_20189_() - p_20278_ - 0.5;
            return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
        }

        public boolean m_8045_() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.getPerchPos() != null) {
                double topOffset = OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()).m_60734_().m_7952_(OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()), (BlockGetter)OwlEntity.this.m_9236_(), OwlEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
                if (!(this.distanceTo(OwlEntity.this.getPerchPos().m_123341_(), OwlEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)OwlEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)OwlEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset)) {
                    OwlEntity.this.m_21839_(false);
                    return false;
                }
            }
            return this.mob.m_21827_();
        }

        public boolean m_8036_() {
            if (OwlEntity.this.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                List<FavoriteBlockQuirk> quirks = FavoriteBlockQuirk.fromController(OwlEntity.this.quirkController);
                boolean flag = false;
                for (FavoriteBlockQuirk quirk : quirks) {
                    if (!OwlEntity.this.m_20075_().m_60713_(quirk.getFavoriteBlock())) continue;
                    flag = true;
                }
                if (!flag) {
                    return false;
                }
            } else if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (!this.mob.m_21824_()) {
                return false;
            }
            if (this.mob.m_20072_()) {
                return false;
            }
            if (!this.mob.m_20096_()) {
                return false;
            }
            LivingEntity livingentity = this.mob.m_269323_();
            if (livingentity == null) {
                return true;
            }
            if (OwlEntity.this.getPerchPos() != null) {
                double topOffset = OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()).m_60734_().m_7952_(OwlEntity.this.m_9236_().m_8055_(OwlEntity.this.getPerchPos()), (BlockGetter)OwlEntity.this.m_9236_(), OwlEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
                if (!(this.distanceTo(OwlEntity.this.getPerchPos().m_123341_(), OwlEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)OwlEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)OwlEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset)) {
                    return false;
                }
            }
            return this.mob.m_20280_((Entity)livingentity) < 288.0 && livingentity.m_21188_() != null ? false : this.mob.m_21827_();
        }

        public void m_8037_() {
            super.m_8037_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26573_();
            this.mob.m_21837_(true);
        }

        public void m_8041_() {
            this.mob.m_21837_(false);
        }
    }

    public class DeliverMessageGoal
    extends Goal {
        private final OwlEntity owl;
        private Vec3 wantedPos = null;
        private static final int REFRESH_MAX = 5;
        private int refresh = 5;
        private int stuck = 0;
        private int stuckStageTotal = 0;
        private int checkOldPos = 0;
        private Vec3 oldPos = null;
        private Path stuckPath = null;
        private BlockPos stuckPathDest = null;

        public DeliverMessageGoal(OwlEntity owl) {
            this.owl = owl;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            if (!OwlEntity.this.currentTask.is(OwlTask.DELIVER_MESSAGE)) {
                return false;
            }
            return this.owl.messagingController.isDelivering();
        }

        public boolean m_8036_() {
            if (!OwlEntity.this.currentTask.is(OwlTask.DELIVER_MESSAGE)) {
                return false;
            }
            if (!this.owl.messagingController.isDelivering()) {
                return false;
            }
            return this.owl.m_21824_();
        }

        public void m_8037_() {
            MessagingController controller = this.owl.messagingController;
            ++this.refresh;
            ++this.stuck;
            ++this.stuckStageTotal;
            ++this.checkOldPos;
            if (this.checkOldPos > 40) {
                if (this.oldPos != null && this.oldPos.m_82554_(this.owl.m_20182_()) < 1.0) {
                    this.stuck = 200;
                }
                this.oldPos = this.owl.m_20182_();
                this.checkOldPos = 0;
            }
            this.owl.m_21837_(false);
            if (this.stuckStageTotal >= 400) {
                switch (controller.stage) {
                    case FIND_FLY_OFF_LOCATION: 
                    case FLY_OFF_AND_TELEPORT: 
                    case FLY_TO_DESTINATION: {
                        if (controller.getDestination() == null) break;
                        this.wantedPos = controller.getDestination().m_122646_().m_252807_();
                        controller.stage = MessagingController.Stage.FLY_TO_DESTINATION;
                        break;
                    }
                    case FIND_FLY_BACK_LOCATION: 
                    case FLY_BACK_AND_TELEPORT: 
                    case RETURN_TO_START: {
                        if (controller.startPos == null) break;
                        this.wantedPos = controller.startPos.m_122646_().m_252807_();
                        controller.stage = MessagingController.Stage.RETURN_TO_START;
                    }
                }
                Vec3 oldPos = this.owl.m_20182_();
                OwlEntity.this.m_6021_(this.wantedPos.m_7096_(), this.wantedPos.m_7098_(), this.wantedPos.m_7094_());
                PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint(this.owl.m_20182_().f_82479_, this.owl.m_20182_().f_82480_, this.owl.m_20182_().f_82481_, 500.0, this.owl.m_9236_().m_46472_());
                HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.m_9236_().m_46472_(), this.owl.m_20182_(), this.owl.getVariant()));
                PacketDistributor.TargetPoint point2 = new PacketDistributor.TargetPoint(oldPos.f_82479_, oldPos.f_82480_, oldPos.f_82481_, 500.0, this.owl.m_9236_().m_46472_());
                HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point2), (Object)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.m_9236_().m_46472_(), oldPos, this.owl.getVariant()));
                this.stuckStageTotal = 0;
                this.stuck = 0;
                this.stuckPath = null;
            } else if (this.stuck >= 160 || this.stuckPath != null) {
                if (this.stuckPath == null) {
                    Path path;
                    Vec3 vec3 = this.owl.m_20252_(0.0f);
                    Vec3 vec = DeliverMessageGoal.getPos((PathfinderMob)this.owl, 7, 2, 1, vec3.f_82479_, vec3.f_82481_, 1.5707963705062866);
                    OwlEntity.this.switchNavigator(true, true);
                    if (vec != null && (path = this.owl.m_21573_().m_7864_(BlockPos.m_274446_((Position)vec), 0)) != null && path.m_77403_()) {
                        this.stuckPath = path;
                        this.stuckPathDest = BlockPos.m_274446_((Position)vec);
                        this.owl.m_21573_().m_26536_(this.stuckPath, 2.0);
                    }
                } else {
                    this.owl.m_21573_().m_26536_(this.stuckPath, 2.0);
                    if (this.owl.m_20275_(this.stuckPathDest.m_123341_(), this.stuckPathDest.m_123342_(), this.stuckPathDest.m_123343_()) < 3.0) {
                        this.stuckPath = null;
                        this.stuckPathDest = null;
                        this.stuck = 0;
                    }
                }
            } else {
                block4 : switch (controller.stage) {
                    case FIND_FLY_OFF_LOCATION: {
                        for (int i = 0; i < 10; ++i) {
                            Vec3 vec3 = this.owl.m_20252_(0.0f);
                            Vec3 vec = DeliverMessageGoal.getPos((PathfinderMob)this.owl, 14, 4, 6, vec3.f_82479_, vec3.f_82481_, 1.5707963705062866);
                            if (vec == null || !(vec.m_82554_(this.owl.m_20182_()) > 8.0)) continue;
                            OwlEntity.this.switchNavigator(true, true);
                            Path path = this.owl.m_21573_().m_7864_(BlockPos.m_274446_((Position)vec), 0);
                            if (path == null || !path.m_77403_()) continue;
                            this.wantedPos = vec;
                            if (!controller.forceLoadChunks()) continue;
                            controller.stage = MessagingController.Stage.FLY_OFF_AND_TELEPORT;
                            this.refresh = 5;
                            this.stuck = 0;
                            this.stuckStageTotal = 0;
                            break block4;
                        }
                        break;
                    }
                    case FLY_OFF_AND_TELEPORT: {
                        if (!controller.hasDestination()) break;
                        if (this.wantedPos == null) {
                            controller.stage = MessagingController.Stage.FIND_FLY_OFF_LOCATION;
                            break;
                        }
                        BlockPos pos = controller.getDestination().m_122646_();
                        Path path = this.owl.m_21573_().m_7864_(pos, 0);
                        double dist = this.owl.m_20238_(Vec3.m_82539_((Vec3i)pos));
                        if (path != null && path.m_77407_() < 2.0f && dist < 1.0) {
                            controller.stage = MessagingController.Stage.FLY_TO_DESTINATION;
                            break;
                        }
                        path = this.owl.m_21573_().m_7864_(BlockPos.m_274446_((Position)this.wantedPos), 0);
                        if (this.refresh > 5) {
                            this.owl.m_21573_().m_26536_(path, 2.0);
                            this.refresh = 0;
                        }
                        if (!controller.forceLoadChunks() || !(OwlEntity.this.m_20275_(this.wantedPos.f_82479_, this.wantedPos.f_82480_, this.wantedPos.f_82481_) < 4.0)) break;
                        Vec3 oldPos = new Vec3(this.owl.m_20182_().m_252839_());
                        if (!OwlEntity.this.teleportToDest((ResourceKey<Level>)controller.getDestination().m_122640_(), pos)) break;
                        ServerLevel dimChange = this.owl.m_20194_().m_129880_(controller.getDestination().m_122640_());
                        if (dimChange != null && !dimChange.equals(this.owl.m_9236_())) {
                            this.owl.changeDimension(dimChange, new ITeleporter(){

                                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                                    return repositionEntity.apply(false);
                                }
                            });
                        }
                        Vec3 newPos = new Vec3(this.owl.m_20182_().m_252839_());
                        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint(oldPos.f_82479_, oldPos.f_82480_, oldPos.f_82481_, 500.0, controller.startPos.m_122640_());
                        HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new OwlTeleportParticlePacket((ResourceKey<Level>)controller.startPos.m_122640_(), oldPos, this.owl.getVariant()));
                        PacketDistributor.TargetPoint point2 = new PacketDistributor.TargetPoint(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, 500.0, controller.getDestination().m_122640_());
                        HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point2), (Object)new OwlTeleportParticlePacket((ResourceKey<Level>)controller.getDestination().m_122640_(), newPos, this.owl.getVariant()));
                        this.owl.hootAnimation.start();
                        controller.stage = MessagingController.Stage.FLY_TO_DESTINATION;
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        break;
                    }
                    case FLY_TO_DESTINATION: {
                        if (!controller.hasDestination()) break;
                        BlockPos pos = controller.getDestination().m_122646_();
                        if (this.refresh > 5) {
                            Path path = this.owl.m_21573_().m_7864_(pos, 0);
                            this.owl.m_21573_().m_26536_(path, 2.0);
                            this.refresh = 0;
                        }
                        if (!controller.forceLoadChunks() || !(OwlEntity.this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) < 3.0)) break;
                        controller.stage = MessagingController.Stage.FIND_FLY_BACK_LOCATION;
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        Map<GlobalPos, OwlCourierDepotData> depots = OwlCourierDepotSavedData.get().getDepots();
                        if (controller.destinationPos != null) {
                            if (this.owl.messagingController.messageStack.m_41619_() || !depots.containsKey(controller.getDestination())) break;
                            for (int i = 0; i < depots.get((Object)controller.getDestination()).items.size(); ++i) {
                                if (!((ItemStack)depots.get((Object)controller.getDestination()).items.get(i)).m_41619_()) continue;
                                depots.get((Object)controller.getDestination()).items.set(i, (Object)this.owl.messagingController.messageStack.m_41777_());
                                this.owl.messagingController.messageStack = ItemStack.f_41583_;
                                OwlCourierDepotSavedData.get().m_77762_();
                                OwlCourierDepotSavedData.get().syncInvToClient(controller.getDestination());
                                this.owl.sync();
                                this.owl.peck();
                                break block4;
                            }
                            break;
                        }
                        if (controller.destinationPlayer == null || ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(controller.destinationPlayer.m_20148_()) == null || !controller.destinationPlayer.m_6084_() || this.owl.messagingController.messageStack.m_41619_()) break;
                        controller.destinationPlayer.m_150109_().m_150079_(this.owl.messagingController.messageStack.m_41777_());
                        this.owl.messagingController.messageStack = ItemStack.f_41583_;
                        this.owl.sync();
                        this.owl.peck();
                        break;
                    }
                    case FIND_FLY_BACK_LOCATION: {
                        for (int i = 0; i < 10; ++i) {
                            Vec3 vec3 = this.owl.m_20252_(0.0f);
                            Vec3 vec = DeliverMessageGoal.getPos((PathfinderMob)this.owl, 14, 4, 6, vec3.f_82479_, vec3.f_82481_, 1.5707963705062866);
                            if (vec == null || !(vec.m_82554_(this.owl.m_20182_()) > 8.0)) continue;
                            OwlEntity.this.switchNavigator(true, true);
                            Path path = this.owl.m_21573_().m_7864_(BlockPos.m_274446_((Position)vec), 0);
                            if (path == null || !path.m_77403_()) continue;
                            this.wantedPos = vec;
                            controller.stage = MessagingController.Stage.FLY_BACK_AND_TELEPORT;
                            this.refresh = 5;
                            break block4;
                        }
                        break;
                    }
                    case FLY_BACK_AND_TELEPORT: {
                        if (controller.startPos == null) break;
                        Path path = this.owl.m_21573_().m_7864_(controller.startPos.m_122646_(), 0);
                        if (path != null && path.m_77407_() < 2.0f && this.owl.m_20238_(Vec3.m_82539_((Vec3i)controller.startPos.m_122646_())) < 4.0) {
                            controller.stage = MessagingController.Stage.RETURN_TO_START;
                            break;
                        }
                        if (this.wantedPos == null) {
                            controller.stage = MessagingController.Stage.FIND_FLY_BACK_LOCATION;
                            break;
                        }
                        Path path2 = this.owl.m_21573_().m_7864_(BlockPos.m_274446_((Position)this.wantedPos), 0);
                        if (this.refresh > 5) {
                            this.owl.m_21573_().m_26536_(path2, 3.0);
                            this.refresh = 0;
                        }
                        if (!(OwlEntity.this.m_20275_(this.wantedPos.f_82479_, this.wantedPos.f_82480_, this.wantedPos.f_82481_) < 2.0)) break;
                        BlockPos pos = controller.startPos.m_122646_();
                        Vec3 oldPos = new Vec3(this.owl.m_20182_().m_252839_());
                        ServerLevel dimChange = this.owl.m_20194_().m_129880_(controller.startPos.m_122640_());
                        ResourceKey dim1 = controller.startPos.m_122640_();
                        ResourceKey dim2 = OwlEntity.this.m_9236_().m_46472_();
                        if (!OwlEntity.this.teleportToDest((ResourceKey<Level>)controller.startPos.m_122640_(), pos)) break;
                        Vec3 newPos = new Vec3(this.owl.m_20182_().m_252839_());
                        if (dimChange != null && !dimChange.equals(this.owl.m_9236_())) {
                            this.owl.changeDimension(dimChange, new ITeleporter(){

                                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                                    return repositionEntity.apply(false);
                                }
                            });
                        }
                        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, 500.0, dim1);
                        HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new OwlTeleportParticlePacket((ResourceKey<Level>)dim1, newPos, this.owl.getVariant()));
                        PacketDistributor.TargetPoint point2 = new PacketDistributor.TargetPoint(oldPos.f_82479_, oldPos.f_82480_, oldPos.f_82481_, 500.0, dim2);
                        HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point2), (Object)new OwlTeleportParticlePacket((ResourceKey<Level>)dim2, oldPos, this.owl.getVariant()));
                        controller.stage = MessagingController.Stage.RETURN_TO_START;
                        this.wantedPos = controller.startPos.m_122646_().m_252807_();
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        this.owl.hootAnimation.start();
                        break;
                    }
                    case RETURN_TO_START: {
                        if (controller.startPos == null) {
                            this.end();
                            break;
                        }
                        BlockPos pos = controller.startPos.m_122646_();
                        Path path = this.owl.m_21573_().m_7864_(pos, 0);
                        if (this.refresh > 5 && path != null) {
                            this.owl.m_21573_().m_26536_(path, 2.0);
                            this.refresh = 0;
                        }
                        if (!(OwlEntity.this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) < 1.5)) break;
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        controller.stage = MessagingController.Stage.DONE;
                        if (!controller.messageStack.m_41619_()) {
                            LivingEntity livingEntity;
                            ItemEntity item = this.owl.m_5552_(controller.getMessageStack().m_41777_(), 0.0f);
                            if (item != null) {
                                item.m_149678_();
                            }
                            if ((livingEntity = this.owl.m_269323_()) instanceof ServerPlayer) {
                                ServerPlayer owner = (ServerPlayer)livingEntity;
                                owner.m_213846_((Component)Component.m_237110_((String)"message.hexerei.owl_could_not_deliver", (Object[])new Object[]{this.owl.m_7755_().getString(), controller.getMessageStack().m_41786_().getString()}));
                            }
                            controller.setMessageStack(ItemStack.f_41583_);
                            this.owl.sync();
                            this.owl.peck();
                        }
                        this.end();
                    }
                }
            }
            super.m_8037_();
        }

        public void end() {
            MessagingController controller = this.owl.messagingController;
            Level level = this.owl.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (controller.stage == MessagingController.Stage.DONE) {
                    OwlLoadedChunksSavedData.get(serverLevel).clearOwl(serverLevel, this.owl);
                }
            }
            controller.startPos = null;
            controller.destinationPlayer = null;
            controller.destinationPos = null;
            controller.stage = MessagingController.Stage.FIND_FLY_OFF_LOCATION;
            this.owl.currentTask = OwlTask.NONE;
            controller.clearLastCheckedChunks();
            this.m_8041_();
        }

        public void m_8056_() {
            this.owl.m_21837_(false);
        }

        public void m_8041_() {
        }

        @javax.annotation.Nullable
        public static Vec3 getPos(PathfinderMob pMob, int pMaxDistance, int pYRange, int pY, double pX, double pZ, double pAmplifier) {
            boolean flag = GoalUtils.m_148442_((PathfinderMob)pMob, (int)pMaxDistance);
            return RandomPos.m_148542_((PathfinderMob)pMob, () -> {
                BlockPos blockpos = DeliverMessageGoal.generateRandomPos(pMob, pMaxDistance, pYRange, pY, pX, pZ, pAmplifier, flag);
                return blockpos != null && pMob.m_9236_().m_6425_(blockpos).m_76178_() ? blockpos : null;
            });
        }

        @javax.annotation.Nullable
        public static BlockPos generateRandomPos(PathfinderMob pMob, int pMaxDistance, int pYRange, int pY, double pX, double pZ, double pAmplifier, boolean pShortCircuit) {
            BlockPos blockpos = RandomPos.m_217855_((RandomSource)pMob.m_217043_(), (int)pMaxDistance, (int)pYRange, (int)pY, (double)pX, (double)pZ, (double)pAmplifier);
            if (blockpos == null) {
                return null;
            }
            BlockPos blockpos1 = RandomPos.m_217863_((PathfinderMob)pMob, (int)pMaxDistance, (RandomSource)pMob.m_217043_(), (BlockPos)blockpos);
            if (!GoalUtils.m_148451_((BlockPos)blockpos1, (PathfinderMob)pMob) && !GoalUtils.m_148454_((boolean)pShortCircuit, (PathfinderMob)pMob, (BlockPos)blockpos1)) {
                return GoalUtils.m_148458_((PathfinderMob)pMob, (BlockPos)(blockpos1 = RandomPos.m_148545_((BlockPos)blockpos1, (int)pMob.m_9236_().m_151558_(), p_148376_ -> GoalUtils.m_148461_((PathfinderMob)pMob, (BlockPos)p_148376_)))) ? null : blockpos1;
            }
            return null;
        }
    }

    public class OwlFavoriteBlockGoal
    extends MoveToBlockGoal {
        private final OwlEntity owl;
        private int ticks;
        private int sinceLastOnBlock;
        private int cooldownTicks;
        private boolean useCooldown;

        public OwlFavoriteBlockGoal(OwlEntity pOwl, double pSpeedModifier) {
            super((PathfinderMob)pOwl, pSpeedModifier, 12, 3);
            this.cooldownTicks = 0;
            this.useCooldown = false;
            this.owl = pOwl;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public double m_8052_() {
            return 0.25;
        }

        public boolean m_8036_() {
            if (this.useCooldown && this.cooldownTicks < 500) {
                ++this.cooldownTicks;
                if (this.cooldownTicks >= 500) {
                    this.cooldownTicks = 0;
                    this.useCooldown = false;
                }
                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                    this.owl.currentTask = OwlTask.NONE;
                }
                return false;
            }
            if (this.sinceLastOnBlock < 20) {
                ++this.sinceLastOnBlock;
                return false;
            }
            if (this.owl.m_21824_() && this.owl.currentTask.isNoneOr(OwlTask.GO_TO_FAVORITE_BLOCK) && FavoriteBlockQuirk.fromController(this.owl.quirkController).size() > 0) {
                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                    ++this.ticks;
                    if (this.ticks > 500 || this.owl.m_21827_() || this.owl.m_21825_()) {
                        this.owl.currentTask = OwlTask.NONE;
                        this.owl.m_21573_().m_26573_();
                        return false;
                    }
                    List<FavoriteBlockQuirk> quirks = FavoriteBlockQuirk.fromController(this.owl.quirkController);
                    for (FavoriteBlockQuirk quirk : quirks) {
                        if (!this.owl.m_20075_().m_60713_(quirk.getFavoriteBlock())) continue;
                        ++this.ticks;
                        if (this.ticks > 100) {
                            this.owl.currentTask = OwlTask.NONE;
                            this.owl.m_21573_().m_26573_();
                            this.useCooldown = true;
                        } else {
                            Player owner;
                            LivingEntity livingEntity = this.owl.m_269323_();
                            if (livingEntity instanceof Player && this.owl.m_20280_((Entity)(owner = (Player)livingEntity)) >= 144.0) {
                                if (!this.owl.m_21827_()) {
                                    this.owl.teleportToOwner();
                                }
                                this.owl.currentTask = OwlTask.NONE;
                                this.owl.m_21573_().m_26573_();
                                this.useCooldown = true;
                            }
                        }
                        return false;
                    }
                }
                if (this.owl.m_21827_() || this.owl.m_21825_()) {
                    return false;
                }
                return super.m_8036_();
            }
            return false;
        }

        public boolean m_8045_() {
            boolean canContinue = super.m_8045_();
            return !this.useCooldown && canContinue && !this.owl.m_21827_();
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        public void m_8037_() {
            Player owner;
            BlockPos blockpos = this.m_6669_();
            float dist = (float)blockpos.m_203193_((Position)this.f_25598_.m_20182_().m_82520_(0.0, 0.5, 0.0));
            if (!((double)dist < this.m_8052_())) {
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.owl.walkToIfNotFlyTo(new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5));
                    this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
                } else if (dist < 3.0f) {
                    this.f_25598_.m_21573_().m_26573_();
                    this.f_25598_.m_21566_().m_6849_((double)((float)blockpos.m_123341_() + 0.5f), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() + 0.5f), this.f_25599_ * 1.25);
                }
            } else {
                if (this.ticks < 100) {
                    ++this.ticks;
                } else {
                    this.owl.currentTask = OwlTask.NONE;
                    this.ticks = 0;
                    this.useCooldown = true;
                    this.m_8041_();
                }
                this.sinceLastOnBlock = 0;
                --this.f_25601_;
            }
            LivingEntity livingEntity = this.owl.m_269323_();
            if (livingEntity instanceof Player && this.owl.m_20280_((Entity)(owner = (Player)livingEntity)) >= 144.0) {
                this.owl.teleportToOwner();
                this.owl.currentTask = OwlTask.NONE;
                this.owl.m_21573_().m_26573_();
                this.useCooldown = true;
                this.m_8041_();
            }
        }

        protected int m_6099_(PathfinderMob pCreature) {
            return OwlFavoriteBlockGoal.m_186073_((int)(200 + pCreature.m_217043_().m_188503_(200)));
        }

        public boolean posEqual(BlockPos pos1, BlockPos pos2) {
            if (pos1 == null || pos2 == null) {
                return false;
            }
            return pos1.m_123341_() == pos2.m_123341_() && pos1.m_123342_() == pos2.m_123342_() && pos1.m_123343_() == pos2.m_123343_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            if (pLevel.m_46859_(pPos.m_7494_())) {
                BlockState blockstate = pLevel.m_8055_(pPos);
                List<FavoriteBlockQuirk> quirks = FavoriteBlockQuirk.fromController(this.owl.quirkController);
                for (FavoriteBlockQuirk quirk : quirks) {
                    boolean collisionBelow;
                    if (!blockstate.m_60713_(quirk.getFavoriteBlock())) continue;
                    boolean collision = !quirk.getFavoriteBlock().m_5939_(quirk.getFavoriteBlock().m_49966_(), (BlockGetter)pLevel, BlockPos.f_121853_, CollisionContext.m_82749_()).m_83281_();
                    boolean bl = collisionBelow = !pLevel.m_8055_(pPos.m_7495_()).m_60734_().m_5939_(quirk.getFavoriteBlock().m_49966_(), (BlockGetter)pLevel, BlockPos.f_121853_, CollisionContext.m_82749_()).m_83281_();
                    if (collision || collisionBelow) {
                        if (this.ticks > 100) {
                            if (this.posEqual(this.owl.m_216986_(0.5001f), pPos)) {
                                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                                    this.owl.currentTask = OwlTask.NONE;
                                }
                                return false;
                            }
                            if (this.posEqual(this.owl.m_20097_(), pPos)) {
                                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                                    this.owl.currentTask = OwlTask.NONE;
                                }
                                return false;
                            }
                        }
                    } else {
                        return false;
                    }
                    this.owl.currentTask = OwlTask.GO_TO_FAVORITE_BLOCK;
                    return true;
                }
            }
            return false;
        }
    }

    public class FollowOwnerGoal
    extends Goal {
        private final OwlEntity owl;
        private LivingEntity owner;
        private final LevelReader level;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public FollowOwnerGoal(OwlEntity owl, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
            this.owl = owl;
            this.level = owl.m_9236_();
            this.speedModifier = speedModifier;
            this.navigation = owl.m_21573_();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.canFly = canFly;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(owl.m_21573_() instanceof GroundPathNavigation) && !(owl.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            if (!this.owl.currentTask.isNone()) {
                return false;
            }
            LivingEntity livingentity = this.owl.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.owl.m_21827_() || OwlEntity.this.m_21825_()) {
                return false;
            }
            if (this.owl.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (!this.owl.currentTask.isNone()) {
                return false;
            }
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.owl.m_21827_() || OwlEntity.this.m_21825_()) {
                return false;
            }
            return !(this.owl.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.owl.m_21439_(BlockPathTypes.WATER);
            this.owl.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            OwlEntity.this.currentTask = OwlTask.NONE;
            this.owner = null;
            this.navigation.m_26573_();
            this.owl.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            this.owl.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.owl.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(4);
                if (!this.owl.m_21523_() && !this.owl.m_20159_()) {
                    if (this.owl.m_20280_((Entity)this.owner) >= 144.0) {
                        if (this.teleportToOwner()) {
                            OwlEntity.this.m_21573_().m_26573_();
                            OwlEntity.this.flyOrWalkTo(this.owner.m_20182_());
                            OwlEntity.this.m_21573_().m_26519_(this.owner.m_20182_().f_82479_, this.owner.m_20182_().f_82480_, this.owner.m_20182_().f_82481_, this.speedModifier);
                        }
                    } else {
                        OwlEntity.this.flyOrWalkTo(this.owner.m_20182_());
                        OwlEntity.this.m_21573_().m_26519_(this.owner.m_20182_().f_82479_, this.owner.m_20182_().f_82480_, this.owner.m_20182_().f_82481_, this.speedModifier);
                    }
                }
            }
        }

        private boolean teleportToOwner() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return true;
            }
            return false;
        }

        private boolean maybeTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            OwlEntity.this.flyOrWalkTo(new Vec3((double)x + 0.5, (double)y, (double)z + 0.5));
            this.owl.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.owl.m_146908_(), this.owl.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (pos.m_123342_() <= -64) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(pos.m_7495_());
            if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pos.m_121996_((Vec3i)this.owl.m_20183_());
            return this.level.m_45756_((Entity)this.owl, this.owl.m_20191_().m_82338_(blockpos));
        }

        private int randomIntInclusive(int p_25301_, int p_25302_) {
            return this.owl.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
        }
    }

    public class BreedGoal
    extends Goal {
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();
        protected final Animal animal;
        private final Class<? extends Animal> partnerClass;
        protected final Level level;
        @javax.annotation.Nullable
        protected Animal partner;
        private int loveTime;
        private final double speedModifier;

        public BreedGoal(Animal p_25122_, double p_25123_) {
            this(p_25122_, p_25123_, p_25122_.getClass());
        }

        public BreedGoal(Animal p_25125_, double p_25126_, Class<? extends Animal> p_25127_) {
            this.animal = p_25125_;
            this.level = p_25125_.m_9236_();
            this.partnerClass = p_25127_;
            this.speedModifier = p_25126_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (OwlEntity.this.currentTask.is(OwlTask.BREEDING)) {
                this.partner = this.getFreePartner();
                return this.partner != null;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.partner != null && this.partner.m_6084_() && this.partner.m_27593_() && this.loveTime < 120;
        }

        public void m_8056_() {
            if (OwlEntity.this.m_21825_()) {
                OwlEntity.this.m_21837_(false);
                OwlEntity.this.m_21839_(false);
            }
            super.m_8056_();
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            if (this.partner != null) {
                this.animal.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.animal.m_8132_());
                OwlEntity.this.walkToIfNotFlyTo(this.partner.m_20182_());
                this.animal.m_21573_().m_5624_((Entity)this.partner, OwlEntity.this.isFlyingNav() ? 1.25 * this.speedModifier : 0.75 * this.speedModifier);
                ++this.loveTime;
                if (this.animal.m_20280_((Entity)this.partner) < 4.0 && OwlEntity.this.breedGiftGivenByPlayer) {
                    if (!((OwlEntity)this.partner).m_21827_()) {
                        ((OwlEntity)this.partner).m_21839_(true);
                    }
                    if (!this.partner.m_21563_().m_186069_()) {
                        this.partner.m_21563_().m_148051_((Entity)this.animal);
                    }
                    ++OwlEntity.this.waitToGiveTime;
                    if (OwlEntity.this.waitToGiveTime > 20 && OwlEntity.this.m_20096_() && OwlEntity.this.itemHandler.getStackInSlot(1).m_150930_(Items.f_42697_)) {
                        ((OwlEntity)this.partner).m_21839_(false);
                        OwlEntity.this.waitToGiveTime = 0;
                        OwlEntity.this.breedGiftGivenByPlayer = false;
                        OwlEntity.this.peck();
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.level.m_46745_(OwlEntity.this.m_20183_())), (Object)new PeckPacket((Entity)OwlEntity.this));
                        ItemStack stack = ((OwlEntity)this.partner).itemHandler.getStackInSlot(1).m_41777_();
                        ItemStack stack2 = OwlEntity.this.itemHandler.getStackInSlot(1).m_41777_();
                        ((OwlEntity)this.partner).itemHandler.setStackInSlot(1, stack2);
                        OwlEntity.this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
                        ItemEntity itemEntity = new ItemEntity(this.partner.m_9236_(), this.partner.m_20182_().f_82479_, this.partner.m_20182_().f_82480_, this.partner.m_20182_().f_82481_, stack);
                        this.partner.m_9236_().m_7967_((Entity)itemEntity);
                        if (OwlEntity.this.breedGiftGivenByPlayerUUID != null && this.level.m_46003_(OwlEntity.this.breedGiftGivenByPlayerUUID) != null) {
                            ((OwlEntity)this.partner).breedGiftGivenByPlayerUUID = OwlEntity.this.breedGiftGivenByPlayerUUID;
                            ((OwlEntity)this.partner).breedGiftGivenByPartnerTimer = 20;
                        } else if (OwlEntity.this.m_269323_() instanceof Player) {
                            this.partner.m_27595_((Player)OwlEntity.this.m_269323_());
                        }
                    }
                }
                if (this.loveTime >= this.m_183277_(60) && this.animal.m_20280_((Entity)this.partner) < 9.0) {
                    this.breed();
                    OwlEntity.this.currentTask = OwlTask.NONE;
                    this.partner = null;
                    this.loveTime = 0;
                }
            }
        }

        public boolean canMateOwlBringGift(Animal animal) {
            if (animal.m_6162_()) {
                return false;
            }
            if (animal == OwlEntity.this) {
                return false;
            }
            if (animal.getClass() != OwlEntity.this.getClass()) {
                return false;
            }
            return OwlEntity.this.itemHandler.getStackInSlot(1).m_150930_(Items.f_42697_) && animal.m_146764_() == 0;
        }

        public boolean canMateOwlReceiveGift(Animal animal) {
            if (animal.m_6162_()) {
                return false;
            }
            if (animal == OwlEntity.this) {
                return false;
            }
            if (animal.getClass() != OwlEntity.this.getClass()) {
                return false;
            }
            return OwlEntity.this.m_27593_() && animal.m_27593_();
        }

        @javax.annotation.Nullable
        private Animal getFreePartner() {
            List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(16.0));
            double d0 = Double.MAX_VALUE;
            Animal animal = null;
            if (OwlEntity.this.breedGiftGivenByPlayer) {
                for (Animal animal1 : list) {
                    if (!this.canMateOwlBringGift(animal1) || !(this.animal.m_20280_((Entity)animal1) < d0)) continue;
                    animal = animal1;
                    d0 = this.animal.m_20280_((Entity)animal1);
                }
            } else {
                for (Animal animal1 : list) {
                    if (!this.canMateOwlReceiveGift(animal1) || !(this.animal.m_20280_((Entity)animal1) < d0)) continue;
                    animal = animal1;
                    d0 = this.animal.m_20280_((Entity)animal1);
                }
            }
            return animal;
        }

        protected void breed() {
            OwlEntity.this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
            this.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
        }

        public void spawnChildFromBreeding(ServerLevel p_27564_, Animal p_27565_) {
            AgeableMob ageablemob = OwlEntity.this.m_142606_(p_27564_, (AgeableMob)p_27565_);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)OwlEntity.this, (Mob)p_27565_, ageablemob);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            ageablemob = event.getChild();
            if (cancelled) {
                OwlEntity.this.m_146762_(6000);
                p_27565_.m_146762_(6000);
                OwlEntity.this.m_27594_();
                p_27565_.m_27594_();
                return;
            }
            if (ageablemob != null) {
                ServerPlayer serverplayer = OwlEntity.this.m_27592_();
                if (serverplayer == null && p_27565_.m_27592_() != null) {
                    serverplayer = p_27565_.m_27592_();
                }
                if (serverplayer != null) {
                    serverplayer.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)OwlEntity.this, p_27565_, ageablemob);
                }
                OwlEntity.this.m_146762_(6000);
                p_27565_.m_146762_(6000);
                OwlEntity.this.m_27594_();
                p_27565_.m_27594_();
                ageablemob.m_6863_(true);
                ageablemob.m_7678_(this.partner.m_20185_(), this.partner.m_20186_(), this.partner.m_20189_(), 0.0f, 0.0f);
                p_27564_.m_47205_((Entity)ageablemob);
                ((OwlEntity)ageablemob).m_21816_(OwlEntity.this.m_21805_());
                ((OwlEntity)ageablemob).m_7105_(true);
                ((OwlEntity)ageablemob).m_21839_(true);
                p_27564_.m_7605_((Entity)OwlEntity.this, (byte)18);
                if (p_27564_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    p_27564_.m_7967_((Entity)new ExperienceOrb((Level)p_27564_, OwlEntity.this.m_20185_(), OwlEntity.this.m_20186_(), OwlEntity.this.m_20189_(), OwlEntity.this.m_217043_().m_188503_(7) + 1));
                }
            }
        }
    }

    public class TemptGoal
    extends Goal {
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
        private final TargetingConditions targetingConditions;
        protected final OwlEntity owl;
        private final double speedModifier;
        private double px;
        private double py;
        private double pz;
        private double pRotX;
        private double pRotY;
        @javax.annotation.Nullable
        protected Player player;
        private int calmDown;
        private boolean isRunning;
        private final Ingredient items;
        private final boolean canScare;

        public TemptGoal(OwlEntity p_25939_, double p_25940_, Ingredient p_25941_, boolean p_25942_) {
            this.owl = p_25939_;
            this.speedModifier = p_25940_;
            this.items = p_25941_;
            this.canScare = p_25942_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
        }

        public boolean m_8036_() {
            if (this.owl.m_21825_() || this.owl.m_21827_()) {
                return false;
            }
            if (this.owl.currentTask.is(OwlTask.PICKUP_ITEM) || this.owl.currentTask.is(OwlTask.BREEDING)) {
                return false;
            }
            if (this.calmDown > 0) {
                --this.calmDown;
                return false;
            }
            this.player = this.owl.m_9236_().m_45946_(this.targetingConditions, (LivingEntity)this.owl);
            return this.player != null;
        }

        private boolean shouldFollow(LivingEntity player) {
            if (this.player != null && OwlEntity.this.m_21824_() && OwlEntity.this.m_21830_(player) && !OwlEntity.this.m_6162_() && OwlEntity.this.m_146764_() == 0) {
                return player.m_21205_().m_204117_(HexereiTags.Items.OWL_BREEDING_FOOD) || player.m_21206_().m_204117_(HexereiTags.Items.OWL_BREEDING_FOOD);
            }
            return player.m_21205_().m_204117_(HexereiTags.Items.OWL_TAMING_FOOD) || player.m_21206_().m_204117_(HexereiTags.Items.OWL_TAMING_FOOD);
        }

        public boolean m_8045_() {
            if (this.owl.m_21825_() || this.owl.m_21827_()) {
                return false;
            }
            if (this.canScare()) {
                if (this.owl.m_20280_((Entity)this.player) < 36.0) {
                    if (this.player.m_20275_(this.px, this.py, this.pz) > 0.010000000000000002) {
                        return false;
                    }
                    if (Math.abs((double)this.player.m_146909_() - this.pRotX) > 5.0 || Math.abs((double)this.player.m_146908_() - this.pRotY) > 5.0) {
                        return false;
                    }
                } else {
                    this.px = this.player.m_20185_();
                    this.py = this.player.m_20186_();
                    this.pz = this.player.m_20189_();
                }
                this.pRotX = this.player.m_146909_();
                this.pRotY = this.player.m_146908_();
            }
            return this.m_8036_();
        }

        protected boolean canScare() {
            return this.canScare;
        }

        public void m_8056_() {
            this.px = this.player.m_20185_();
            this.py = this.player.m_20186_();
            this.pz = this.player.m_20189_();
            this.isRunning = true;
        }

        public void m_8041_() {
            OwlEntity.this.currentTask = OwlTask.NONE;
            this.player = null;
            this.owl.m_21573_().m_26573_();
            this.calmDown = TemptGoal.m_186073_((int)100);
            this.isRunning = false;
            OwlEntity.this.setBrowPos(BrowPositioning.NORMAL);
        }

        public void m_8037_() {
            this.owl.m_21563_().m_24960_((Entity)this.player, (float)(this.owl.m_8085_() + 20), (float)this.owl.m_8132_());
            if (OwlEntity.this.m_21825_()) {
                return;
            }
            if (!OwlEntity.this.m_21824_()) {
                if (this.owl.m_20280_((Entity)this.player) < 14.25 && OwlEntity.this.f_19796_.m_188503_(20) == 0) {
                    OwlEntity.this.emotions.setDistress(OwlEntity.this.emotions.getDistress() + 5 + OwlEntity.this.f_19796_.m_188503_(5));
                    OwlEntity.this.emotionChanged();
                    OwlEntity.this.determineEmotionState();
                }
            } else if (this.owl.m_20280_((Entity)this.player) < 10.25 && OwlEntity.this.f_19796_.m_188503_(20) == 0) {
                OwlEntity.this.emotions.setDistress(OwlEntity.this.emotions.getDistress() + 5 + OwlEntity.this.f_19796_.m_188503_(5));
                OwlEntity.this.emotionChanged();
                OwlEntity.this.determineEmotionState();
            }
            if (this.owl.m_20280_((Entity)this.player) < 6.25) {
                this.owl.m_21573_().m_26573_();
            } else {
                if (OwlEntity.this.f_19796_.m_188503_(TemptGoal.m_186073_((int)2)) == 0) {
                    OwlEntity.this.walkToIfNotFlyTo(this.player.m_20182_());
                }
                this.owl.m_21573_().m_5624_((Entity)this.player, 1.25 * this.speedModifier);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    public class FollowParentGoal
    extends Goal {
        public static final int HORIZONTAL_SCAN_RANGE = 8;
        public static final int VERTICAL_SCAN_RANGE = 4;
        public static final int DONT_FOLLOW_IF_CLOSER_THAN = 3;
        private final Animal animal;
        @javax.annotation.Nullable
        private Animal parent;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowParentGoal(Animal p_25319_, double p_25320_) {
            this.animal = p_25319_;
            this.speedModifier = p_25320_;
        }

        public boolean m_8036_() {
            if (this.animal.m_146764_() >= 0) {
                return false;
            }
            if (OwlEntity.this.m_21827_() || OwlEntity.this.m_21825_()) {
                return false;
            }
            List list = this.animal.m_9236_().m_45976_(this.animal.getClass(), this.animal.m_20191_().m_82377_(8.0, 4.0, 8.0));
            Animal animal = null;
            double d0 = Double.MAX_VALUE;
            for (Animal animal1 : list) {
                double d1;
                if (animal1.m_146764_() < 0 || (d1 = this.animal.m_20280_((Entity)animal1)) > d0) continue;
                d0 = d1;
                animal = animal1;
            }
            if (animal == null) {
                return false;
            }
            if (d0 < 9.0) {
                return false;
            }
            this.parent = animal;
            return true;
        }

        public boolean m_8045_() {
            if (this.animal.m_146764_() >= 0) {
                return false;
            }
            if (!this.parent.m_6084_()) {
                return false;
            }
            if (OwlEntity.this.m_21827_() || OwlEntity.this.m_21825_()) {
                return false;
            }
            double d0 = this.animal.m_20280_((Entity)this.parent);
            return !(d0 < 9.0) && !(d0 > 256.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.parent = null;
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (this.parent != null) {
                    OwlEntity.this.walkToIfNotFlyTo(this.parent.m_20182_());
                }
                this.animal.m_21573_().m_5624_((Entity)this.parent, OwlEntity.this.isFlyingNav() ? 1.25 * this.speedModifier : 0.75 * this.speedModifier);
            }
        }
    }

    public class WaterAvoidingRandomFlyingGoal
    extends WaterAvoidingRandomStrollGoal {
        public WaterAvoidingRandomFlyingGoal(PathfinderMob p_25981_, double p_25982_) {
            super(p_25981_, p_25982_);
        }

        @Override
        public void m_8056_() {
            OwlEntity.this.switchNavigator(true);
            this.f_25725_.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, OwlEntity.this.isFlyingNav() ? 1.25 * this.f_25729_ : 0.75 * this.f_25729_);
        }

        @Override
        public boolean m_8036_() {
            if (OwlEntity.this.m_21824_()) {
                return false;
            }
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.m_21825_()) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            if (OwlEntity.this.m_21825_()) {
                return false;
            }
            return super.m_8045_();
        }

        @Override
        @javax.annotation.Nullable
        protected Vec3 m_7037_() {
            Vec3 vec3 = this.f_25725_.m_20252_(0.0f);
            int i = 8;
            Vec3 vec31 = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec31 != null ? vec31 : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.f_25725_, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }

    public class WaterAvoidingRandomStrollGoal
    extends RandomStrollGoal {
        public static final float PROBABILITY = 0.001f;
        protected final float probability;

        public WaterAvoidingRandomStrollGoal(PathfinderMob p_25987_, double p_25988_) {
            this(p_25987_, p_25988_, 0.001f);
        }

        public WaterAvoidingRandomStrollGoal(PathfinderMob p_25990_, double p_25991_, float p_25992_) {
            super(p_25990_, p_25991_);
            this.probability = p_25992_;
        }

        public void m_8056_() {
            OwlEntity.this.walkToIfNotFlyTo(new Vec3(this.f_25726_, this.f_25727_, this.f_25728_));
            this.f_25725_.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, OwlEntity.this.isFlyingNav() ? 1.25 * this.f_25729_ : 0.75 * this.f_25729_);
        }

        public boolean m_8036_() {
            if (OwlEntity.this.m_21824_()) {
                return false;
            }
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.m_21825_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (OwlEntity.this.m_21825_()) {
                return false;
            }
            return super.m_8045_();
        }

        @javax.annotation.Nullable
        protected Vec3 m_7037_() {
            if (this.f_25725_.m_20072_()) {
                Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)7);
                return vec3 == null ? super.m_7037_() : vec3;
            }
            return this.f_25725_.m_217043_().m_188501_() >= this.probability ? LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7) : super.m_7037_();
        }
    }

    public class OwlLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public OwlLookAtPlayerGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance) {
            super(pMob, pLookAtType, pLookDistance);
        }

        public boolean m_8036_() {
            if (OwlEntity.this.currentTask.is(OwlTask.BREEDING) || OwlEntity.this.breedGiftGivenByPartnerTimer > 0) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (OwlEntity.this.currentTask.is(OwlTask.BREEDING) || OwlEntity.this.breedGiftGivenByPartnerTimer > 0) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public class OwlGatherItems<T extends ItemEntity>
    extends TargetGoal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<? super ItemEntity> targetEntitySelector;
        protected int executionChance;
        protected boolean mustUpdate;
        protected ItemEntity targetEntity;
        protected ITargetsDroppedItems hunter;
        private int tickThreshold;
        private int walkCooldown;
        protected int tryTicks;

        public OwlGatherItems(PathfinderMob creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            this(creature, 1, checkSight, onlyNearby, null, tickThreshold);
        }

        public OwlGatherItems(PathfinderMob creature, int chance, boolean checkSight, @javax.annotation.Nullable boolean onlyNearby, Predicate<? super T> targetSelector, int ticksExisted) {
            super((Mob)creature, checkSight, onlyNearby);
            this.walkCooldown = 0;
            this.tryTicks = 0;
            this.executionChance = chance;
            this.tickThreshold = ticksExisted;
            this.hunter = (ITargetsDroppedItems)creature;
            this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
            this.targetEntitySelector = item -> {
                ItemStack stack = item.m_32055_();
                return !stack.m_41619_() && this.hunter.canTargetItem(stack) && item.f_19797_ > this.tickThreshold;
            };
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            List list;
            if (!OwlEntity.this.currentTask.isNoneOr(OwlTask.PICKUP_ITEM)) {
                return false;
            }
            if (OwlEntity.this.m_20159_() || OwlEntity.this.m_20160_() && OwlEntity.this.m_6688_() != null) {
                return false;
            }
            if (!OwlEntity.this.itemHandler.getStackInSlot(1).m_41619_()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = OwlEntity.this.m_9236_().m_46467_() % 10L;
                if (this.f_26135_.m_21216_() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (this.f_26135_.m_217043_().m_188503_(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = this.f_26135_.m_9236_().m_6443_(ItemEntity.class, this.getTargetableArea(OwlEntity.this.interactionRange + 1), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            if (OwlEntity.this.m_21825_()) {
                OwlEntity.this.m_21837_(false);
                OwlEntity.this.m_21839_(false);
            }
            list.sort(this.theNearestAttackableTargetSorter);
            this.targetEntity = (ItemEntity)list.get(0);
            this.mustUpdate = false;
            if (this.targetEntity == null) {
                return false;
            }
            this.hunter.onFindTarget(this.targetEntity);
            return !((OwlEntity)this.f_26135_).m_21825_() && (this.f_26135_.m_5448_() == null || !this.f_26135_.m_5448_().m_6084_());
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 10 == 0;
        }

        protected double m_7623_() {
            return 16.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(this.f_26135_.m_20185_() + 0.5, this.f_26135_.m_20186_() + 0.5, this.f_26135_.m_20189_() + 0.5);
            AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
            return aabb.m_82383_(renderCenter);
        }

        public void m_8056_() {
            this.moveTo();
            super.m_8056_();
        }

        protected void moveTo() {
            if (this.walkCooldown > 0) {
                --this.walkCooldown;
            } else {
                OwlEntity.this.walkToIfNotFlyTo(this.targetEntity.m_20182_().m_82520_(0.5, 0.25, 0.5));
                this.f_26135_.m_21573_().m_26536_(OwlEntity.this.m_21573_().m_26524_(this.targetEntity.m_20185_() + 0.5, this.targetEntity.m_20186_() + 0.25, this.targetEntity.m_20189_() + 0.5, 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.25);
                this.walkCooldown = 30 + this.f_26135_.m_217043_().m_188503_(40);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.f_26135_.m_21573_().m_26573_();
            this.targetEntity = null;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.m_6084_()) {
                this.m_8041_();
                this.f_26135_.m_21573_().m_26573_();
            } else {
                this.moveTo();
            }
            if (this.targetEntity != null && this.f_26135_.m_142582_((Entity)this.targetEntity) && (double)this.f_26135_.m_20205_() > this.hunter.getMaxDistToItem() && this.f_26135_.m_20096_()) {
                this.f_26135_.m_21566_().m_6849_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 0.5, this.targetEntity.m_20189_(), 1.5);
            }
            if (this.targetEntity != null && this.targetEntity.m_6084_() && this.f_26135_.m_20280_((Entity)this.targetEntity) < this.hunter.getMaxDistToItem() && OwlEntity.this.itemHandler.getStackInSlot(1).m_41619_()) {
                if (!((OwlEntity)this.hunter).peckAnimation.active) {
                    this.hunter.peck();
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> ((OwlEntity)this.hunter).m_9236_().m_46745_(((OwlEntity)this.hunter).m_20183_())), (Object)new PeckPacket((Entity)this.f_26135_));
                }
                if (((OwlEntity)this.hunter).peckAnimation.peckRot > 40.0f) {
                    this.hunter.onGetItem(this.targetEntity);
                    this.targetEntity.m_32055_().m_41774_(1);
                    this.m_8041_();
                }
            }
            OwlEntity crow = (OwlEntity)this.f_26135_;
            if (this.targetEntity != null) {
                if ((double)this.f_26135_.m_20270_((Entity)this.targetEntity) <= OwlEntity.this.getMaxDistToItem()) {
                    crow.m_21566_().m_6849_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 0.5, this.targetEntity.m_20189_(), 1.5);
                }
                if (!crow.m_21825_()) {
                    OwlEntity.this.flyOrWalkTo(this.targetEntity.m_20182_().m_82520_(0.0, 0.5, 0.0));
                    this.f_26135_.m_21573_().m_26536_(OwlEntity.this.m_21573_().m_26524_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 0.5, this.targetEntity.m_20189_(), 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
                }
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    if (this.targetEntity.m_20182_().m_82554_(OwlEntity.this.m_20182_()) < 3.0 && OwlEntity.this.m_20182_().f_82480_ < this.targetEntity.m_20182_().m_7098_()) {
                        OwlEntity.this.m_20242_(false);
                        OwlEntity.this.m_5997_((this.targetEntity.m_20182_().f_82479_ - OwlEntity.this.m_20182_().f_82479_) / 50.0, (this.targetEntity.m_20182_().f_82480_ - OwlEntity.this.m_20182_().f_82480_) / 50.0 + (double)0.1f, (this.targetEntity.m_20182_().f_82481_ - OwlEntity.this.m_20182_().f_82481_) / 50.0);
                    }
                    OwlEntity.this.flyOrWalkTo(this.targetEntity.m_20182_().m_82520_(0.0, 3.0, 0.0));
                    this.f_26135_.m_21573_().m_26536_(OwlEntity.this.m_21573_().m_26524_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 3.0, this.targetEntity.m_20189_(), 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
                }
            }
        }

        public void makeUpdate() {
            this.mustUpdate = true;
        }

        public boolean m_8045_() {
            boolean path;
            if (OwlEntity.this.m_21223_() >= OwlEntity.this.m_21233_() && OwlEntity.this.m_21824_()) {
                return false;
            }
            boolean bl = path = (double)this.f_26135_.m_20205_() > 2.0 || !this.f_26135_.m_21573_().m_26571_();
            if (OwlEntity.this.m_21825_()) {
                OwlEntity.this.m_21837_(false);
                OwlEntity.this.m_21839_(false);
            }
            return path && this.targetEntity != null && this.targetEntity.m_6084_() && !((OwlEntity)this.f_26135_).m_21825_() && (this.f_26135_.m_5448_() == null || !this.f_26135_.m_5448_().m_6084_());
        }

        public static class Sorter
        implements Comparator<Entity> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d0 = this.theEntity.m_20280_(p_compare_1_);
                double d1 = this.theEntity.m_20280_(p_compare_2_);
                return Double.compare(d0, d1);
            }
        }
    }

    public static enum EmotionState {
        CONTEMPT(0.0f, 0.0f, 0.0f, new Emotions(0, 0, 0)),
        HAPPY(0.0f, 0.0f, 0.0f, new Emotions(0, 0, 100)),
        DISTRESSED(0.75f, 0.05f, 40.0f, new Emotions(0, 100, 0)),
        ANGRY(0.25f, 0.5f, -15.0f, new Emotions(100, 0, 0));

        private final Emotions scales;
        final float browXOffset;
        final float browYOffset;
        final float browZRot;

        private EmotionState(float xOffset, float yOffset, float zRot, Emotions scales) {
            this.browXOffset = xOffset;
            this.browYOffset = yOffset;
            this.browZRot = zRot;
            this.scales = scales;
        }

        public Emotions getScales() {
            return this.scales;
        }

        public float getxOffset() {
            return this.browXOffset;
        }

        public float getyOffset() {
            return this.browYOffset;
        }

        public float getzRot() {
            return this.browZRot;
        }
    }

    public static class CrowGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final OwlVariant variant;

        public CrowGroupData(OwlVariant pVariant) {
            super(true);
            this.variant = pVariant;
        }
    }

    public static enum BrowAnim {
        LEFT,
        RIGHT,
        BOTH;

    }

    public class WanderAroundPlayerGoal
    extends RandomStrollGoal {
        public WanderAroundPlayerGoal(PathfinderMob pMob, double pSpeedModifier) {
            super(pMob, pSpeedModifier, 85);
        }

        public void m_8056_() {
            OwlEntity.this.flyOrWalkTo(new Vec3(this.f_25726_, this.f_25727_, this.f_25728_));
            this.f_25725_.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, OwlEntity.this.isFlyingNav() ? 1.25 * this.f_25729_ : 0.75 * this.f_25729_);
            this.f_25725_.m_21310_(0);
        }

        public boolean m_8036_() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            return super.m_8045_();
        }

        protected Vec3 m_7037_() {
            int pRadius = 5;
            int pVerticalDistance = 7;
            if (OwlEntity.this.m_269323_() != null) {
                boolean flag = GoalUtils.m_148442_((PathfinderMob)this.f_25725_, (int)pRadius);
                double d0 = Double.NEGATIVE_INFINITY;
                BlockPos blockpos = null;
                for (int i = 0; i < 10; ++i) {
                    double d1;
                    BlockPos pos = RandomPos.m_217851_((RandomSource)OwlEntity.this.m_217043_(), (int)pRadius, (int)pVerticalDistance);
                    BlockPos blockpos1 = OwlEntity.this.getPerchPos() != null ? WanderAroundPlayerGoal.generateRandomPosTowardDirection((Position)Vec3.m_82528_((Vec3i)OwlEntity.this.getPerchPos()), this.f_25725_, flag, pos) : (OwlEntity.this.m_269323_() != null ? WanderAroundPlayerGoal.generateRandomPosTowardDirection((Position)OwlEntity.this.m_269323_().m_20182_(), this.f_25725_, flag, pos) : OwlEntity.this.m_20183_());
                    if (blockpos1 == null || !((d1 = (double)OwlEntity.this.m_21692_(blockpos1)) > d0)) continue;
                    d0 = d1;
                    blockpos = blockpos1;
                }
                return blockpos != null ? Vec3.m_82539_(blockpos) : null;
            }
            return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)7);
        }

        private static BlockPos generateRandomPosTowardDirection(Position pos, PathfinderMob pMob, boolean pShortCircuit, BlockPos pPos) {
            BlockPos blockpos = WanderAroundPlayerGoal.generateRandomPosTowardDirection(pos, pPos);
            boolean outsidelimits = !GoalUtils.m_148451_((BlockPos)blockpos, (PathfinderMob)pMob);
            boolean restricted = !GoalUtils.m_148454_((boolean)pShortCircuit, (PathfinderMob)pMob, (BlockPos)blockpos);
            boolean notstable = !GoalUtils.m_148448_((PathNavigation)pMob.m_21573_(), (BlockPos)blockpos);
            boolean malus = !GoalUtils.m_148458_((PathfinderMob)pMob, (BlockPos)blockpos);
            return outsidelimits && restricted && malus ? blockpos : null;
        }

        public static BlockPos generateRandomPosTowardDirection(Position pos, BlockPos pPos) {
            int i = pPos.m_123341_();
            int j = pPos.m_123343_();
            return BlockPos.m_274561_((double)((double)i + pos.m_7096_()), (double)((double)pPos.m_123342_() + pos.m_7098_()), (double)((double)j + pos.m_7094_()));
        }
    }

    public class LandOnOwnersShoulderGoal
    extends Goal {
        private final OwlEntity entity;
        private ServerPlayer owner;
        private boolean isSittingOnShoulder;

        public LandOnOwnersShoulderGoal(OwlEntity p_25483_) {
            this.entity = p_25483_;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public boolean m_8036_() {
            if (OwlEntity.this.m_6162_()) {
                return false;
            }
            ServerPlayer serverplayer = (ServerPlayer)this.entity.m_269323_();
            boolean flag = serverplayer != null && !serverplayer.m_5833_() && !serverplayer.m_150110_().f_35935_ && !serverplayer.m_20069_() && !serverplayer.f_146808_;
            return !this.entity.m_21827_() && !this.entity.m_21825_() && flag && this.entity.canSitOnShoulder() && serverplayer.m_20197_().size() < 2;
        }

        public boolean m_6767_() {
            return !this.isSittingOnShoulder;
        }

        public void m_8056_() {
            this.owner = (ServerPlayer)this.entity.m_269323_();
            this.isSittingOnShoulder = false;
        }

        public void m_8037_() {
            if (!this.isSittingOnShoulder && !this.entity.m_21825_() && !this.entity.m_21523_() && this.entity.m_20191_().m_82381_(this.owner.m_20191_())) {
                this.isSittingOnShoulder = this.entity.m_7998_((Entity)this.owner, true);
                if (!OwlEntity.this.m_9236_().f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> OwlEntity.this.m_9236_().m_46745_(OwlEntity.this.m_20183_())), (Object)new CrowStartRidingPacket((Entity)this.entity, (Player)this.owner));
                }
            }
            if (this.isSittingOnShoulder) {
                this.entity.rideCooldownCounter = 0;
            }
        }
    }

    public static class MessageText {
        public static final int LINES = 12;
        private static final Codec<Component[]> LINES_CODEC = ExtraCodecs.f_276686_.listOf().comapFlatMap(p_277790_ -> Util.m_143795_((List)p_277790_, (int)12).map(components -> (Component[])components.toArray(value -> new Component[12])), Arrays::asList);
        public static final Codec<MessageText> DIRECT_CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)LINES_CODEC.fieldOf("messages").forGetter(messageText -> messageText.messages)).apply((Applicative)codecBuilder, MessageText::load));
        private final Component[] messages;

        public MessageText() {
            this(MessageText.emptyMessages(12));
        }

        public MessageText(Component[] pMessages) {
            this.messages = pMessages;
        }

        private static Component[] emptyMessages(int size) {
            Object[] messages = new Component[size];
            Arrays.fill(messages, CommonComponents.f_237098_);
            return messages;
        }

        private static MessageText load(Component[] component) {
            return new MessageText(component);
        }

        public Component getMessage(int pIndex) {
            return this.getMessages()[pIndex];
        }

        public MessageText setMessage(int pIndex, Component pText) {
            Component[] acomponent = Arrays.copyOf(this.messages, this.messages.length);
            acomponent[pIndex] = pText;
            return new MessageText(acomponent);
        }

        public Component[] getMessages() {
            return this.messages;
        }
    }

    public class AnimationBase
    implements Animation {
        public boolean active;
        public int cooldownTimer;
        public int activeTimer;
        public boolean useCooldown = true;

        @Override
        public void tick() {
            this.preTick();
            if (this.active) {
                this.activeTick();
                --this.activeTimer;
                if (this.activeTimer <= 0) {
                    this.stop();
                }
            } else if (!OwlEntity.this.m_9236_().f_46443_ && this.useCooldown) {
                --this.cooldownTimer;
                if (this.cooldownTimer <= 0) {
                    this.start();
                }
            }
            this.postTick();
        }

        public void preTick() {
        }

        public void activeTick() {
        }

        public void postTick() {
        }

        @Override
        public void start() {
            this.active = true;
        }

        @Override
        public void stop() {
            this.active = false;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }
    }
}

