/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.CandleEffectParticlePacket;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class SunshineCandleEffect
extends AbstractCandleEffect {
    private static final int MAX_TIME = 160;

    private static int getDuration(RandomSource pSource, int pTime, IntProvider pTimeProvider) {
        return pTime == -1 ? pTimeProvider.m_214085_(pSource) : pTime;
    }

    @Override
    public void tick(Level level, CandleTile blockEntity, CandleData candleData) {
        if (candleData.lit) {
            if (candleData.cooldown >= 160) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_6018_().m_8606_(SunshineCandleEffect.getDuration(level.m_213780_(), -1, ServerLevel.f_263704_), 0, false, false);
                    if (candleData.effectParticle.size() > 0) {
                        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)blockEntity.m_58899_().m_123341_(), (double)blockEntity.m_58899_().m_123342_(), (double)blockEntity.m_58899_().m_123343_(), 500.0, level.m_46472_());
                        HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new CandleEffectParticlePacket(blockEntity.m_58899_(), candleData.effectParticle, 0, 1));
                    }
                }
                candleData.cooldown = 0;
            }
            candleData.cooldown = (candleData.cooldown + 1) % Integer.MAX_VALUE;
            try {
                if (candleData.effectParticle != null && level.m_5776_() && candleData.effectParticle != null && candleData.effectParticle.size() > 0) {
                    this.particle = ParticleArgument.m_247456_((StringReader)new StringReader(candleData.effectParticle.get(new Random().nextInt(candleData.effectParticle.size()))), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_());
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> AbstractCandleEffect getCopy() {
        return new SunshineCandleEffect();
    }

    @Override
    public String getLocationName() {
        return new ResourceLocation("hexerei", "sunshine_effect").toString();
    }
}

