/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CauldronFillingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final FluidStack fluid;

    public CauldronFillingRecipe(ResourceLocation id, Ingredient input, ItemStack output, FluidStack fluid) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.fluid = fluid;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return this.test(this.input, pContainer.m_8020_(0));
    }

    public boolean test(Ingredient ingredient, @javax.annotation.Nullable ItemStack pStack) {
        if (pStack == null) {
            return false;
        }
        if (ingredient.m_43947_()) {
            return pStack.m_41619_();
        }
        for (ItemStack itemstack : ingredient.m_43908_()) {
            if (!itemstack.m_150930_(pStack.m_41720_())) continue;
            return !itemstack.m_41782_() || !pStack.m_41782_() || !itemstack.m_41783_().m_128441_("Potion") || !pStack.m_41783_().m_128441_("Potion") || itemstack.m_41783_().m_128461_("Potion").equals(pStack.m_41783_().m_128461_("Potion"));
        }
        return false;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.m_8043_(pRegistryAccess);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public FluidStack getResultingFluid() {
        return this.fluid.copy();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.CAULDRON_FILLING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CAULDRON_FILLING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CauldronFillingRecipe> {
        public CauldronFillingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            FluidStack fluid = MixingCauldronRecipe.Serializer.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"fluid"));
            return new CauldronFillingRecipe(pRecipeId, input, result, fluid);
        }

        @Nullable
        public CauldronFillingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack result = buf.m_130267_();
            FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buf);
            return new CauldronFillingRecipe(pRecipeId, input, result, fluid);
        }

        public void toNetwork(FriendlyByteBuf buf, CauldronFillingRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.output);
            recipe.fluid.writeToPacket(buf);
        }
    }
}

