/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ModFluidTypes {
    public static final ResourceLocation QUICKSILVER_STILL_RL = new ResourceLocation("hexerei:block/quicksilver_still");
    public static final ResourceLocation QUICKSILVER_FLOWING_RL = new ResourceLocation("hexerei:block/quicksilver_flow");
    public static final ResourceLocation QUICKSILVER_OVERLAY_RL = new ResourceLocation("hexerei:block/quicksilver_overlay");
    public static final ResourceLocation BLOOD_STILL_RL = new ResourceLocation("hexerei:block/blood_still");
    public static final ResourceLocation BLOOD_FLOWING_RL = new ResourceLocation("hexerei:block/blood_flow");
    public static final ResourceLocation BLOOD_OVERLAY_RL = new ResourceLocation("hexerei:block/blood_overlay");
    public static final ResourceLocation TALLOW_STILL_RL = new ResourceLocation("hexerei:block/tallow_still");
    public static final ResourceLocation TALLOW_FLOWING_RL = new ResourceLocation("hexerei:block/tallow_flow");
    public static final ResourceLocation TALLOW_OVERLAY_RL = new ResourceLocation("hexerei:block/tallow_overlay");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"hexerei");
    public static final RegistryObject<FluidType> QUICKSILVER_FLUID_TYPE = FLUID_TYPES.register("quicksilver_fluid", () -> new FluidType(FluidType.Properties.create().supportsBoating(true).canHydrate(true).lightLevel(0).density(15).viscosity(5).sound(SoundAction.get((String)"bucket_fill"), SoundEvents.f_11783_)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation STILL = QUICKSILVER_STILL_RL;
                private static final ResourceLocation FLOW = QUICKSILVER_FLOWING_RL;
                private static final ResourceLocation OVERLAY = QUICKSILVER_OVERLAY_RL;
                private static final ResourceLocation VIEW_OVERLAY = new ResourceLocation("textures/block/red_sand.png");

                public ResourceLocation getStillTexture() {
                    return STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOW;
                }

                public ResourceLocation getOverlayTexture() {
                    return OVERLAY;
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return VIEW_OVERLAY;
                }

                public int getTintColor() {
                    return -100663297;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    int color = this.getTintColor();
                    return new Vector3f(0.3125f, 0.3137255f, 0.3137255f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    nearDistance = -8.0f;
                    farDistance = 3.0f;
                    if (farDistance > renderDistance) {
                        farDistance = renderDistance;
                        shape = FogShape.CYLINDER;
                    }
                    RenderSystem.setShaderFogStart((float)nearDistance);
                    RenderSystem.setShaderFogEnd((float)farDistance);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }
            });
        }
    });
    public static final RegistryObject<FluidType> BLOOD_FLUID_TYPE = FLUID_TYPES.register("blood_fluid", () -> new FluidType(FluidType.Properties.create().supportsBoating(true).canHydrate(true).lightLevel(0).density(1500).viscosity(2000).sound(SoundAction.get((String)"bucket_fill"), SoundEvents.f_11970_)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation STILL = BLOOD_STILL_RL;
                private static final ResourceLocation FLOW = BLOOD_FLOWING_RL;
                private static final ResourceLocation OVERLAY = BLOOD_OVERLAY_RL;
                private static final ResourceLocation VIEW_OVERLAY = new ResourceLocation("textures/block/nether_wart_block.png");

                public ResourceLocation getStillTexture() {
                    return STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOW;
                }

                public ResourceLocation getOverlayTexture() {
                    return OVERLAY;
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return VIEW_OVERLAY;
                }

                public int getTintColor() {
                    return -100663297;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    int color = this.getTintColor();
                    return new Vector3f(0.1875f, 0.015686275f, 0.015686275f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    nearDistance = -8.0f;
                    farDistance = 4.0f;
                    if (farDistance > renderDistance) {
                        farDistance = renderDistance;
                        shape = FogShape.CYLINDER;
                    }
                    RenderSystem.setShaderFogStart((float)nearDistance);
                    RenderSystem.setShaderFogEnd((float)farDistance);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }
            });
        }
    });
    public static final RegistryObject<FluidType> TALLOW_FLUID_TYPE = FLUID_TYPES.register("tallow_fluid", () -> new FluidType(FluidType.Properties.create().supportsBoating(true).canHydrate(true).lightLevel(0).density(1500).viscosity(2000).sound(SoundAction.get((String)"bucket_fill"), SoundEvents.f_11970_)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation STILL = TALLOW_STILL_RL;
                private static final ResourceLocation FLOW = TALLOW_FLOWING_RL;
                private static final ResourceLocation OVERLAY = TALLOW_OVERLAY_RL;
                private static final ResourceLocation VIEW_OVERLAY = new ResourceLocation("textures/block/sand.png");

                public ResourceLocation getStillTexture() {
                    return STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOW;
                }

                public ResourceLocation getOverlayTexture() {
                    return OVERLAY;
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return VIEW_OVERLAY;
                }

                public int getTintColor() {
                    return -100663297;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    int color = this.getTintColor();
                    return new Vector3f(0.59765625f, 0.6f, 0.44705883f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    nearDistance = -8.0f;
                    farDistance = 3.0f;
                    if (farDistance > renderDistance) {
                        farDistance = renderDistance;
                        shape = FogShape.CYLINDER;
                    }
                    RenderSystem.setShaderFogStart((float)nearDistance);
                    RenderSystem.setShaderFogEnd((float)farDistance);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }
            });
        }
    });

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }
}

