/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.fluid;

import java.util.Collection;
import java.util.List;
import net.joefoxe.hexerei.fluid.ModFluids;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PotionFluid
extends ForgeFlowingFluid {
    protected PotionFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public Fluid m_5613_() {
        return super.m_5613_();
    }

    public Fluid m_5615_() {
        return this;
    }

    public Item m_6859_() {
        return Items.f_41852_;
    }

    protected BlockState m_5804_(FluidState state) {
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_7444_(FluidState p_207193_1_) {
        return false;
    }

    public int m_7430_(FluidState p_207192_1_) {
        return 0;
    }

    public static FluidStack of(int amount, Potion potion) {
        FluidStack fluidStack = new FluidStack(((PotionFluid)((Object)ModFluids.POTION.get())).m_5613_(), amount);
        PotionFluid.addPotionToFluidStack(fluidStack, potion);
        return fluidStack;
    }

    public static FluidStack withEffects(int amount, Potion potion, List<MobEffectInstance> customEffects) {
        FluidStack fluidStack = PotionFluid.of(amount, potion);
        PotionFluid.appendEffects(fluidStack, customEffects);
        return fluidStack;
    }

    public static FluidStack addPotionToFluidStack(FluidStack fs, Potion potion) {
        ResourceLocation resourcelocation = PotionFluid.getKeyOrThrow(potion);
        if (potion == Potions.f_43598_) {
            fs.removeChildTag("Potion");
            return fs;
        }
        fs.getOrCreateTag().m_128359_("Potion", resourcelocation.toString());
        return fs;
    }

    public static FluidStack appendEffects(FluidStack fs, Collection<MobEffectInstance> customEffects) {
        if (customEffects.isEmpty()) {
            return fs;
        }
        CompoundTag compoundnbt = fs.getOrCreateTag();
        ListTag listnbt = compoundnbt.m_128437_("CustomPotionEffects", 9);
        for (MobEffectInstance effectinstance : customEffects) {
            listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
        }
        compoundnbt.m_128365_("CustomPotionEffects", (Tag)listnbt);
        return fs;
    }

    public static <V> ResourceLocation getKeyOrThrow(Potion value) {
        IForgeRegistry registry = ForgeRegistries.POTIONS;
        ResourceLocation key = registry.getKey((Object)value);
        if (key == null) {
            throw new IllegalArgumentException("Could not get key for value " + value + "!");
        }
        return key;
    }

    public static enum BottleType {
        REGULAR,
        SPLASH,
        LINGERING;

    }
}

