/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CourierLetterUpdatePacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class CourierLetterScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation GUI = new ResourceLocation("hexerei", "textures/gui/courier_letter_gui.png");
    private final String[] messages;
    private OwlEntity.MessageText text = new OwlEntity.MessageText();
    private static final Vector3f TEXT_SCALE = new Vector3f(0.9765628f, 0.9765628f, 0.9765628f);
    @Nullable
    private TextFieldHelper messageField;
    int frame;
    int line;
    int img_width = 172;
    int img_height = 164;
    int left;
    int top;
    int slotIndex;
    InteractionHand hand;
    boolean dirty = false;
    boolean clicked = false;
    int clickedTicks = 0;
    int clickedTicksOld = 0;
    boolean sealed = false;

    public CourierLetterScreen(int slotIndex, InteractionHand hand, ItemStack stack) {
        super((Component)Component.m_237115_((String)"screen.hexerei.letter"));
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null) {
            if (tag.m_128441_("Message")) {
                OwlEntity.MessageText.DIRECT_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("Message")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(message -> {
                    this.text = this.loadLines((OwlEntity.MessageText)message);
                });
            }
            if (tag.m_128441_("Sealed")) {
                this.sealed = tag.m_128471_("Sealed");
            }
        }
        this.f_96541_ = Minecraft.m_91087_();
        this.messages = (String[])IntStream.range(0, 12).mapToObj(p_277214_ -> this.text.getMessage(p_277214_)).map(Component::getString).toArray(String[]::new);
        this.frame = 0;
        this.line = 0;
        this.slotIndex = slotIndex;
        this.hand = hand;
    }

    public boolean isEmpty() {
        for (String str : this.messages) {
            if (str.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private OwlEntity.MessageText loadLines(OwlEntity.MessageText pText) {
        for (int i = 0; i < 12; ++i) {
            Component component = pText.getMessage(i);
            pText = pText.setMessage(i, component);
        }
        return pText;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setChanged() {
        this.setDirty(true);
    }

    public boolean m_6375_(double x, double y, int pButton) {
        if (pButton == 0) {
            for (int i = 0; i < 12; ++i) {
                if (!(x > (double)(this.left + 5)) || !(x < (double)(this.left + 5 + 162)) || !(y > (double)(this.top + 25 + this.getTextLineHeight() * i)) || !(y < (double)(this.top + 25 + this.getTextLineHeight() + this.getTextLineHeight() * i))) continue;
                this.line = i;
                this.messageField.m_95193_();
                return true;
            }
            if (!this.sealed && x > (double)(this.left + 71) && x < (double)(this.left + 71 + 30) && y > (double)(this.top + 151) && y < (double)(this.top + 151 + 15) && !this.isEmpty()) {
                this.clicked = true;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)1.0f, (float)0.25f));
                return true;
            }
        }
        return super.m_6375_(x, y, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (!this.sealed && this.clicked && pButton == 0 && !this.isEmpty()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)0.85f, (float)0.25f));
            this.clicked = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double x, double y, int pButton, double pDragX, double pDragY) {
        if (!(this.sealed || !this.clicked || pButton != 0 || this.isEmpty() || x > (double)(this.left + 71) && x < (double)(this.left + 71 + 30) && y > (double)(this.top + 151) && y < (double)(this.top + 151 + 15))) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)0.85f, (float)0.25f));
            this.clicked = false;
        }
        return super.m_7979_(x, y, pButton, pDragX, pDragY);
    }

    protected void m_7856_() {
        this.left = this.f_96543_ / 2 - this.img_width / 2;
        this.top = this.f_96544_ / 2 - this.img_height / 2;
        this.messageField = new TextFieldHelper(() -> this.messages[this.line], this::setMessage, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), string -> this.f_96541_.f_91062_.m_92895_(string) <= this.getMaxTextLineWidth());
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == this.f_96541_.f_91066_.f_92092_.getKey().m_84873_() && this.sealed) {
            this.m_7379_();
            return true;
        }
        if (pKeyCode == 265) {
            this.line = (this.line - 1 + 12) % 12;
            this.messageField.m_95193_();
            return true;
        }
        if (pKeyCode == 258) {
            this.messageField.m_95158_("    ");
            return true;
        }
        if (pKeyCode != 264 && pKeyCode != 257 && pKeyCode != 335) {
            return this.messageField.m_95145_(pKeyCode) ? true : super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        this.line = (this.line + 1 + 12) % 12;
        this.messageField.m_95193_();
        return true;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        this.messageField.m_95143_(pCodePoint);
        return true;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Lighting.m_84930_();
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.top + 4, 0x333333);
        pGuiGraphics.m_280218_(this.GUI, this.left, this.top, 0, 0, this.img_width, this.img_height);
        if (!this.sealed) {
            if (!this.isEmpty()) {
                if (this.clicked) {
                    pGuiGraphics.m_280218_(this.GUI, this.left + 71, this.top + 151, 1, 224, 30, 15);
                } else if (pMouseX > this.left + 71 && pMouseX < this.left + 71 + 30 && pMouseY > this.top + 151 && pMouseY < this.top + 151 + 15) {
                    pGuiGraphics.m_280218_(this.GUI, this.left + 71, this.top + 151, 1, 240, 30, 15);
                } else {
                    pGuiGraphics.m_280218_(this.GUI, this.left + 71, this.top + 151, 1, 192, 30, 15);
                }
                float alpha = 1.0f - Mth.m_14036_((float)(Mth.m_14179_((float)pPartialTick, (float)this.clickedTicksOld, (float)this.clickedTicks) / 15.0f), (float)0.0f, (float)1.0f);
                if (alpha > 0.05f) {
                    pGuiGraphics.m_280168_().m_85836_();
                    pGuiGraphics.m_280168_().m_252880_((float)this.left, (float)this.top, 2.0f);
                    pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"hexerei.package_letter.seal"), 75, 155, HexereiUtil.getColorValueAlpha(0.2f, 0.2f, 0.2f, alpha), false);
                    pGuiGraphics.m_280168_().m_85849_();
                }
                float xOffset = Mth.m_14036_((float)(31.0f * (Mth.m_14179_((float)pPartialTick, (float)this.clickedTicksOld, (float)this.clickedTicks) / 12.0f)), (float)0.0f, (float)30.0f);
                float xOffset2 = Mth.m_14036_((float)(7.0f * (Mth.m_14179_((float)pPartialTick, (float)(this.clickedTicksOld - 12), (float)(this.clickedTicks - 12)) / 3.0f)), (float)0.0f, (float)6.0f);
                float xOffset3 = Mth.m_14036_((float)(7.0f * (Mth.m_14179_((float)pPartialTick, (float)(this.clickedTicksOld - 5), (float)(this.clickedTicks - 5)) / 5.0f)), (float)0.0f, (float)6.0f);
                float yOffset = Mth.m_14036_((float)(10.0f * (Mth.m_14179_((float)pPartialTick, (float)(this.clickedTicksOld - 16), (float)(this.clickedTicks - 16)) / 2.0f)), (float)0.0f, (float)9.0f);
                this.floatBlit(pGuiGraphics, this.GUI, this.left + 71, (float)(this.left + 71) + xOffset, this.top + 151, this.top + 160, 3.0f, 0.00390625f, (1.0f + xOffset) / 256.0f, 0.66796875f, 0.703125f);
                this.floatBlit(pGuiGraphics, this.GUI, (float)(this.left + 92 + 6) - xOffset2, this.left + 92 + 6, this.top + 159, this.top + 164, 4.0f, (23.0f - xOffset2) / 256.0f, 0.08984375f, 0.7109375f, 0.73046875f);
                this.floatBlit(pGuiGraphics, this.GUI, this.left + 91 - 17, (float)(this.left + 91 - 17) + xOffset3, this.top + 158, (float)(this.top + 158) + xOffset3, 4.0f, 0.0390625f, (10.0f + xOffset3) / 256.0f, 0.7109375f, (182.0f + xOffset3) / 256.0f);
                this.floatBlit(pGuiGraphics, this.GUI, this.left + 82, this.left + 82 + 8, this.top + 154, (float)(this.top + 154) + yOffset, 5.0f, 0.00390625f, 0.03515625f, 0.7109375f, (182.0f + yOffset) / 256.0f);
            } else {
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_252880_((float)this.left, (float)this.top, 2.0f);
                pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"hexerei.package_letter.seal"), 75, 155, 0x333333, false);
                pGuiGraphics.m_280168_().m_85849_();
                pGuiGraphics.m_280218_(this.GUI, this.left + 71, this.top + 151, 1, 208, 30, 15);
            }
        }
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)(this.left + 86), (float)(this.top + 85), 4.0f);
        pGuiGraphics.m_280168_().m_85841_(TEXT_SCALE.x(), TEXT_SCALE.y(), TEXT_SCALE.z());
        int col = DyeColor.BLACK.m_41071_();
        boolean flag = this.frame / 6 % 2 == 0;
        int cursorPos = this.messageField.m_95194_();
        int selectionPos = this.messageField.m_95197_();
        int l = 12 * this.getTextLineHeight() / 2;
        int i1 = this.line * this.getTextLineHeight() - l;
        for (int i = 0; i < this.messages.length; ++i) {
            String str = this.messages[i];
            if (str == null) continue;
            if (this.f_96547_.m_92718_()) {
                str = this.f_96547_.m_92801_(str);
            }
            pGuiGraphics.m_280056_(this.f_96547_, str, -75, i * this.getTextLineHeight() - l, col, false);
            if (i != this.line || cursorPos < 0 || !flag || this.sealed || cursorPos < str.length()) continue;
            pGuiGraphics.m_280056_(this.f_96547_, "_", this.f_96547_.m_92895_(str.substring(0, Math.max(Math.min(cursorPos, str.length()), 0))) - 75, i1, col, false);
        }
        for (int k3 = 0; k3 < this.messages.length; ++k3) {
            String s1 = this.messages[k3];
            if (s1 == null || k3 != this.line || cursorPos < 0) continue;
            int l3 = this.f_96547_.m_92895_(s1.substring(0, Math.max(Math.min(cursorPos, s1.length()), 0)));
            int i4 = l3 - 75;
            if (flag && cursorPos < s1.length() && !this.sealed) {
                pGuiGraphics.m_280509_(i4, i1 - 1, i4 + 1, i1 + this.getTextLineHeight(), 0xFF000000 | col);
            }
            if (selectionPos == cursorPos) continue;
            int j4 = Math.min(cursorPos, selectionPos);
            int j2 = Math.max(cursorPos, selectionPos);
            int k2 = this.f_96547_.m_92895_(s1.substring(0, j4)) - 75;
            int l2 = this.f_96547_.m_92895_(s1.substring(0, j2)) - 75;
            int i3 = Math.min(k2, l2);
            int j3 = Math.max(k2, l2);
            pGuiGraphics.m_285944_(RenderType.m_285783_(), i3, i1, j3, i1 + this.getTextLineHeight(), -16776961);
        }
        pGuiGraphics.m_280168_().m_85849_();
        ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
        if (!this.clicked && !this.sealed && pMouseX > this.left + 71 && pMouseX < this.left + 71 + 30 && pMouseY > this.top + 151 && pMouseY < this.top + 151 + 15) {
            tooltipLines.add(Component.m_237115_((String)"hexerei.package_letter.letter_seal_tooltip").m_130940_(ChatFormatting.DARK_GRAY));
            tooltipLines.add(Component.m_237115_((String)"hexerei.package_letter.letter_seal_tooltip2").m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (!tooltipLines.isEmpty()) {
            pGuiGraphics.m_280677_(this.f_96547_, tooltipLines, Optional.empty(), pMouseX, pMouseY);
        }
        Lighting.m_84931_();
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    void floatBlit(GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, pX1, pY1, pBlitOffset).m_7421_(pMinU, pMinV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX1, pY2, pBlitOffset).m_7421_(pMinU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY2, pBlitOffset).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY1, pBlitOffset).m_7421_(pMaxU, pMinV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public Component m_96636_() {
        return super.m_96636_();
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 150;
    }

    private void onDone() {
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        ++this.frame;
        if (!this.sealed) {
            this.clickedTicksOld = this.clickedTicks--;
            if (this.clicked) {
                if (this.clickedTicks % 8 == 0) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_184215_, (float)1.5f, (float)0.75f));
                }
                ++this.clickedTicks;
                if (this.clickedTicks > 25) {
                    this.clicked = false;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_184214_, (float)1.8f, (float)0.75f));
                    OwlEntity.MessageText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.text).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> HexereiPacketHandler.sendToServer(new CourierLetterUpdatePacket(this.slotIndex, (CompoundTag)tag, true)));
                    this.m_7379_();
                    return;
                }
            } else if (this.clickedTicks < 0) {
                this.clickedTicks = 0;
            }
            if (this.frame % 5 == 0 && this.dirty) {
                OwlEntity.MessageText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.text).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> HexereiPacketHandler.sendToServer(new CourierLetterUpdatePacket(this.slotIndex, (CompoundTag)tag, false)));
                this.dirty = false;
            }
        }
        if (!this.isValid()) {
            this.onDone();
        }
    }

    private boolean isValid() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && Inventory.m_36045_((int)this.slotIndex)) {
            return this.f_96541_.f_91074_.m_150109_().f_35977_ == this.slotIndex;
        }
        return false;
    }

    private void setMessage(String string) {
        if (!this.sealed) {
            this.messages[this.line] = string;
            this.text = this.text.setMessage(this.line, (Component)Component.m_237113_((String)string));
            this.setChanged();
        }
    }
}

