/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class CandleTile
extends BlockEntity {
    public NonNullList<CandleData> candles = NonNullList.m_122780_((int)4, (Object)new CandleData());
    public boolean litStateOld;
    public int redstoneAnalogSignal;
    public int redstoneBases;
    private boolean startupFlag;
    public Component customName;
    public int tickCount = 0;

    public CandleTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.candles.replaceAll(ignored -> new CandleData());
        this.startupFlag = false;
        this.litStateOld = false;
    }

    public CandleTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CANDLE_TILE.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag nbt) {
        if (nbt.m_128425_("candle0", 10)) {
            if (nbt.m_128441_("candle0")) {
                ((CandleData)this.candles.get(0)).load(nbt.m_128469_("candle0"));
            }
            if (nbt.m_128441_("candle1")) {
                ((CandleData)this.candles.get(1)).load(nbt.m_128469_("candle1"));
            }
            if (nbt.m_128441_("candle2")) {
                ((CandleData)this.candles.get(2)).load(nbt.m_128469_("candle2"));
            }
            if (nbt.m_128441_("candle3")) {
                ((CandleData)this.candles.get(3)).load(nbt.m_128469_("candle3"));
            }
        }
        this.setOffsetPos(true);
        super.m_142466_(nbt);
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("effectCooldown", ((CandleData)this.candles.get((int)0)).cooldown);
        compound.m_128365_("candle0", (Tag)((CandleData)this.candles.get(0)).save());
        compound.m_128365_("candle1", (Tag)((CandleData)this.candles.get(1)).save());
        compound.m_128365_("candle2", (Tag)((CandleData)this.candles.get(2)).save());
        compound.m_128365_("candle3", (Tag)((CandleData)this.candles.get(3)).save());
    }

    public CompoundTag save(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("effectCooldown", ((CandleData)this.candles.get((int)0)).cooldown);
        tag.m_128365_("candle0", (Tag)((CandleData)this.candles.get(0)).save());
        tag.m_128365_("candle1", (Tag)((CandleData)this.candles.get(1)).save());
        tag.m_128365_("candle2", (Tag)((CandleData)this.candles.get(2)).save());
        tag.m_128365_("candle3", (Tag)((CandleData)this.candles.get(3)).save());
        return tag;
    }

    public int getNumberOfCandles() {
        int num = 0;
        for (CandleData candleData : this.candles) {
            if (!candleData.hasCandle) continue;
            ++num;
        }
        return num;
    }

    public Component getCustomName() {
        return this.getCustomName(0);
    }

    public Component getCustomName(int slot) {
        return ((CandleData)this.candles.get((int)slot)).customName;
    }

    public int getDyeColor(int slot) {
        return ((CandleData)this.candles.get((int)slot)).dyeColor;
    }

    public int getDyeColor() {
        return this.getDyeColor(0);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20185_() - (double)pos.m_123341_();
        double deltaY = entity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = entity.m_20189_() - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(25.0, 25.0, 25.0);
    }

    public void sync() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    public void setDyeColor(int dyeColor) {
        ((CandleData)this.candles.get((int)0)).dyeColor = dyeColor;
    }

    public void setHeight(int height) {
        ((CandleData)this.candles.get((int)0)).height = height;
    }

    public void setDyeColor(int candle, int dyeColor) {
        ((CandleData)this.candles.get((int)Math.max((int)0, (int)Math.min((int)candle, (int)3)))).dyeColor = dyeColor;
    }

    public void setHeight(int candle, int height) {
        ((CandleData)this.candles.get((int)Math.max((int)0, (int)Math.min((int)candle, (int)3)))).height = height;
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    public int updateAnalog() {
        int temp = 0;
        int level_of_candles = 0;
        for (int i = 0; i < 4; ++i) {
            if (!((CandleData)this.candles.get((int)i)).hasCandle) continue;
            level_of_candles += ((CandleData)this.candles.get((int)i)).height;
        }
        float candles = level_of_candles;
        float max = 28.0f;
        float percent = candles / max;
        if (this.redstoneAnalogSignal != (temp += (int)Math.ceil(percent * 15.0f))) {
            this.redstoneAnalogSignal = temp;
            for (Direction direction : Direction.values()) {
                this.f_58857_.m_46672_(this.m_58899_().m_121945_(direction), this.m_58900_().m_60734_());
            }
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
        }
        return temp;
    }

    public void entityInside(Entity entity) {
        BlockPos blockpos = this.m_58899_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-blockpos.m_123341_()), (double)(-blockpos.m_123342_()), (double)(-blockpos.m_123343_()))), (VoxelShape)Candle.getShape(this.m_58900_()), (BooleanOp)BooleanOp.f_82689_) && projectile.m_6060_() && this.f_58857_ != null) {
                if (((CandleData)this.candles.get((int)0)).hasCandle) {
                    ((CandleData)this.candles.get((int)0)).lit = true;
                }
                if (((CandleData)this.candles.get((int)1)).hasCandle) {
                    ((CandleData)this.candles.get((int)1)).lit = true;
                }
                if (((CandleData)this.candles.get((int)2)).hasCandle) {
                    ((CandleData)this.candles.get((int)2)).lit = true;
                }
                if (((CandleData)this.candles.get((int)3)).hasCandle) {
                    ((CandleData)this.candles.get((int)3)).lit = true;
                }
            }
        }
    }

    public void tick() {
        Random random = new Random();
        int candlesLit = 0;
        ++this.tickCount;
        for (CandleData candleData2 : this.candles) {
            candleData2.setOldPos();
            candleData2.move();
            if (candleData2.getEffect() != null) {
                candleData2.getEffect().tick(this.f_58857_, this, candleData2);
            }
            if (!candleData2.lit) continue;
            ++candlesLit;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)Candle.CANDLES_LIT)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)Candle.CANDLES_LIT, (Comparable)Integer.valueOf(candlesLit))).m_61124_((Property)Candle.f_151895_, (Comparable)Boolean.valueOf(candlesLit > 0)), 3);
        }
        int temp = 0;
        int level_of_candles = 0;
        for (int i = 0; i < 4; ++i) {
            if (!((CandleData)this.candles.get((int)i)).hasCandle) continue;
            level_of_candles += ((CandleData)this.candles.get((int)i)).height;
        }
        float candles = level_of_candles;
        float max = 28.0f;
        float percent = candles / max;
        if (this.redstoneAnalogSignal != (temp += (int)Math.ceil(percent * 15.0f))) {
            this.redstoneAnalogSignal = temp;
            for (Direction direction : Direction.values()) {
                this.f_58857_.m_46672_(this.m_58899_().m_121945_(direction), this.m_58900_().m_60734_());
            }
        }
        int hasRedstoneBase = 0;
        for (int i = 0; i < 4; ++i) {
            if (((CandleData)this.candles.get((int)i)).base.layer == null || !((CandleData)this.candles.get((int)i)).base.layer.toString().equals("minecraft:redstone_block")) continue;
            ++hasRedstoneBase;
        }
        if (this.redstoneBases != hasRedstoneBase) {
            this.redstoneBases = hasRedstoneBase;
            float percent2 = (float)hasRedstoneBase / 4.0f;
            int redstoneValue = (int)Math.ceil(percent2 * 15.0f);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)Candle.POWER, (Comparable)Integer.valueOf(redstoneValue)), 3);
            for (Direction direction : Direction.values()) {
                this.f_58857_.m_46672_(this.m_58899_().m_121945_(direction), this.m_58900_().m_60734_());
            }
        }
        if (!this.startupFlag) {
            if (!this.m_58900_().m_60734_().m_5456_().equals(ModItems.CANDLE.get())) {
                ((CandleData)this.candles.get((int)0)).height = 7;
                ((CandleData)this.candles.get((int)0)).hasCandle = true;
            }
            ((CandleData)this.candles.get((int)0)).hasCandle = true;
            ((CandleData)this.candles.get((int)0)).meltTimer = CandleData.meltTimerMAX;
            this.startupFlag = true;
            for (int i = 0; i < 4; ++i) {
                CandleData candleData3 = (CandleData)this.candles.get(i);
                if (!candleData3.returnToBlock) continue;
                candleData3.moveInstantlyToTarget();
            }
        }
        this.setOffsetPos();
        if (this.f_58857_.f_46443_) {
            for (CandleData candleData4 : this.candles) {
                if (!candleData4.hasCandle || !candleData4.lit) continue;
                if (random.nextInt(40) == 0 && candleData4.getEffect() != null && candleData4.getEffect().getParticleType() != null) {
                    this.f_58857_.m_7106_((ParticleOptions)(candleData4.getEffect().getParticleType() != null ? candleData4.getEffect().getParticleType() : ParticleTypes.f_123744_), (double)((float)this.f_58858_.m_123341_() + 0.5f + candleData4.x), (double)((float)this.f_58858_.m_123342_() + 0.1875f + (float)candleData4.height / 16.0f + candleData4.y + (float)candleData4.baseHeight / 16.0f), (double)((float)this.f_58858_.m_123343_() + 0.5f + candleData4.z), (random.nextDouble() - 0.5) / 100.0, (random.nextDouble() + 0.5) * 0.015, (random.nextDouble() - 0.5) / 100.0);
                }
                if (random.nextInt(10) == 0) {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)((float)this.f_58858_.m_123341_() + 0.5f + candleData4.x), (double)((float)this.f_58858_.m_123342_() + 0.1875f + (float)candleData4.height / 16.0f + candleData4.y + (float)candleData4.baseHeight / 16.0f), (double)((float)this.f_58858_.m_123343_() + 0.5f + candleData4.z), (random.nextDouble() - 0.5) / 50.0, (random.nextDouble() + 0.5) * 0.015, (random.nextDouble() - 0.5) / 50.0);
                }
                if (random.nextInt(10) != 0) continue;
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)this.f_58858_.m_123341_() + 0.5f + candleData4.x), (double)((float)this.f_58858_.m_123342_() + 0.1875f + (float)candleData4.height / 16.0f + candleData4.y + (float)candleData4.baseHeight / 16.0f), (double)((float)this.f_58858_.m_123343_() + 0.5f + candleData4.z), (random.nextDouble() - 0.5) / 50.0, (random.nextDouble() + 0.5) * 0.045, (random.nextDouble() - 0.5) / 50.0);
            }
        } else {
            boolean shouldSync = false;
            for (CandleData candleData5 : this.candles) {
                if (!candleData5.hasCandle || !candleData5.lit) continue;
                candleData5.meltTimer -= candleData5.getMeltingSpeedMultiplier();
                if (!(candleData5.meltTimer <= 0.0f)) continue;
                candleData5.meltTimer = CandleData.meltTimerMAX;
                --candleData5.height;
                if (candleData5.height <= 0) {
                    candleData5.hasCandle = false;
                    this.updateCandleSlots();
                    BlockState blockstate = this.m_58904_().m_8055_(this.m_58899_());
                    if (!this.f_58857_.m_5776_()) {
                        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)Candle.CANDLES, (Comparable)Integer.valueOf(Math.max(1, (Integer)blockstate.m_61143_((Property)Candle.CANDLES) - 1))), 1);
                    }
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
                }
                shouldSync = true;
            }
            if (shouldSync) {
                this.sync();
            }
        }
        for (CandleData candleData6 : this.candles) {
            if (this.tickCount - candleData6.returnToBlockLastTick <= 10) continue;
            candleData6.returnToBlock = true;
        }
        if (this.candles.stream().allMatch(candleData -> !candleData.hasCandle) && this.m_58904_() != null) {
            this.m_58904_().m_46961_(this.m_58899_(), false);
        }
        this.litStateOld = (Boolean)this.m_58900_().m_61143_((Property)Candle.f_151895_);
    }

    public void setOffsetPos(int index) {
        switch (index) {
            case 0: {
                float zOffset;
                float xOffset;
                if (((CandleData)this.candles.get((int)0)).hasCandle) {
                    xOffset = 0.0f;
                    zOffset = 0.0f;
                    if (this.getNumberOfCandles() == 4) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = 0.1875f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = -0.125f;
                            zOffset = -0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = -0.125f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = 0.125f;
                            zOffset = -0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 3) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = -0.0625f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = 0.0625f;
                            zOffset = -0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = -0.1875f;
                            zOffset = -0.0625f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = 0.1875f;
                            zOffset = 0.0625f;
                        }
                    } else if (this.getNumberOfCandles() == 2) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = -0.1875f;
                            zOffset = 0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = 0.125f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = -0.125f;
                            zOffset = -0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 1) {
                        xOffset = 0.0f;
                        zOffset = 0.0f;
                    }
                    ((CandleData)this.candles.get((int)0)).xTarget = xOffset;
                    ((CandleData)this.candles.get((int)0)).yTarget = 0.0f;
                    ((CandleData)this.candles.get((int)0)).zTarget = zOffset;
                }
            }
            case 1: {
                float zOffset;
                float xOffset;
                if (((CandleData)this.candles.get((int)1)).hasCandle) {
                    xOffset = 0.0f;
                    zOffset = 0.0f;
                    if (this.getNumberOfCandles() == 4) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = -0.125f;
                            zOffset = -0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = 0.1875f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = -0.1875f;
                            zOffset = 0.125f;
                        }
                    } else if (this.getNumberOfCandles() == 3) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = 0.1875f;
                            zOffset = 0.0625f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = -0.1875f;
                            zOffset = -0.0625f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = -0.0625f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = 0.0625f;
                            zOffset = -0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 2) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = -0.1875f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = 0.1875f;
                            zOffset = -0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = -0.1875f;
                            zOffset = -0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = 0.1875f;
                            zOffset = 0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 1) {
                        xOffset = 0.0f;
                        zOffset = 0.0f;
                    }
                    ((CandleData)this.candles.get((int)1)).xTarget = xOffset;
                    ((CandleData)this.candles.get((int)1)).yTarget = 0.0f;
                    ((CandleData)this.candles.get((int)1)).zTarget = zOffset;
                }
            }
            case 2: {
                float zOffset;
                float xOffset;
                if (((CandleData)this.candles.get((int)2)).hasCandle) {
                    xOffset = 0.0f;
                    zOffset = 0.0f;
                    if (this.getNumberOfCandles() == 4) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = -0.125f;
                            zOffset = 0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = 0.125f;
                            zOffset = 0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = -0.125f;
                            zOffset = -0.125f;
                        }
                    } else if (this.getNumberOfCandles() == 3) {
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                            xOffset = -0.125f;
                            zOffset = -0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                            xOffset = 0.125f;
                            zOffset = 0.1875f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                            xOffset = -0.1875f;
                            zOffset = 0.125f;
                        }
                    }
                    ((CandleData)this.candles.get((int)2)).xTarget = xOffset;
                    ((CandleData)this.candles.get((int)2)).yTarget = 0.0f;
                    ((CandleData)this.candles.get((int)2)).zTarget = zOffset;
                }
            }
            case 3: {
                if (!((CandleData)this.candles.get((int)3)).hasCandle) break;
                float xOffset = 0.0f;
                float zOffset = 0.0f;
                if (this.getNumberOfCandles() == 4) {
                    if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                        xOffset = 0.1875f;
                        zOffset = -0.125f;
                    }
                    if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                        xOffset = -0.1875f;
                        zOffset = 0.125f;
                    }
                    if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                        xOffset = -0.125f;
                        zOffset = -0.1875f;
                    }
                    if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                        xOffset = 0.125f;
                        zOffset = 0.1875f;
                    }
                }
                ((CandleData)this.candles.get((int)3)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)3)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)3)).zTarget = zOffset;
            }
        }
    }

    public void setOffsetPos() {
        this.setOffsetPos(false);
    }

    public void setOffsetPos(boolean force) {
        float zOffset;
        float xOffset;
        if (((CandleData)this.candles.get((int)0)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = -0.125f;
                    zOffset = -0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = -0.125f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = 0.125f;
                    zOffset = -0.1875f;
                }
            } else if (this.getNumberOfCandles() == 3) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = -0.0625f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = 0.0625f;
                    zOffset = -0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = -0.1875f;
                    zOffset = -0.0625f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = 0.1875f;
                    zOffset = 0.0625f;
                }
            } else if (this.getNumberOfCandles() == 2) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = 0.125f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
            } else if (this.getNumberOfCandles() == 1) {
                xOffset = 0.0f;
                zOffset = 0.0f;
            }
            if (((CandleData)this.candles.get((int)0)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)0)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)0)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)0)).zTarget = zOffset;
            }
        }
        if (((CandleData)this.candles.get((int)1)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = 0.1875f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
            } else if (this.getNumberOfCandles() == 3) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = 0.0625f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = -0.1875f;
                    zOffset = -0.0625f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = -0.0625f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = 0.0625f;
                    zOffset = -0.1875f;
                }
            } else if (this.getNumberOfCandles() == 2) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = -0.1875f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = -0.1875f;
                    zOffset = -0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = 0.1875f;
                    zOffset = 0.1875f;
                }
            } else if (this.getNumberOfCandles() == 1) {
                xOffset = 0.0f;
                zOffset = 0.0f;
            }
            if (((CandleData)this.candles.get((int)1)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)1)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)1)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)1)).zTarget = zOffset;
            }
        }
        if (((CandleData)this.candles.get((int)2)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = -0.125f;
                    zOffset = 0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = 0.125f;
                    zOffset = 0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = -0.125f;
                    zOffset = -0.125f;
                }
            } else if (this.getNumberOfCandles() == 3) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = 0.125f;
                    zOffset = 0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
            }
            if (((CandleData)this.candles.get((int)2)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)2)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)2)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)2)).zTarget = zOffset;
            }
        }
        if (((CandleData)this.candles.get((int)3)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
                if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                    xOffset = 0.125f;
                    zOffset = 0.1875f;
                }
            }
            if (((CandleData)this.candles.get((int)3)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)3)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)3)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)3)).zTarget = zOffset;
            }
        }
    }

    public void updateCandleSlots() {
        if (!((CandleData)this.candles.get((int)0)).hasCandle) {
            this.updateCandleSlot(0);
        }
        if (!((CandleData)this.candles.get((int)1)).hasCandle) {
            this.updateCandleSlot(1);
        }
        if (!((CandleData)this.candles.get((int)2)).hasCandle) {
            this.updateCandleSlot(2);
        }
    }

    public void updateCandleSlot(int slot) {
        CandleData newData = new CandleData();
        newData.load(((CandleData)this.candles.get(slot + 1)).save());
        this.candles.set(slot, (Object)newData);
        this.candles.set(slot + 1, (Object)new CandleData());
    }
}

