/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import java.util.Map;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class BookOfShadowsAltarRenderer
implements BlockEntityRenderer<BookOfShadowsAltarTile> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = this.minecraft.m_91291_();

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20185_() - (double)pos.m_123341_();
        double deltaY = entity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = entity.m_20189_() - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @OnlyIn(value=Dist.CLIENT)
    public void render(BookOfShadowsAltarTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ResourceLocation loc;
        if (!tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_()).m_155947_()) return;
        if (!(tileEntityIn.m_58904_().m_7702_(tileEntityIn.m_58899_()) instanceof BookOfShadowsAltarTile)) {
            return;
        }
        ItemStack stack = tileEntityIn.itemHandler.getStackInSlot(0);
        if (stack.m_41720_() instanceof HexereiBookItem) {
            CompoundTag tag;
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            if (tileEntityIn.degreesOpenedRender != 90.0f) {
                try {
                    tileEntityIn.drawing.drawPages(tileEntityIn, matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, combinedOverlayIn, partialTicks);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.5f, 1.125f, 0.5f);
            matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.m_252880_((float)Math.sin((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f) / 32.0f, 0.0f, (float)Math.cos((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(tileEntityIn.degreesOpenedRender));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-tileEntityIn.degreesFloppedRender));
            matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -0.5f * (tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, (float)Math.sin(tileEntityIn.degreesFloppedRender / 57.1f) / 32.0f);
            DyeColor col = HexereiUtil.getDyeColorNamed(stack.m_41786_().getString());
            this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER.get()).m_49966_(), HexereiBookItem.getColor2(stack));
            this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER_CORNERS.get()).m_49966_(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.5f, 1.125f, 0.5f);
            matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.m_252880_(-((float)Math.sin((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f)) / 32.0f, 0.0f, -((float)Math.cos((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f)) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-tileEntityIn.degreesOpenedRender));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(tileEntityIn.degreesFloppedRender));
            matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -0.5f * (tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, -((float)Math.sin(tileEntityIn.degreesFloppedRender / 57.1f)) / 32.0f);
            this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK.get()).m_49966_(), HexereiBookItem.getColor2(stack));
            this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK_CORNERS.get()).m_49966_(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.5f, 1.125f, 0.5f);
            matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
            matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
            this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BINDING.get()).m_49966_(), HexereiBookItem.getColor2(stack));
            matrixStackIn.m_85849_();
            if (tileEntityIn.degreesFloppedRender != 90.0f) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.5f, 1.125f, 0.5f);
                matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
                matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
                matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(80.0f - tileEntityIn.degreesOpenedRender / 1.12f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * -tileEntityIn.pageOneRotationRender));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (tileEntityIn.pageTwoRotationRender / 16.0f)));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).m_49966_());
                matrixStackIn.m_85849_();
            }
            if (tileEntityIn.turnPage == 1 || tileEntityIn.turnPage == -1) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.5f, 1.125f, 0.5f);
                matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
                matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
                matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(80.0f - tileEntityIn.degreesOpenedRender / 1.12f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (-tileEntityIn.pageOneRotationRender / 16.0f + 11.25f)));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).m_49966_());
                matrixStackIn.m_85849_();
            }
            if (tileEntityIn.degreesFloppedRender != 90.0f) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.5f, 1.125f, 0.5f);
                matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
                matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
                matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f)));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * -tileEntityIn.pageTwoRotationRender));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (tileEntityIn.pageOneRotationRender / 16.0f)));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).m_49966_());
                matrixStackIn.m_85849_();
            }
            if (tileEntityIn.turnPage == 2 || tileEntityIn.turnPage == -1) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.5f, 1.125f, 0.5f);
                matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
                matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
                matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f)));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (-tileEntityIn.pageTwoRotationRender / 16.0f + 11.25f)));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).m_49966_());
                matrixStackIn.m_85849_();
            }
            if ((tag = stack.m_41784_()).m_128471_("opened") || tileEntityIn.degreesFlopped != 90.0f) {
                if (tileEntityIn.degreesFlopped == 0.0f) {
                    tileEntityIn.degreesSpunRender = tileEntityIn.drawing.moveToAngle(tileEntityIn.degreesSpun, tileEntityIn.degreesSpunTo, tileEntityIn.degreesSpunSpeed * partialTicks);
                }
                tileEntityIn.buttonScaleRender = tileEntityIn.drawing.moveToAngle(tileEntityIn.buttonScale, tileEntityIn.buttonScaleTo, tileEntityIn.buttonScaleSpeed * partialTicks);
                tileEntityIn.degreesOpenedRender = tileEntityIn.drawing.moveToAngle(tileEntityIn.degreesOpened, tileEntityIn.degreesOpenedTo, tileEntityIn.degreesOpenedSpeed * partialTicks);
                tileEntityIn.degreesFloppedRender = tileEntityIn.drawing.moveToAngle(tileEntityIn.degreesFlopped, tileEntityIn.degreesFloppedTo, tileEntityIn.degreesFloppedSpeed * partialTicks);
            }
            buffer.m_109911_();
            if (tileEntityIn.degreesOpenedRender == 90.0f) return;
            try {
                buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                tileEntityIn.drawing.drawTooltips(tileEntityIn, matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, combinedOverlayIn, partialTicks);
                return;
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return;
            }
        }
        if (stack.m_41619_()) return;
        FlowerPotBlock block = (FlowerPotBlock)Blocks.f_50276_;
        Map map = block.getFullPotsView();
        BlockState blockState = map.getOrDefault(loc = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), () -> Blocks.f_50016_).get().m_49966_();
        if (!blockState.m_60795_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.1875f, 1.015625f, 0.1875f);
            matrixStackIn.m_85837_(Math.cos((float)blockState.m_60734_().toString().length() * 14.0f) / 4.0, 0.0, Math.sin((float)blockState.m_60734_().toString().length() * 14.0f) / 4.0);
            matrixStackIn.m_85841_(0.65f, 0.65f, 0.65f);
            this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, blockState);
            matrixStackIn.m_85849_();
            return;
        }
        BakedModel itemModel = this.itemRenderer.m_174264_(stack, tileEntityIn.m_58904_(), null, 0);
        boolean is3dModel = itemModel.m_7539_();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (is3dModel) {
                matrixStackIn.m_252880_(0.5f, 1.171875f, 0.5f);
                matrixStackIn.m_85841_(0.65f, 0.65f, 0.65f);
                this.renderItem(stack, tileEntityIn.m_58904_(), matrixStackIn, bufferIn, combinedLightIn);
                return;
            }
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.5f, 1.015625f, 0.5f);
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_85841_(0.45f, 0.45f, 0.45f);
        this.renderItem(stack, tileEntityIn.m_58904_(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

