/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.model.CandleModel;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.data.candle.PotionCandleEffect;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.DynamicTextureHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class CandleRenderer
implements BlockEntityRenderer<CandleTile> {
    CandleModel herbLayer;
    CandleModel glowLayer;
    CandleModel swirlLayer;
    CandleModel candleModel;
    CandleModel baseModel;

    /*
     * Unable to fully structure code
     */
    public void render(CandleTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_()).m_155947_() || !(tileEntityIn.m_58904_().m_7702_(tileEntityIn.m_58899_()) instanceof CandleTile)) {
            return;
        }
        if (this.herbLayer == null) {
            this.herbLayer = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_HERB_LAYER));
        }
        if (this.glowLayer == null) {
            this.glowLayer = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_GLOW_LAYER));
        }
        if (this.swirlLayer == null) {
            this.swirlLayer = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_SWIRL_LAYER));
        }
        if (this.candleModel == null) {
            this.candleModel = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_LAYER));
        }
        if (this.baseModel == null) {
            this.baseModel = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_BASE_LAYER));
        }
        for (CandleData candleData : tileEntityIn.candles) {
            candleData.baseHeight = 0;
            if (!candleData.hasCandle || !candleData.hasBase()) continue;
            matrixStackIn.m_85836_();
            this.translate(matrixStackIn, candleData, partialTicks, (Direction)tileEntityIn.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
            if (candleData.base.layerFromBlockLocation) {
                holder = ForgeRegistries.BLOCKS.getHolder(candleData.base.layer);
                if (holder.isPresent()) {
                    blockState = ((Block)((Holder)holder.get()).get()).m_49966_();
                    loc = new ResourceLocation("hexerei", "candle_base/" + candleData.base.layer.m_135815_());
                    if (DynamicTextureHandler.textures.containsKey(loc)) {
                        baseSprite = DynamicTextureHandler.textures.get(loc);
                        vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
                        CandleRenderer.renderCube(matrixStackIn, vertexConsumer2, baseSprite.width, baseSprite.height, baseSprite.width, 16.0f, 16.0f, combinedLightIn, combinedOverlayIn);
                        candleData.baseHeight = baseSprite.height;
                    } else {
                        DynamicTextureHandler.addNewSprite(loc, blockState);
                    }
                } else {
                    candleData.baseHeight = 2;
                    vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)MissingTextureAtlasSprite.m_118071_()));
                    CandleRenderer.renderCube(matrixStackIn, vertexConsumer2, 3.0f, candleData.baseHeight, 3.0f, 16.0f, 16.0f, combinedLightIn, combinedOverlayIn);
                }
            } else {
                candleData.baseHeight = 1;
                vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)candleData.base.layer));
                CandleRenderer.renderCube(matrixStackIn, vertexConsumer2, 3.0f, candleData.baseHeight, 3.0f, 16.0f, 16.0f, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.m_85849_();
        }
        for (CandleData candleData : tileEntityIn.candles) {
            if (!candleData.hasCandle) continue;
            matrixStackIn.m_85836_();
            this.translate(matrixStackIn, candleData, partialTicks, (Direction)tileEntityIn.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
            matrixStackIn.m_252880_(0.0f, 1.4375f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            col = HexereiUtil.rgbIntToFloatArray(candleData.dyeColor);
            matrixStackIn.m_252880_(0.0f, (float)(-candleData.baseHeight) / 16.0f, 0.0f);
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("hexerei", "textures/block/candle.png")));
            if (candleData.height != 0 && candleData.height <= 7) {
                this.candleModel.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer, combinedLightIn, OverlayTexture.f_118083_, col[0], col[1], col[2], 1.0f);
            }
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, (float)(7 - candleData.height) / 16.0f, 0.0f);
            this.candleModel.wick.m_104306_(matrixStackIn, vertexConsumer, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85849_();
        }
        for (CandleData candleData : tileEntityIn.candles) {
            if (!candleData.hasCandle || !candleData.hasHerb()) continue;
            matrixStackIn.m_85836_();
            this.translate(matrixStackIn, candleData, partialTicks, (Direction)tileEntityIn.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
            matrixStackIn.m_252880_(0.0f, 1.4375f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            col = HexereiUtil.rgbIntToFloatArray(candleData.dyeColor);
            matrixStackIn.m_252880_(0.0f, (float)(-candleData.baseHeight) / 16.0f, 0.0f);
            if (candleData.height != 0 && candleData.height <= 7) {
                if (candleData.herb.layerFromBlockLocation) {
                    holder = ForgeRegistries.BLOCKS.getHolder(candleData.herb.layer);
                    if (holder.isPresent() && (sprite = CandleRenderer.getFirstSprite(blockState = ((Block)((Holder)holder.get()).get()).m_49966_())) != null) {
                        vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)new ResourceLocation(sprite.m_245424_().m_246162_().m_135827_() + ":textures/" + sprite.m_245424_().m_246162_().m_135815_() + ".png")));
                        this.herbLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                } else {
                    vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)candleData.herb.layer));
                    this.herbLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.75f);
                }
            }
            matrixStackIn.m_85849_();
        }
        for (CandleData candleData : tileEntityIn.candles) {
            block36: {
                block35: {
                    if (!candleData.hasCandle || !candleData.hasGlow()) continue;
                    matrixStackIn.m_85836_();
                    this.translate(matrixStackIn, candleData, partialTicks, (Direction)tileEntityIn.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
                    matrixStackIn.m_252880_(0.0f, 1.4375f, 0.0f);
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    col = HexereiUtil.rgbIntToFloatArray(candleData.dyeColor);
                    matrixStackIn.m_252880_(0.0f, (float)(-candleData.baseHeight) / 16.0f, 0.0f);
                    if (!candleData.glow.layerFromBlockLocation) break block35;
                    holder = ForgeRegistries.BLOCKS.getHolder(candleData.glow.layer);
                    if (!holder.isPresent() || (sprite = CandleRenderer.getFirstSprite(blockState = ((Block)((Holder)holder.get()).get()).m_49966_())) == null) break block36;
                    vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)new ResourceLocation(sprite.m_245424_().m_246162_().m_135827_() + ":textures/" + sprite.m_245424_().m_246162_().m_135815_() + ".png")));
                    var15_23 = candleData.effect;
                    if (!(var15_23 instanceof PotionCandleEffect)) ** GOTO lbl-1000
                    potionCandleEffect = (PotionCandleEffect)var15_23;
                    if (potionCandleEffect.effect != null) {
                        color = potionCandleEffect.effect.m_19484_();
                        col2 = HexereiUtil.rgbIntToFloatArray(color);
                        if (candleData.height != 0 && candleData.height <= 7) {
                            this.glowLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, col2[0], col2[1], col2[2], 0.75f);
                        }
                    } else if (candleData.height != 0 && candleData.height <= 7) {
                        this.glowLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.75f);
                    }
                    break block36;
                }
                vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)candleData.glow.layer));
                sprite = candleData.effect;
                if (!(sprite instanceof PotionCandleEffect)) ** GOTO lbl-1000
                potionCandleEffect = (PotionCandleEffect)sprite;
                if (potionCandleEffect.effect != null) {
                    color = potionCandleEffect.effect.m_19484_();
                    col2 = HexereiUtil.rgbIntToFloatArray(color);
                    if (candleData.height != 0 && candleData.height <= 7) {
                        this.glowLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, col2[0], col2[1], col2[2], 0.75f);
                    }
                } else if (candleData.height != 0 && candleData.height <= 7) {
                    this.glowLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.75f);
                }
            }
            matrixStackIn.m_85849_();
        }
        for (CandleData candleData : tileEntityIn.candles) {
            if (!candleData.hasCandle || !candleData.hasSwirl()) continue;
            matrixStackIn.m_85836_();
            this.translate(matrixStackIn, candleData, partialTicks, (Direction)tileEntityIn.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
            matrixStackIn.m_252880_(0.0f, 1.4375f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStackIn.m_252880_(0.0f, (float)(-candleData.baseHeight) / 16.0f, 0.0f);
            col = HexereiUtil.rgbIntToFloatArray(candleData.dyeColor);
            if (candleData.swirl.layerFromBlockLocation) {
                holder = ForgeRegistries.BLOCKS.getHolder(candleData.swirl.layer);
                if (holder.isPresent() && (sprite = CandleRenderer.getFirstSprite(blockState = ((Block)((Holder)holder.get()).get()).m_49966_())) != null) {
                    offset = Hexerei.getClientTicksWithoutPartial() + Minecraft.m_91087_().m_91296_();
                    vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)new ResourceLocation(sprite.m_245424_().m_246162_().m_135827_() + ":textures/" + sprite.m_245424_().m_246162_().m_135815_() + ".png"), (float)(offset * 0.01f % 1.0f), (float)(offset * 0.01f % 1.0f)));
                    if (candleData.height != 0 && candleData.height <= 7) {
                        this.swirlLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, col[0], col[1], col[2], 0.75f);
                    }
                }
            } else {
                offset = Hexerei.getClientTicksWithoutPartial() + Minecraft.m_91087_().m_91296_();
                vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)candleData.swirl.layer, (float)(offset * 0.01f % 1.0f), (float)(offset * 0.01f % 1.0f)));
                if (candleData.height != 0 && candleData.height <= 7) {
                    this.swirlLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, col[0], col[1], col[2], 0.75f);
                }
            }
            matrixStackIn.m_85849_();
        }
    }

    private void translate(PoseStack poseStack, CandleData candleData, float partialTicks, Direction facing) {
        poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        poseStack.m_252880_(Mth.m_14179_((float)partialTicks, (float)candleData.xO, (float)candleData.x), Mth.m_14179_((float)partialTicks, (float)candleData.yO, (float)candleData.y), Mth.m_14179_((float)partialTicks, (float)candleData.zO, (float)candleData.z));
        if (facing == Direction.EAST) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else if (facing == Direction.WEST) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    public static void renderCube(PoseStack poseStack, VertexConsumer vertexConsumer, float xSize, float ySize, float zSize, float texWidth, float texHeight, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -6.25E-4f, 0.0f);
        poseStack.m_85841_(0.065f, 0.065f, 0.065f);
        float xOffset = xSize / 2.0f;
        float yOffset = ySize;
        float zOffset = zSize / 2.0f;
        float uT0 = 0.0f;
        float uT1 = uT0 + xSize / texWidth;
        float vT0 = 0.0f;
        float vT1 = vT0 + xSize / texWidth;
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, yOffset, -zOffset, uT0, vT0, 0.0f, 1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, yOffset, -zOffset, uT0, vT1, 0.0f, 1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, yOffset, zOffset, uT1, vT1, 0.0f, 1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, yOffset, zOffset, uT1, vT0, 0.0f, 1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        float uB0 = xSize / texWidth;
        float uB1 = uB0 + xSize / texWidth;
        float vB0 = 0.0f;
        float vB1 = vB0 + xSize / texWidth;
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, 0.0f, zOffset, uB0, vB0, 0.0f, -1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, 0.0f, -zOffset, uB1, vB0, 0.0f, -1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, 0.0f, -zOffset, uB1, vB1, 0.0f, -1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, 0.0f, zOffset, uB0, vB1, 0.0f, -1.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        float uN0 = 0.0f;
        float uN1 = uN0 + ySize / texWidth;
        float vN0 = xSize / texWidth;
        float vN1 = xSize / texWidth + xSize / texWidth;
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, 0.0f, -zOffset, uN1, vN1, 0.0f, 0.0f, -1.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, 0.0f, -zOffset, uN1, vN0, 0.0f, 0.0f, -1.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, yOffset, -zOffset, uN0, vN0, 0.0f, 0.0f, -1.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, yOffset, -zOffset, uN0, vN1, 0.0f, 0.0f, -1.0f, combinedLightIn, combinedOverlayIn);
        float uS0 = ySize / texWidth;
        float uS1 = uS0 + ySize / texWidth;
        float vS0 = xSize / texWidth;
        float vS1 = vS0 + xSize / texWidth;
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, 0.0f, zOffset, uS1, vS0, 0.0f, 0.0f, 1.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, 0.0f, zOffset, uS1, vS1, 0.0f, 0.0f, 1.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, yOffset, zOffset, uS0, vS1, 0.0f, 0.0f, 1.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, yOffset, zOffset, uS0, vS0, 0.0f, 0.0f, 1.0f, combinedLightIn, combinedOverlayIn);
        float uW0 = 0.0f;
        float uW1 = uW0 + ySize / texWidth;
        float vW0 = xSize / texWidth + xSize / texWidth;
        float vW1 = vW0 + xSize / texWidth;
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, 0.0f, -zOffset, uW1, vW0, -1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, 0.0f, zOffset, uW1, vW1, -1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, yOffset, zOffset, uW0, vW1, -1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, -xOffset, yOffset, -zOffset, uW0, vW0, -1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        float uE0 = ySize / texWidth;
        float uE1 = uE0 + ySize / texWidth;
        float vE0 = xSize / texWidth + xSize / texWidth;
        float vE1 = vE0 + xSize / texWidth;
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, 0.0f, -zOffset, uE1, vE1, 1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, 0.0f, zOffset, uE1, vE0, 1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, yOffset, zOffset, uE0, vE0, 1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        CandleRenderer.addVertex(vertexConsumer, poseStack, xOffset, yOffset, -zOffset, uE0, vE1, 1.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn);
        poseStack.m_85849_();
    }

    private static void addVertex(VertexConsumer vertexConsumer, PoseStack poseStack, float x, float y, float z, float u, float v, float nx, float ny, float nz, int combinedLightIn, int combinedOverlayIn) {
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_252939_(poseStack.m_85850_().m_252943_(), nx, ny, nz).m_5752_();
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }

    public static TextureAtlasSprite getFirstSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel model = minecraft.m_91304_().m_119430_().m_110893_(blockState);
        for (Direction direction : Direction.values()) {
            List quads = model.m_213637_(blockState, direction, RandomSource.m_216327_());
            if (quads.isEmpty()) continue;
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        List unculledQuads = model.m_213637_(blockState, null, RandomSource.m_216327_());
        if (!unculledQuads.isEmpty()) {
            return ((BakedQuad)unculledQuads.get(0)).m_173410_();
        }
        return null;
    }

    public static NativeImage modifyTexture(NativeImage originalImage) {
        int width = originalImage.m_84982_();
        int height = originalImage.m_85084_();
        NativeImage newImage = new NativeImage(width, height, true);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = originalImage.m_84985_(x, y);
                int invertedColor = ~color | color & 0xFF000000;
                newImage.m_84988_(x, y, invertedColor);
            }
        }
        return newImage;
    }
}

