/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class DynamicTextureHandler {
    public static FileToIdConverter TEXTURE_ID_CONVERTER = new FileToIdConverter("textures", ".png");
    public static Map<ResourceLocation, DynamicBaseSprite> textures = new HashMap<ResourceLocation, DynamicBaseSprite>();

    public static DynamicBaseSprite addNewSprite(ResourceLocation location, BlockState state) {
        TextureAtlasSprite sprite = DynamicTextureHandler.getFirstSprite(state);
        if (sprite != null && !textures.containsKey(location)) {
            try {
                NativeImage image = sprite.m_245424_().getOriginalImage();
                AnimationMetadataSection metadata = DynamicTextureHandler.getAnimationMetadata(sprite.m_245424_().m_246162_());
                FrameSize frameSize = metadata.m_245821_(image.m_84982_(), image.m_85084_());
                int scale = 2;
                int width = 3;
                int height = 2;
                Tuple<NativeImage, Map<Direction, Integer>> tuple = DynamicTextureHandler.createCubeTexture(state, frameSize, sprite, scale, width, height);
                DynamicBaseSprite baseSprite = new DynamicBaseSprite((NativeImage)tuple.m_14418_(), location, scale, width, height);
                textures.put(location, baseSprite);
                Minecraft.m_91087_().m_91097_().m_118495_(location, (AbstractTexture)baseSprite);
                return baseSprite;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Tuple<NativeImage, Map<Direction, Integer>> createCubeTexture(BlockState state, FrameSize frameSize, TextureAtlasSprite defaultSprite, int texScale, int width, int height) {
        HashMap<Direction, Integer> tintIndex = new HashMap<Direction, Integer>();
        for (Direction dir : Direction.values()) {
            tintIndex.put(dir, -1);
        }
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state);
        FrameSize oldFrameSize = frameSize;
        frameSize = new FrameSize(frameSize.f_244129_() * texScale, frameSize.f_244503_() * texScale);
        NativeImage newImage = new NativeImage(frameSize.f_244129_(), frameSize.f_244503_(), true);
        int currentY = 0;
        int scale = (int)((float)frameSize.f_244129_() / 16.0f);
        int rotation = 0;
        TextureAtlasSprite sprite = defaultSprite;
        Direction dir = Direction.UP;
        List list = model.m_213637_(state, dir, RandomSource.m_216327_());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).m_111303_())));
            tintIndex.put(dir, ((BakedQuad)list.get(0)).m_111305_());
        }
        list = model.m_213637_(state, null, RandomSource.m_216327_());
        for (BakedQuad quad : list) {
            if (quad.m_111306_() != dir) continue;
            sprite = quad.m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(quad.m_111303_())));
            tintIndex.put(dir, quad.m_111305_());
        }
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        int col = (Integer)tintIndex.get(dir) == -1 ? -1 : blockColors.m_92577_(state, null, null, ((Integer)tintIndex.get(dir)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.m_245424_().getOriginalImage(), oldFrameSize), newImage, 0, currentY, scale, width, width, rotation, col);
        rotation = 0;
        sprite = defaultSprite;
        dir = Direction.DOWN;
        list = model.m_213637_(state, dir, RandomSource.m_216327_());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).m_111303_())));
            tintIndex.put(dir, ((BakedQuad)list.get(0)).m_111305_());
        }
        list = model.m_213637_(state, null, RandomSource.m_216327_());
        for (BakedQuad quad : list) {
            if (quad.m_111306_() != dir) continue;
            sprite = quad.m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(quad.m_111303_())));
            tintIndex.put(dir, quad.m_111305_());
        }
        col = (Integer)tintIndex.get(dir) == -1 ? -1 : Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, ((Integer)tintIndex.get(dir)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.m_245424_().getOriginalImage(), oldFrameSize), newImage, width * scale, currentY, scale, width, width, rotation, col);
        currentY += width * scale;
        rotation = 0;
        sprite = defaultSprite;
        list = model.m_213637_(state, Direction.NORTH, RandomSource.m_216327_());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).m_111303_())));
            tintIndex.put(Direction.NORTH, ((BakedQuad)list.get(0)).m_111305_());
        }
        col = (Integer)tintIndex.get(Direction.NORTH) == -1 ? -1 : Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, ((Integer)tintIndex.get(Direction.NORTH)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.m_245424_().getOriginalImage(), oldFrameSize), newImage, 0, currentY, scale, height, width, rotation, col);
        rotation = 0;
        sprite = defaultSprite;
        list = model.m_213637_(state, Direction.SOUTH, RandomSource.m_216327_());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).m_111303_())));
            tintIndex.put(Direction.SOUTH, ((BakedQuad)list.get(0)).m_111305_());
        }
        col = (Integer)tintIndex.get(Direction.SOUTH) == -1 ? -1 : Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, ((Integer)tintIndex.get(Direction.SOUTH)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.m_245424_().getOriginalImage(), oldFrameSize), newImage, height * scale, currentY, scale, height, width, rotation, col);
        currentY += width * scale;
        rotation = 0;
        sprite = defaultSprite;
        list = model.m_213637_(state, Direction.WEST, RandomSource.m_216327_());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).m_111303_())));
            tintIndex.put(Direction.WEST, ((BakedQuad)list.get(0)).m_111305_());
        }
        col = (Integer)tintIndex.get(Direction.WEST) == -1 ? -1 : Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, ((Integer)tintIndex.get(Direction.WEST)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.m_245424_().getOriginalImage(), oldFrameSize), newImage, 0, currentY, scale, height, width, rotation, col);
        rotation = 0;
        sprite = defaultSprite;
        list = model.m_213637_(state, Direction.EAST, RandomSource.m_216327_());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).m_173410_();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).m_111303_())));
            tintIndex.put(Direction.EAST, ((BakedQuad)list.get(0)).m_111305_());
        }
        col = (Integer)tintIndex.get(Direction.EAST) == -1 ? -1 : Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, ((Integer)tintIndex.get(Direction.EAST)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.m_245424_().getOriginalImage(), oldFrameSize), newImage, height * scale, currentY, scale, height, width, rotation, col);
        return new Tuple((Object)newImage, tintIndex);
    }

    public static Vec2[] getUVs(int[] verts) {
        Vec2[] uvs = new Vec2[4];
        for (int i = 0; i < 4; ++i) {
            float u = Float.intBitsToFloat(verts[i * 8 + 4]);
            float v = Float.intBitsToFloat(verts[i * 8 + 5]);
            uvs[i] = new Vec2(u, v);
        }
        return uvs;
    }

    public static Vec2[] normalizeUVs(Vec2[] uvs) {
        float minU = Float.MAX_VALUE;
        float maxU = Float.MIN_VALUE;
        float minV = Float.MAX_VALUE;
        float maxV = Float.MIN_VALUE;
        Vec2[] returnUVs = new Vec2[4];
        for (Vec2 uv : uvs) {
            if (uv.f_82470_ < minU) {
                minU = uv.f_82470_;
            }
            if (uv.f_82470_ > maxU) {
                maxU = uv.f_82470_;
            }
            if (uv.f_82471_ < minV) {
                minV = uv.f_82471_;
            }
            if (!(uv.f_82471_ > maxV)) continue;
            maxV = uv.f_82471_;
        }
        for (int i = 0; i < uvs.length; ++i) {
            float normalizedU = (uvs[i].f_82470_ - minU) / (maxU - minU);
            float normalizedV = (uvs[i].f_82471_ - minV) / (maxV - minV);
            returnUVs[i] = new Vec2(normalizedU, normalizedV);
        }
        return returnUVs;
    }

    public static int detectRotation(Vec2[] uvs) {
        Vec2[] rotation0 = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f)};
        Vec2[] rotation90 = new Vec2[]{new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 0.0f)};
        Vec2[] rotation180 = new Vec2[]{new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f)};
        Vec2[] rotation270 = new Vec2[]{new Vec2(1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)};
        if (DynamicTextureHandler.matchUVs(uvs, rotation0)) {
            return 0;
        }
        if (DynamicTextureHandler.matchUVs(uvs, rotation90)) {
            return 90;
        }
        if (DynamicTextureHandler.matchUVs(uvs, rotation180)) {
            return 180;
        }
        if (DynamicTextureHandler.matchUVs(uvs, rotation270)) {
            return 270;
        }
        return -1;
    }

    private static boolean matchUVs(Vec2[] uvs, Vec2[] rotation) {
        for (int i = 0; i < uvs.length; ++i) {
            if (uvs[i].m_82476_(rotation[i])) continue;
            return false;
        }
        return true;
    }

    public static void rebuildFace(NativeImage src, NativeImage dest, int destX, int destY, int scale, int sizeX, int sizeY, int rotation, int col) {
        int gridSizeX = Math.round(sizeX * scale);
        int gridSizeY = Math.round(sizeY * scale);
        int totalPoints = gridSizeX * gridSizeY;
        float centerX = (float)gridSizeX / 2.0f;
        float centerY = (float)gridSizeY / 2.0f;
        float[][] points = new float[totalPoints][2];
        for (int y = 0; y < gridSizeY; ++y) {
            for (int x = 0; x < gridSizeX; ++x) {
                points[y * gridSizeX + x] = new float[]{x, y};
                float[] fArray = points[y * gridSizeX + x];
                fArray[0] = fArray[0] / (float)Math.max(1, gridSizeX - 1);
                float[] fArray2 = points[y * gridSizeX + x];
                fArray2[1] = fArray2[1] / (float)Math.max(1, gridSizeY - 1);
            }
        }
        for (float[] point : points) {
            int writeX = Mth.m_14045_((int)(destX + Mth.m_14143_((float)Mth.m_14036_((float)(point[0] * (float)(sizeX * scale)), (float)0.0f, (float)(sizeX * scale - 1)))), (int)0, (int)(dest.m_84982_() - 1));
            int writeY = Mth.m_14045_((int)(destY + Mth.m_14143_((float)Mth.m_14036_((float)(point[1] * (float)(sizeY * scale)), (float)0.0f, (float)(sizeY * scale - 1)))), (int)0, (int)(dest.m_85084_() - 1));
            float dx = 0.5f - point[0];
            float dy = 0.5f - point[1];
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            float offsetX = centerX / 2.0f * Math.max(0.0f, 0.8f - dist) * dx;
            float offsetY = centerY / 2.0f * Math.max(0.0f, 0.8f - dist) * dy;
            Vec2 uv1 = new Vec2(point[0], point[1]);
            Vec2 uv2 = DynamicTextureHandler.rotateUV(uv1, rotation);
            float getXf = Mth.m_14036_((float)((float)src.m_84982_() * uv2.f_82470_ + offsetX), (float)0.0f, (float)(src.m_84982_() - 1));
            float getYf = Mth.m_14036_((float)((float)src.m_85084_() * uv2.f_82471_ + offsetY), (float)0.0f, (float)(src.m_85084_() - 1));
            int getX = Mth.m_14045_((int)Mth.m_14143_((float)getYf), (int)0, (int)(src.m_84982_() - 1));
            int getY = Mth.m_14045_((int)Mth.m_14143_((float)getXf), (int)0, (int)(src.m_85084_() - 1));
            int color = src.m_84985_(getX, getY);
            float alpha = (float)((color = DynamicTextureHandler.mergeColors(col, color)) >> NativeImage.Format.RGBA.m_85172_() & 0xFF) / 255.0f;
            if (!(alpha > 0.0f)) continue;
            dest.m_84988_(writeX, writeY, color);
        }
    }

    public static int mergeColors(int col, int color) {
        if (col == -1) {
            return color;
        }
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        float newR = (float)(color >> NativeImage.Format.RGBA.m_166429_() & 0xFF) / 255.0f * r;
        float newG = (float)(color >> NativeImage.Format.RGBA.m_166430_() & 0xFF) / 255.0f * g;
        float newB = (float)(color >> NativeImage.Format.RGBA.m_166431_() & 0xFF) / 255.0f * b;
        float alpha = (float)(color >> NativeImage.Format.RGBA.m_85172_() & 0xFF) / 255.0f;
        return HexereiUtil.getColorValueAlpha(newR, newG, newB, alpha);
    }

    public static Vec2 rotateUV(Vec2 uv, int angle) {
        double radians = Math.toRadians(angle);
        float u = uv.f_82470_ - 0.5f;
        float v = uv.f_82471_ - 0.5f;
        float rotatedU = (float)((double)u * Math.cos(radians) - (double)v * Math.sin(radians));
        float rotatedV = (float)((double)u * Math.sin(radians) + (double)v * Math.cos(radians));
        return new Vec2(rotatedU += 0.5f, rotatedV += 0.5f);
    }

    public static NativeImage firstFrameTexture(NativeImage originalImage, FrameSize frameSize) {
        int width = frameSize.f_244129_();
        int height = frameSize.f_244503_();
        NativeImage newImage = new NativeImage(width, height, true);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = originalImage.m_84985_(x, y);
                newImage.m_84988_(x, y, color);
            }
        }
        return newImage;
    }

    public static AnimationMetadataSection getAnimationMetadata(ResourceLocation textureLocation) throws IOException {
        Optional optional2;
        Minecraft minecraft = Minecraft.m_91087_();
        ResourceManager resourceManager = minecraft.m_91098_();
        Optional optional = resourceManager.m_213713_(TEXTURE_ID_CONVERTER.m_245698_(textureLocation));
        AnimationMetadataSection defaultMetadata = AnimationMetadataSection.f_119012_;
        if (optional.isPresent() && (optional2 = ((Resource)optional.get()).m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_)).isPresent()) {
            return (AnimationMetadataSection)optional2.get();
        }
        return defaultMetadata;
    }

    public static TextureAtlasSprite getFirstSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel model = minecraft.m_91304_().m_119430_().m_110893_(blockState);
        for (Direction direction : Direction.values()) {
            List quads = model.m_213637_(blockState, direction, RandomSource.m_216327_());
            if (quads.isEmpty()) continue;
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        List unculledQuads = model.m_213637_(blockState, null, RandomSource.m_216327_());
        if (!unculledQuads.isEmpty()) {
            return ((BakedQuad)unculledQuads.get(0)).m_173410_();
        }
        return null;
    }

    public static BakedQuad getFirstQuad(BlockState blockState) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel model = minecraft.m_91304_().m_119430_().m_110893_(blockState);
        for (Direction direction : Direction.values()) {
            List quads = model.m_213637_(blockState, direction, RandomSource.m_216327_());
            if (quads.isEmpty()) continue;
            return (BakedQuad)quads.get(0);
        }
        List unculledQuads = model.m_213637_(blockState, null, RandomSource.m_216327_());
        if (!unculledQuads.isEmpty()) {
            return (BakedQuad)unculledQuads.get(0);
        }
        return null;
    }

    public static class DynamicBaseSprite
    extends DynamicTexture {
        public ResourceLocation location;
        public float scale;
        public int width;
        public int height;

        public DynamicBaseSprite(NativeImage image, ResourceLocation location, float scale, int width, int height) {
            super(image);
            this.location = location;
            this.scale = scale;
            this.width = width;
            this.height = height;
        }
    }
}

