/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BroomSyncRotationToServer {
    int sourceId;
    float rotation;

    public BroomSyncRotationToServer(Entity entity, float tag, Entity player) {
        this.sourceId = entity.m_19879_();
        this.rotation = tag;
    }

    public BroomSyncRotationToServer(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.rotation = buf.readFloat();
    }

    public static void encode(BroomSyncRotationToServer object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.writeFloat(object.rotation);
    }

    public static BroomSyncRotationToServer decode(FriendlyByteBuf buffer) {
        return new BroomSyncRotationToServer(buffer);
    }

    public static void consume(BroomSyncRotationToServer packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            ((BroomEntity)world.m_6815_(packet.sourceId)).setRotation(packet.rotation);
        });
        ctx.get().setPacketHandled(true);
    }
}

