/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MapDataPacket {
    private final int mapId;
    private final byte scale;
    private final boolean locked;
    @Nullable
    private final List<MapDecoration> decorations;
    @Nullable
    private final MapItemSavedData.MapPatch colorPatch;

    public MapDataPacket(int pMapId, byte pScale, boolean pLocked, @Nullable Collection<MapDecoration> pDecorations, @Nullable MapItemSavedData.MapPatch pColorPatch) {
        this.mapId = pMapId;
        this.scale = pScale;
        this.locked = pLocked;
        this.decorations = pDecorations != null ? Lists.newArrayList(pDecorations) : null;
        this.colorPatch = pColorPatch;
    }

    public MapDataPacket(FriendlyByteBuf pBuffer) {
        this.mapId = pBuffer.m_130242_();
        this.scale = pBuffer.readByte();
        this.locked = pBuffer.readBoolean();
        this.decorations = (List)pBuffer.m_236868_(p_237731_ -> p_237731_.m_236845_(p_178981_ -> {
            MapDecoration.Type mapdecoration$type = (MapDecoration.Type)p_178981_.m_130066_(MapDecoration.Type.class);
            byte b0 = p_178981_.readByte();
            byte b1 = p_178981_.readByte();
            byte b2 = (byte)(p_178981_.readByte() & 0xF);
            Component component = (Component)p_178981_.m_236868_(FriendlyByteBuf::m_130238_);
            return new MapDecoration(mapdecoration$type, b0, b1, b2, component);
        }));
        short i = pBuffer.readUnsignedByte();
        if (i > 0) {
            short j = pBuffer.readUnsignedByte();
            short k = pBuffer.readUnsignedByte();
            short l = pBuffer.readUnsignedByte();
            byte[] abyte = pBuffer.m_130052_();
            this.colorPatch = new MapItemSavedData.MapPatch((int)k, (int)l, (int)i, (int)j, abyte);
        } else {
            this.colorPatch = null;
        }
    }

    public static void encode(MapDataPacket object, FriendlyByteBuf pBuffer) {
        pBuffer.m_130130_(object.mapId);
        pBuffer.writeByte((int)object.scale);
        pBuffer.writeBoolean(object.locked);
        pBuffer.m_236821_(object.decorations, (p_237728_, p_237729_) -> p_237728_.m_236828_((Collection)p_237729_, (p_237725_, p_237726_) -> {
            p_237725_.m_130068_((Enum)p_237726_.m_77803_());
            p_237725_.writeByte((int)p_237726_.m_77804_());
            p_237725_.writeByte((int)p_237726_.m_77805_());
            p_237725_.writeByte(p_237726_.m_77806_() & 0xF);
            p_237725_.m_236821_((Object)p_237726_.m_77810_(), FriendlyByteBuf::m_130083_);
        }));
        if (object.colorPatch != null) {
            pBuffer.writeByte(object.colorPatch.f_164823_);
            pBuffer.writeByte(object.colorPatch.f_164824_);
            pBuffer.writeByte(object.colorPatch.f_164821_);
            pBuffer.writeByte(object.colorPatch.f_164822_);
            pBuffer.m_130087_(object.colorPatch.f_164825_);
        } else {
            pBuffer.writeByte(0);
        }
    }

    public static MapDataPacket decode(FriendlyByteBuf buffer) {
        return new MapDataPacket(buffer);
    }

    public static void consume(MapDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Level world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                Level world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            Minecraft minecraft = Minecraft.m_91087_();
            MapRenderer maprenderer = minecraft.f_91063_.m_109151_();
            int i = packet.getMapId();
            String s = MapItem.m_42848_((int)i);
            MapItemSavedData mapitemsaveddata = minecraft.f_91073_.m_7489_(s);
            if (mapitemsaveddata == null) {
                mapitemsaveddata = MapItemSavedData.m_164776_((byte)packet.getScale(), (boolean)packet.isLocked(), (ResourceKey)minecraft.f_91073_.m_46472_());
                minecraft.f_91073_.m_142325_(s, mapitemsaveddata);
            }
            packet.applyToMap(mapitemsaveddata);
            maprenderer.m_168765_(i, mapitemsaveddata);
        });
        ctx.get().setPacketHandled(true);
    }

    public int getMapId() {
        return this.mapId;
    }

    public void applyToMap(MapItemSavedData pMapdata) {
        if (this.decorations != null) {
            pMapdata.m_164801_(this.decorations);
        }
        if (this.colorPatch != null) {
            this.colorPatch.m_164832_(pMapdata);
        }
    }

    public byte getScale() {
        return this.scale;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

