/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.client.gui;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.networking.TeleportNexusPacket;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemStackHandler;

public class WarpNexusScreen
extends Screen {
    private final ContainerLevelAccess access;
    private final ItemStackHandler handler;
    private int maxScale;
    private float scaleFactor;
    public int leftStart;
    public int topStart = 0;

    public WarpNexusScreen(ContainerLevelAccess access, ItemStackHandler itemStackHandler) {
        super((Component)Component.m_237113_((String)"Warp Nexus"));
        this.access = access;
        this.handler = itemStackHandler;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
        this.leftStart = this.f_96543_ / 2 - 150;
        int slots = this.handler.getSlots();
        HashMap<Integer, ItemStack> filled = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < slots; ++i) {
            ItemStack scroll = this.handler.getStackInSlot(i);
            if (scroll.m_150930_(Items.f_41852_)) continue;
            filled.put(i, scroll);
        }
        if (filled.isEmpty()) {
            this.f_96541_.m_91152_(null);
            PortUtil.sendMessage((Entity)this.f_96541_.f_91074_, (Component)Component.m_237115_((String)"chat.ars_additions.warp_nexus.no_scrolls"));
            PortUtil.sendMessage((Entity)this.f_96541_.f_91074_, (Component)Component.m_237110_((String)"chat.ars_additions.warp_nexus.no_scrolls.instruction", (Object[])new Object[]{this.f_96541_.f_91066_.f_92090_.getKey().m_84875_(), this.f_96541_.f_91066_.f_92095_.getKey().m_84875_()}));
            return;
        }
        int n = this.f_96544_ / 2;
        Objects.requireNonNull(this.f_96547_);
        this.topStart = n - (16 + 9 + filled.size() * 25 + 20) / 2;
        int index = 0;
        for (Map.Entry entry : filled.entrySet()) {
            int i = (Integer)entry.getKey();
            ItemStack scroll = (ItemStack)entry.getValue();
            Objects.requireNonNull(this.f_96547_);
            this.m_142416_((GuiEventListener)new Button(this.leftStart + 50, this.topStart + 16 + 9 + index * 25, 200, 20, this.getDisplayName(scroll), button -> {
                this.access.m_39292_((_level, pos) -> TeleportNexusPacket.teleport(i, pos));
                this.f_96541_.m_91152_(null);
            }, Supplier::get){
                public static final ResourceLocation BUTTON_LOCATION = ArsAdditions.prefix("textures/gui/button.png");

                protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                    Minecraft minecraft = Minecraft.m_91087_();
                    guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                    guiGraphics.m_280027_(BUTTON_LOCATION, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 16, 4, 200, 20, 0, this.getTextureY());
                    guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                    int i = this.getFGColor();
                    this.m_280139_(guiGraphics, minecraft.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
                }

                private int getTextureY() {
                    int i = 0;
                    if (!this.f_93623_) {
                        i = 2;
                    } else if (this.m_198029_()) {
                        i = 1;
                    }
                    return i * 20;
                }
            });
            ++index;
        }
    }

    private Component getDisplayName(ItemStack stack) {
        if (stack.m_41788_()) {
            return stack.m_41786_();
        }
        StableWarpScroll.StableScrollData data = new StableWarpScroll.StableScrollData(stack);
        if (!data.isValid()) {
            return stack.m_41611_();
        }
        BlockPos pos = data.getPos();
        return Component.m_237110_((String)"tooltip.ars_additions.reliquary.marked.location", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (((Boolean)this.access.m_39299_((level, pos) -> !level.m_8055_(pos).m_60713_((Block)AddonBlockRegistry.WARP_NEXUS.get()) || this.f_96541_.f_91074_.m_20183_().m_203198_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > Math.pow(this.f_96541_.f_91074_.getBlockReach(), 2.0), (Object)true)).booleanValue()) {
            this.f_96541_.m_91152_(null);
            return;
        }
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        if (this.scaleFactor != 1.0f) {
            matrixStack.m_85841_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.renderAfterScale(guiGraphics, mouseX, mouseY, partialTick);
        matrixStack.m_85849_();
    }

    private int getMaxAllowedScale() {
        return this.f_96541_.m_91268_().m_85385_(0, this.f_96541_.m_91390_());
    }

    public void renderAfterScale(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        if (this.topStart >= 0) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"Warp Nexus"), this.f_96543_ / 2, this.topStart + 8, new Color(255, 255, 255).getRGB());
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }
}

