/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.commands;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.jetbrains.annotations.Nullable;

public class SetLootTableCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.m_82926_(GlyphRegistry.getSpellpartMap().keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctxt) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set_loot_tables").requires(sender -> sender.m_6761_(4))).then(Commands.m_82129_((String)"filter", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)ctxt)).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"loot", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(LootCommand.f_137877_).executes(context -> SetLootTableCommand.replaceLootTables((CommandContext<CommandSourceStack>)context, BlockStateArgument.m_116123_((CommandContext)context, (String)"filter"), BlockPosArgument.m_264582_((CommandContext)context, (String)"from"), BlockPosArgument.m_264582_((CommandContext)context, (String)"to"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"loot"))))))));
    }

    private static int replaceLootTables(CommandContext<CommandSourceStack> context, BlockInput filter, BlockPos from, BlockPos to, ResourceLocation loot) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        int counter = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)from, (BlockPos)to)) {
            if (!filter.test(new BlockInWorld((LevelReader)level, pos, true))) continue;
            BlockState bs = level.m_8055_(pos);
            BlockEntity be = level.m_7702_(pos);
            CompoundTag tag = be.m_187480_();
            tag.m_128359_("LootTable", loot.toString());
            be.m_142466_(tag);
            be.m_6596_();
            be.m_58904_().m_7260_(pos, bs, bs, 3);
            ++counter;
        }
        if (((CommandSourceStack)context.getSource()).m_230896_() != null) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            player.m_213846_((Component)Component.m_237113_((String)("Updated " + counter + " loot tables")));
        }
        return 1;
    }

    private static int learnGlyph(CommandSourceStack source, Collection<ServerPlayer> players, @Nullable ResourceLocation glyph) {
        if (source.m_230896_() == null) {
            return 0;
        }
        for (ServerPlayer player : players) {
            IPlayerCap playerCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)player).orElse(null);
            if (glyph == null) {
                if (playerCap == null) continue;
                playerCap.setKnownGlyphs(GlyphRegistry.getSpellpartMap().values().stream().filter(g -> !g.defaultedStarterGlyph()).toList());
                player.m_213846_((Component)Component.m_237113_((String)"Unlocked all glyphs"));
            } else {
                AbstractSpellPart spellPart = GlyphRegistry.getSpellPart((ResourceLocation)glyph);
                if (spellPart.defaultedStarterGlyph()) continue;
                boolean learned = playerCap.unlockGlyph(spellPart);
                if (learned) {
                    player.m_213846_((Component)Component.m_237113_((String)("Unlocked " + spellPart.getName())));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Glyph already known"));
                }
            }
            CapabilityRegistry.EventHandler.syncPlayerCap((Player)player);
        }
        return 1;
    }
}

