/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.SourceSpawnerRecipe;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.github.jarva.arsadditions.common.util.codec.TagModifier;
import com.github.jarva.arsadditions.setup.registry.ModifyTagRegistry;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.entity.EntityType;

public class SourceSpawnerProvider
extends SimpleDataProvider {
    public List<SourceSpawnerRecipe> recipes = new ArrayList<SourceSpawnerRecipe>();

    public SourceSpawnerProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (SourceSpawnerRecipe recipe : this.recipes) {
            Path path = SourceSpawnerProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, recipe.asRecipe(), path);
        }
    }

    protected void addEntries() {
        this.addEntry("default", new ModifyTagRegistry.RemoveGuaranteedHandDrops(), new ModifyTagRegistry.RemoveTag(List.of("Inventory")));
    }

    private void addEntry(String id, EntityType<?> entityType, TagModifier ... tagModifiers) {
        this.addEntry(id, Optional.of(ResourceOrTag.key(entityType.m_204041_().m_205785_())), Optional.empty(), Optional.of(List.of(tagModifiers)));
    }

    private void addEntry(String id, TagModifier ... tagModifiers) {
        this.addEntry(id, Optional.empty(), Optional.empty(), Optional.of(List.of(tagModifiers)));
    }

    private void addEntry(String id, Optional<ResourceOrTag<EntityType<?>>> entity, Optional<Integer> source, Optional<List<TagModifier>> tagModifiers) {
        this.recipes.add(new SourceSpawnerRecipe(ArsAdditions.prefix(id), entity, source, tagModifiers));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipes/source_spawner/" + id + ".json");
    }

    public String m_6055_() {
        return "Source Spawner Datagen";
    }
}

