/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.common.item.AdvancedDominionWand;
import com.github.jarva.arsadditions.common.item.CodexEntry;
import com.github.jarva.arsadditions.common.item.CodexEntryAncient;
import com.github.jarva.arsadditions.common.item.CodexEntryLost;
import com.github.jarva.arsadditions.common.item.ExplorationWarpScroll;
import com.github.jarva.arsadditions.common.item.HandyHaversack;
import com.github.jarva.arsadditions.common.item.ImbuedSpellParchment;
import com.github.jarva.arsadditions.common.item.NexusWarpScroll;
import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.common.item.Wayfinder;
import com.github.jarva.arsadditions.common.item.XPJar;
import com.github.jarva.arsadditions.common.item.curios.Charm;
import com.github.jarva.arsadditions.common.item.curios.StabilizedWarpIndex;
import com.github.jarva.arsadditions.common.item.curios.WarpIndex;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AddonItemRegistry {
    public static final List<RegistryObject<Item>> REGISTERED_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final List<RegistryObject<Item>> DATAGEN_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ars_additions");
    public static final RegistryObject<Item> LECTERN_REMOTE;
    public static final RegistryObject<Item> ADVANCED_LECTERN_REMOTE;
    public static final RegistryObject<Item> CODEX_ENTRY;
    public static final RegistryObject<Item> CODEX_ENTRY_LOST;
    public static final RegistryObject<Item> CODEX_ENTRY_ANCIENT;
    public static final RegistryObject<Item> UNSTABLE_RELIQUARY;
    public static final RegistryObject<Item> EXPLORATION_WARP_SCROLL;
    public static final RegistryObject<Item> NEXUS_WARP_SCROLL;
    public static final RegistryObject<Item> XP_JAR;
    public static final RegistryObject<Item> HANDY_HAVERSACK;
    public static final RegistryObject<Item> ADVANCED_DOMINION_WAND;
    public static final RegistryObject<Item> WAYFINDER;
    public static final RegistryObject<Item> IMBUED_SPELL_PARCHMENT;
    public static final HashMap<CharmRegistry.CharmType, RegistryObject<Item>> CHARMS;

    private static void registerCharms() {
        for (CharmRegistry.CharmType charm : CharmRegistry.CharmType.values()) {
            CHARMS.put(charm, AddonItemRegistry.register(charm.m_7912_(), () -> new Charm(charm.getCharges())));
        }
    }

    private static RegistryObject<Item> register(String name, Supplier<Item> item) {
        return AddonItemRegistry.register(name, item, true);
    }

    private static RegistryObject<Item> register(String name, Supplier<Item> item, boolean dataGen) {
        RegistryObject registered = ITEMS.register(name, item);
        REGISTERED_ITEMS.add((RegistryObject<Item>)registered);
        if (dataGen) {
            DATAGEN_ITEMS.add((RegistryObject<Item>)registered);
        }
        return registered;
    }

    public static Item.Properties defaultItemProperties() {
        return new Item.Properties();
    }

    static {
        CHARMS = new HashMap();
        LECTERN_REMOTE = AddonItemRegistry.register("warp_index", WarpIndex::new);
        ADVANCED_LECTERN_REMOTE = AddonItemRegistry.register("stabilized_warp_index", StabilizedWarpIndex::new);
        CODEX_ENTRY = AddonItemRegistry.register("codex_entry", CodexEntry::new);
        CODEX_ENTRY_LOST = AddonItemRegistry.register("lost_codex_entry", CodexEntryLost::new);
        CODEX_ENTRY_ANCIENT = AddonItemRegistry.register("ancient_codex_entry", CodexEntryAncient::new);
        UNSTABLE_RELIQUARY = AddonItemRegistry.register("unstable_reliquary", UnstableReliquary::new);
        EXPLORATION_WARP_SCROLL = AddonItemRegistry.register("exploration_warp_scroll", ExplorationWarpScroll::new);
        NEXUS_WARP_SCROLL = AddonItemRegistry.register("nexus_warp_scroll", NexusWarpScroll::new);
        XP_JAR = AddonItemRegistry.register("xp_jar", XPJar::new);
        HANDY_HAVERSACK = AddonItemRegistry.register("handy_haversack", HandyHaversack::new, false);
        ADVANCED_DOMINION_WAND = AddonItemRegistry.register("advanced_dominion_wand", AdvancedDominionWand::new);
        WAYFINDER = AddonItemRegistry.register("wayfinder", Wayfinder::new, false);
        IMBUED_SPELL_PARCHMENT = AddonItemRegistry.register("imbued_spell_parchment", ImbuedSpellParchment::new);
        AddonItemRegistry.registerCharms();
    }
}

