/*
 * Decompiled with CFR 0.152.
 */
package nanonestor.cursedearth;

import nanonestor.cursedearth.BlessedEarthBlock;
import nanonestor.cursedearth.BlessedFlowerBlock;
import nanonestor.cursedearth.CursedEarthBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="cursedearth")
public class CursedEarth {
    public static final String MODID = "cursedearth";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"cursedearth");
    public static final RegistryObject<CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("cursed_earth", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257941_(Component.m_130674_((String)"Cursed Earth")).m_257737_(() -> CursedEarthBlock.cursed_earth_item.m_7968_()).m_257501_((parameters, output) -> {
        output.m_246342_(CursedEarthBlock.cursed_earth_item.m_7968_());
        output.m_246342_(BlessedEarthBlock.blessed_earth_item.m_7968_());
        output.m_246342_(BlessedFlowerBlock.blessed_flower_item.m_7968_());
    }).m_257652_());
    public static final TagKey<EntityType<?>> blacklisted_entities = CursedEarth.create(new ResourceLocation("cursedearth", "blacklisted"));
    public static final TagKey<Block> spreadable = BlockTags.create((ResourceLocation)new ResourceLocation("cursedearth", "spreadable"));
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    private static TagKey<EntityType<?>> create(ResourceLocation p_203849_) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)p_203849_);
    }

    public CursedEarth() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(this::onClientSetup);
        }
        modEventBus.addListener(this::blocks);
        MinecraftForge.EVENT_BUS.addListener(this::rose);
        CREATIVE_MODE_TABS.register(modEventBus);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)CursedEarthBlock.cursed_earth, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)BlessedEarthBlock.blessed_earth, (RenderType)RenderType.m_110463_());
    }

    public void blocks(RegisterEvent event) {
        event.register(Registries.f_256747_, new ResourceLocation(MODID, "cursed_earth"), () -> CursedEarthBlock.cursed_earth);
        event.register(Registries.f_256913_, new ResourceLocation(MODID, "cursed_earth"), () -> CursedEarthBlock.cursed_earth_item);
        event.register(Registries.f_256747_, new ResourceLocation(MODID, "blessed_earth"), () -> BlessedEarthBlock.blessed_earth);
        event.register(Registries.f_256913_, new ResourceLocation(MODID, "blessed_earth"), () -> BlessedEarthBlock.blessed_earth_item);
        event.register(Registries.f_256747_, new ResourceLocation(MODID, "blessed_flower"), () -> BlessedFlowerBlock.blessed_flower);
        event.register(Registries.f_256913_, new ResourceLocation(MODID, "blessed_flower"), () -> BlessedFlowerBlock.blessed_flower_item);
    }

    private void rose(PlayerInteractEvent.RightClickBlock e) {
        if (!((Boolean)ServerConfig.doItemsMakeEarth.get()).booleanValue()) {
            return;
        }
        Player p = e.getEntity();
        Level w = p.m_9236_();
        BlockPos pos = e.getPos();
        boolean isBlockSpreadable = w.m_8055_(pos).m_204336_(spreadable);
        if (p.m_6144_() && !w.m_5776_() && e.getItemStack().m_41720_() == BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation((String)ServerConfig.cursed_item.get())) && isBlockSpreadable) {
            w.m_46597_(pos, CursedEarthBlock.cursed_earth.m_49966_());
            p.m_21120_(p.m_7655_()).m_41774_(1);
            e.setCanceled(true);
        }
        if (p.m_6144_() && !w.m_5776_() && e.getItemStack().m_41720_() == BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation((String)ServerConfig.blessed_item.get())) && isBlockSpreadable) {
            w.m_46597_(pos, BlessedEarthBlock.blessed_earth.m_49966_());
            p.m_21120_(p.m_7655_()).m_41774_(1);
            e.setCanceled(true);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair2.getRight();
        CLIENT = (ClientConfig)specPair2.getLeft();
    }

    public static class ServerConfig {
        public static ForgeConfigSpec.IntValue minTickTime;
        public static ForgeConfigSpec.IntValue maxTickTime;
        public static ForgeConfigSpec.IntValue burnLightLevel;
        public static ForgeConfigSpec.BooleanValue forceSpawn;
        public static ForgeConfigSpec.BooleanValue diesFromLightLevel;
        public static ForgeConfigSpec.BooleanValue naturallySpreads;
        public static ForgeConfigSpec.IntValue spawnRadius;
        public static ForgeConfigSpec.BooleanValue doItemsMakeEarth;
        public static ForgeConfigSpec.ConfigValue<String> cursed_item;
        public static ForgeConfigSpec.ConfigValue<String> blessed_item;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            minTickTime = builder.comment("minimum time between spawns in ticks").defineInRange("min tick time", 100, 1, Integer.MAX_VALUE);
            maxTickTime = builder.comment("maximum time between spawns in ticks").defineInRange("max tick time", 600, 1, Integer.MAX_VALUE);
            burnLightLevel = builder.comment("the light level above which cursed earth blocks burn - default 7 - allowed values 1 to 15").defineInRange("burn light level", 7, 1, 15);
            forceSpawn = builder.comment("Force spawns to occur regardless of conditions such as light level and elevation").define("force spawns", false);
            diesFromLightLevel = builder.comment("does cursed earth die from light levels").define("dies from light level", true);
            naturallySpreads = builder.comment("does cursed earth naturally spread").define("naturally spreads", true);
            doItemsMakeEarth = builder.comment("do the items set as 'cursed item' and 'blessed item' make earths - set false to disable").define("do items make earth", true);
            spawnRadius = builder.comment("minimum distance cursed earth has to be away from players before it spawns mobs").defineInRange("spawn radius", 1, 1, Integer.MAX_VALUE);
            cursed_item = builder.comment("item used to create cursed earth").define("cursed_item", (Object)BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_41951_).toString(), o -> {
                String s;
                return o instanceof String && BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s = (String)o)).isPresent();
            });
            blessed_item = builder.comment("item used to create blessed earth").define("blessed_item", (Object)"cursedearth:blessed_flower".toString(), o -> {
                String s;
                return o instanceof String && BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s = (String)o)).isPresent();
            });
            builder.pop();
        }
    }

    public static class ClientConfig {
        public static ForgeConfigSpec.ConfigValue<String> color_cursed_earth;
        public static ForgeConfigSpec.ConfigValue<String> color_blessed_earth;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            color_cursed_earth = builder.comment("Color of cursed earth, pick #CC00FF classic style color, pick #222222 for brighter newage color, or any hex code color you would like.").define("color_cursed_earth", (Object)"#CC00FF", String.class::isInstance);
            color_blessed_earth = builder.comment("Color of blessed earth, default value is #00BCD4").define("color_blessed_earth", (Object)"#00BCD4", String.class::isInstance);
            builder.pop();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Colors {
        @SubscribeEvent
        public static void color(FMLClientSetupEvent e) {
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            BlockColor iBlockColor = (blockState, iEnviromentBlockReader, blockPos, i) -> Integer.decode((String)ClientConfig.color_cursed_earth.get());
            BlockColor jBlockColor = (blockState, iEnviromentBlockReader, blockPos, i) -> Integer.decode((String)ClientConfig.color_blessed_earth.get());
            blockColors.m_92589_(iBlockColor, new Block[]{CursedEarthBlock.cursed_earth});
            blockColors.m_92589_(jBlockColor, new Block[]{BlessedEarthBlock.blessed_earth});
            ItemColors cursed_itemColors = Minecraft.m_91087_().getItemColors();
            ItemColors blessed_itemColors = Minecraft.m_91087_().getItemColors();
            ItemColor cursed_itemBlockColor = (stack, tintIndex) -> {
                BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
                return blockColors.m_92577_(state, null, null, tintIndex);
            };
            ItemColor blessed_itemBlockColor = (stack, tintIndex) -> {
                BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
                return blockColors.m_92577_(state, null, null, tintIndex);
            };
            cursed_itemColors.m_92689_(cursed_itemBlockColor, new ItemLike[]{CursedEarthBlock.cursed_earth});
            blessed_itemColors.m_92689_(blessed_itemBlockColor, new ItemLike[]{BlessedEarthBlock.blessed_earth});
        }
    }
}

