/*
 * Decompiled with CFR 0.152.
 */
package nanonestor.cursedearth;

import java.util.List;
import nanonestor.cursedearth.CursedEarth;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class CursedEarthBlock
extends GrassBlock {
    public static final Block cursed_earth = new CursedEarthBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50440_));
    public static final Item cursed_earth_item = new BlockItem(cursed_earth, new Item.Properties());

    public CursedEarthBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        this.schedule(pos, level);
    }

    public void schedule(BlockPos pos, Level level) {
        int maxTime = (Integer)CursedEarth.ServerConfig.maxTickTime.get();
        int minTime = (Integer)CursedEarth.ServerConfig.minTickTime.get();
        level.m_186460_(pos, (Block)this, level.f_46441_.m_188503_(maxTime - minTime));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41619_() && player.m_6144_()) {
            if (!level.f_46443_) {
                MutableComponent names = Component.m_237113_((String)"");
                ServerChunkCache s = (ServerChunkCache)level.m_7726_();
                List<MobSpawnSettings.SpawnerData> entries = s.m_8481_().m_223133_(level.m_204166_(pos), ((ServerLevel)level).m_215010_(), MobCategory.MONSTER, pos.m_7494_()).m_146338_().stream().filter(spawners -> !spawners.f_48404_.m_204039_(CursedEarth.blacklisted_entities)).toList();
                if (entries.isEmpty()) {
                    player.m_5661_((Component)Component.m_237115_((String)"text.cursedearth.nospawns").m_130940_(ChatFormatting.GOLD), true);
                } else {
                    names.m_7220_((Component)Component.m_237113_((String)"Cursed Earth Spawning Mobs: ").m_130940_(ChatFormatting.DARK_PURPLE));
                    for (int i = 0; i < entries.size(); ++i) {
                        MobSpawnSettings.SpawnerData spawners2 = entries.get(i);
                        MutableComponent this_name = (MutableComponent)spawners2.f_48404_.m_20676_();
                        names.m_7220_((Component)this_name.m_130940_(ChatFormatting.GOLD));
                        if (i >= entries.size() - 1) continue;
                        names.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.AQUA));
                    }
                    player.m_5661_((Component)names, false);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123783_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 60, 0.5, 1.2, 0.5, 0.05);
                    }
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_) {
            boolean dark;
            this.schedule(pos, (Level)level);
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            boolean bl = dark = level.m_46803_(pos.m_7494_()) < (Integer)CursedEarth.ServerConfig.burnLightLevel.get();
            if (!dark && ((Boolean)CursedEarth.ServerConfig.diesFromLightLevel.get()).booleanValue()) {
                level.m_46597_(pos, Blocks.f_50493_.m_49966_());
                BlockPos up = pos.m_7494_();
                if (level.m_8055_(up).m_60795_()) {
                    level.m_46597_(up, Blocks.f_50083_.m_49966_());
                }
            } else if (dark && ((Boolean)CursedEarth.ServerConfig.naturallySpreads.get()).booleanValue() && level.m_8055_(pos.m_7494_()).m_60795_()) {
                BlockState blockstate = this.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    BlockPos pos1 = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                    if (!level.m_8055_(pos1).m_204336_(CursedEarth.spreadable) || !level.m_8055_(pos1.m_7494_()).m_60795_()) continue;
                    level.m_46597_(pos1, (BlockState)blockstate.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(pos1.m_7494_()).m_60734_() == Blocks.f_50125_)));
                }
            }
            if (!level.m_6425_(pos.m_7494_()).m_76178_()) {
                return;
            }
            if (level.m_6106_().m_5472_() == Difficulty.PEACEFUL) {
                return;
            }
            int r = (Integer)CursedEarth.ServerConfig.spawnRadius.get();
            if (level.m_45976_(Player.class, new AABB((double)(-r), (double)(-r), (double)(-r), (double)r, (double)r, (double)r)).size() > 0) {
                return;
            }
            Entity en = this.findMonsterToSpawn(level, pos.m_7494_(), random);
            if (en != null) {
                en.m_6034_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                if (!level.m_45786_(en) || !level.m_45784_(en)) {
                    return;
                }
                level.m_7967_(en);
            }
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean p_176473_4_) {
        return false;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    private Entity findMonsterToSpawn(ServerLevel level, BlockPos pos, RandomSource rand) {
        ServerChunkCache s = level.m_7726_();
        List<MobSpawnSettings.SpawnerData> spawnOptions = s.m_8481_().m_223133_(level.m_204166_(pos), level.m_215010_(), MobCategory.MONSTER, pos).m_146338_().stream().filter(spawners -> !spawners.f_48404_.m_204039_(CursedEarth.blacklisted_entities)).toList();
        if (spawnOptions.isEmpty()) {
            return null;
        }
        int found = rand.m_188503_(spawnOptions.size());
        MobSpawnSettings.SpawnerData entry = spawnOptions.get(found);
        if (!SpawnPlacements.m_217074_((EntityType)entry.f_48404_, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)level.f_46441_) && !((Boolean)CursedEarth.ServerConfig.forceSpawn.get()).booleanValue()) {
            return null;
        }
        EntityType type = entry.f_48404_;
        Entity ent = type.m_20615_((Level)level);
        if (ent instanceof Mob) {
            ((Mob)ent).m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.NATURAL, null, null);
        }
        return ent;
    }
}

