/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.detail.BlockCategories;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Networking;
import wile.rsgauges.libmc.detail.OptionalRecipeCondition;
import wile.rsgauges.libmc.detail.Overlay;
import wile.rsgauges.libmc.detail.PlayerBlockInteraction;
import wile.rsgauges.libmc.detail.Registries;

@Mod(value="rsgauges")
public class ModRsGauges {
    public static final String MODID = "rsgauges";
    public static final String MODNAME = "Gauges and Switches";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogManager.getLogger();

    public ModRsGauges() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        Registries.init(MODID, "industrial_small_lever");
        ModContent.init(MODID);
        OptionalRecipeCondition.init(MODID, LOGGER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PlayerBlockInteraction.init(MODID, LOGGER);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == Registries.RSGAUGES_TAB.get()) {
            List<Block> blocks = Registries.getRegisteredBlocks();
            List<Item> items = Registries.getRegisteredItems();
            blocks.forEach(b -> event.m_246326_((ItemLike)b));
            items.forEach(i -> event.m_246326_((ItemLike)i));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        public static void onSetup(FMLCommonSetupEvent event) {
            CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
            Networking.init(ModRsGauges.MODID);
            BlockCategories.update();
        }

        public static void onClientSetup(FMLClientSetupEvent event) {
            Overlay.register();
            ModContent.processContentClientSide(event);
        }

        @SubscribeEvent
        public static void onConfigLoad(ModConfigEvent.Loading event) {
            ModConfig.apply();
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            try {
                Auxiliaries.logger().info("Config file changed {}", (Object)event.getConfig().getFileName());
                ModConfig.apply();
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }
    }
}

