/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.AutoSwitchBlock;
import wile.rsgauges.blocks.EnvironmentalSensorSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class ComparatorSwitchBlock
extends AutoSwitchBlock {
    public ComparatorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public ComparatorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isAffectedByNeigbour(state, (LevelAccessor)world, pos, fromPos)) {
            return;
        }
        AutoSwitchBlock.AutoSwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (!(te instanceof ComparatorSwitchTileEntity)) {
            return;
        }
        ((ComparatorSwitchTileEntity)te).block_updated();
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ComparatorSwitchTileEntity(pos, state);
    }

    @Override
    public Optional<Integer> switchLinkOutputPower(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof ComparatorSwitchTileEntity)) {
            return Optional.empty();
        }
        return Optional.of(((ComparatorSwitchTileEntity)te).link_output_power());
    }

    public static class ComparatorSwitchTileEntity
    extends EnvironmentalSensorSwitchBlock.EnvironmentalSensorSwitchTileEntity {
        private int link_output_power_ = 0;
        private static final Acquisition[] acquisitions = new Acquisition[]{(world, pos, state, side) -> !state.m_60807_() ? -1 : state.m_60674_(world, pos), (world, pos, state, side) -> {
            BlockEntity te = world.m_7702_(pos);
            if (te == null) {
                return -1;
            }
            if (te instanceof Container) {
                Container inventory = (Container)te;
                int size = inventory.m_6643_();
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += inventory.m_8020_(i).m_41619_() ? 0 : 1;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            IItemHandler handler = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
            if (handler == null) {
                return -1;
            }
            int size = handler.getSlots();
            if (size == 0) {
                return 0;
            }
            int n = 0;
            for (int i = 0; i < size; ++i) {
                n += handler.getStackInSlot(i).m_41619_() ? 0 : 1;
            }
            return (int)Math.round((double)n * 15.0 / (double)size);
        }, (world, pos, state, side) -> {
            BlockEntity te = world.m_7702_(pos);
            if (te == null) {
                return -1;
            }
            if (te instanceof Container) {
                Container inventory = (Container)te;
                int size = inventory.m_6643_();
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += inventory.m_8020_(i).m_41619_() ? 1 : 0;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            IItemHandler handler = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
            if (handler == null) {
                return -1;
            }
            int size = handler.getSlots();
            if (size == 0) {
                return 0;
            }
            int n = 0;
            for (int i = 0; i < size; ++i) {
                n += handler.getStackInSlot(i).m_41619_() ? 1 : 0;
            }
            return (int)Math.round((double)n * 15.0 / (double)size);
        }, (world, pos, state, side) -> world.m_277185_(pos, side)};

        public int link_output_power() {
            return this.link_output_power_;
        }

        public ComparatorSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_COMPARATOR_SWITCH, pos, state);
        }

        private int acquisition_mode() {
            return this.debounce();
        }

        private void acquisition_mode(int mode) {
            this.debounce(Mth.m_14045_((int)mode, (int)0, (int)(acquisitions.length - 1)));
        }

        public void block_updated() {
            if (this.update_timer_ > 1) {
                this.update_timer_ = 1;
            }
        }

        @Override
        public void reset(LevelReader world) {
            super.reset(world);
            this.setpower(15);
            this.threshold0_on(1.0);
            this.threshold0_off(0.0);
            this.debounce(0);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            SwitchBlock block = (SwitchBlock)state.m_60734_();
            int n = y >= 9.0 ? 1 : (direction = y <= 6.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                switch (field) {
                    case 1: {
                        double v = this.threshold0_on() + (double)direction;
                        if (v < 1.0) {
                            v = 1.0;
                        } else if (v > 15.0) {
                            v = 15.0;
                        }
                        this.threshold0_on(v);
                        if (!(this.threshold0_on() < this.threshold0_off())) break;
                        this.threshold0_off(this.threshold0_on());
                        break;
                    }
                    case 2: {
                        double v = this.threshold0_off() + (double)direction;
                        if (v < 0.0) {
                            v = 0.0;
                        } else if (v > 14.0) {
                            v = 14.0;
                        }
                        this.threshold0_off(v);
                        if (!(this.threshold0_off() > this.threshold0_on())) break;
                        this.threshold0_on(this.threshold0_off());
                        break;
                    }
                    case 3: {
                        this.acquisition_mode(this.acquisition_mode() + direction);
                        break;
                    }
                    case 4: {
                        this.setpower(this.setpower() + direction);
                    }
                }
                if (this.setpower() < 1) {
                    this.setpower(1);
                }
                this.m_6596_();
            }
            MutableComponent separator = Component.m_237113_((String)" | ");
            separator.m_130940_(ChatFormatting.GRAY);
            ArrayList<MutableComponent> tr = new ArrayList<MutableComponent>();
            tr.add(Auxiliaries.localizable("switchconfig.comparator_switch.threshold_on", ChatFormatting.BLUE, new Object[]{(int)this.threshold0_on()}));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.comparator_switch.threshold_off", ChatFormatting.YELLOW, new Object[]{(int)this.threshold0_off()})));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.comparator_switch.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.comparator_switch.mode" + this.acquisition_mode(), ChatFormatting.DARK_GREEN, new Object[0])));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.comparator_switch.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
            Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.comparator_switch", ChatFormatting.RESET, tr.toArray()));
            return true;
        }

        @Override
        public int power(BlockState state, boolean strong) {
            return this.acquisition_mode() == 3 ? 0 : super.power(state, strong);
        }

        @Override
        public void tick() {
            boolean last_active;
            if (!this.m_58898_() || this.m_58904_().m_5776_() || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = Mth.m_14045_((int)ModConfig.comparator_switch_update_interval, (int)1, (int)10);
            BlockState state = this.m_58900_();
            if (!(state.m_60734_() instanceof ComparatorSwitchBlock)) {
                return;
            }
            boolean active = last_active = ((Boolean)state.m_61143_((Property)SwitchBlock.POWERED)).booleanValue();
            Direction facing = (Direction)state.m_61143_((Property)RsDirectedBlock.FACING);
            BlockPos adjacent_pos = this.m_58899_().m_121945_(facing.m_122424_());
            BlockState adjacent_state = this.m_58904_().m_8055_(adjacent_pos);
            this.acquisition_mode(this.acquisition_mode());
            int value = Mth.m_14045_((int)acquisitions[this.acquisition_mode()].sample(this.f_58857_, adjacent_pos, adjacent_state, facing), (int)-1, (int)15);
            int last_link_output_power = this.link_output_power_;
            if (value < 0) {
                active = false;
                this.update_timer_ = 20;
                this.link_output_power_ = 0;
            } else {
                this.link_output_power_ = value;
                int measurement = 0;
                if (this.threshold0_off() >= this.threshold0_on()) {
                    measurement += (double)value == this.threshold0_on() ? 1 : -1;
                } else {
                    if ((double)value >= this.threshold0_on()) {
                        measurement = 1;
                    }
                    if ((double)value <= this.threshold0_off()) {
                        measurement = -1;
                    }
                }
                this.debounce_counter_ += measurement;
                if (this.debounce_counter_ <= 0) {
                    active = false;
                    this.debounce_counter_ = 0;
                } else if (this.debounce_counter_ >= 2) {
                    active = true;
                    this.debounce_counter_ = 2;
                }
            }
            this.updateSwitchState(state, (ComparatorSwitchBlock)state.m_60734_(), active, 0, false);
            if (!(this.link_output_power_ == last_link_output_power && last_active == active || this.activateSwitchLinks(this.link_output_power_, active ? 15 : 0, last_active != active))) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.f_58857_, this.f_58858_);
            }
        }

        private static interface Acquisition {
            public int sample(Level var1, BlockPos var2, BlockState var3, Direction var4);
        }
    }
}

